/*
 * Decompiled with CFR 0.152.
 */
package com.franz.util;

import java.util.Iterator;
import org.eclipse.rdf4j.common.iteration.Iteration;

public final class Util {
    private static final String CAT_SEPARATOR = ":";

    private Util() {
    }

    public static <T> Iterable<T> iter(final Iteration<T, ? extends RuntimeException> i) {
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public T next() {
                return i.next();
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    public static String getCatalogFromSpec(String repoAndCatalog) {
        String[] components = repoAndCatalog.split(CAT_SEPARATOR, 2);
        return components.length == 1 ? null : components[0];
    }

    public static String getRepoFromSpec(String repoAndCatalog) {
        String[] components = repoAndCatalog.split(CAT_SEPARATOR, 2);
        return components[components.length - 1];
    }

    public static int mismatch(int[] a, int[] b) {
        int n = Math.min(a.length, b.length);
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            return i;
        }
        return a.length != b.length ? n : -1;
    }

    public static int compare(int[] a, int[] b) {
        int m = Util.mismatch(a, b);
        if (m >= 0 && m < a.length && m < b.length) {
            return Integer.compare(a[m], b[m]);
        }
        return Integer.compare(a.length, b.length);
    }
}

