/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.exception.AGMalformedDataException;
import com.franz.agraph.http.exception.AGMalformedQueryException;
import com.franz.agraph.http.exception.AGPreconditionFailedException;
import com.franz.agraph.http.exception.AGQueryTimeoutException;
import com.franz.agraph.http.exception.AGUnsupportedFileFormatException;
import com.franz.agraph.http.exception.AGUnsupportedQueryLanguageException;
import com.franz.agraph.http.handler.AGResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class AGErrorHandler
extends AGResponseHandler {
    public static final String MALFORMED_QUERY = "MALFORMED QUERY";
    public static final String MALFORMED_DATA = "MALFORMED DATA";
    public static final String UNSUPPORTED_QUERY_LANGUAGE = "UNSUPPORTED QUERY LANGUAGE";
    public static final String UNSUPPORTED_FILE_FORMAT = "UNSUPPORTED FILE FORMAT";
    public static final String PRECONDITION_FAILED = "PRECONDITION FAILED";
    public static final String IO_EXCEPTION = "IO EXCEPTION";
    public static final String QUERY_TIMEOUT = "QUERY TIMEOUT";
    private AGHttpException result = null;

    public AGErrorHandler() {
        super("text/plain");
    }

    protected static AGHttpException newException(String errorString) {
        int colonIdx = errorString.indexOf(58);
        if (colonIdx >= 0) {
            String type = errorString.substring(0, colonIdx).trim();
            String message = errorString.substring(colonIdx + 1);
            switch (type) {
                case "MALFORMED DATA": {
                    return new AGMalformedDataException(message);
                }
                case "MALFORMED QUERY": {
                    return new AGMalformedQueryException(message);
                }
                case "PRECONDITION FAILED": {
                    return new AGPreconditionFailedException(message);
                }
                case "UNSUPPORTED FILE FORMAT": {
                    return new AGUnsupportedFileFormatException(message);
                }
                case "UNSUPPORTED QUERY LANGUAGE": {
                    return new AGUnsupportedQueryLanguageException(message);
                }
                case "QUERY TIMEOUT": {
                    return new AGQueryTimeoutException(message);
                }
            }
        }
        return new AGHttpException(errorString);
    }

    @Override
    public void handleResponse(HttpResponse httpResponse, HttpUriRequest httpUriRequest) throws IOException, AGHttpException {
        InputStream response = AGErrorHandler.getInputStream(httpResponse);
        String errorString = AGErrorHandler.streamToString(response);
        this.result = !errorString.isEmpty() ? AGErrorHandler.newException(errorString) : new AGHttpException(httpResponse.getStatusLine().getStatusCode() + " " + httpResponse.getStatusLine().getReasonPhrase());
    }

    public AGHttpException getResult() {
        return this.result;
    }
}

