/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class AGLongHandler
extends AGResponseHandler {
    private long result;

    public AGLongHandler() {
        super("text/integer");
    }

    @Override
    public void handleResponse(HttpResponse httpResponse, HttpUriRequest httpUriRequest) throws IOException, AGHttpException {
        InputStream response = AGLongHandler.getInputStream(httpResponse);
        try {
            if (response == null) {
                this.result = 0L;
            } else {
                String str = AGLongHandler.streamToString(response);
                this.result = Long.parseLong(str);
            }
        }
        catch (NumberFormatException e) {
            throw new AGHttpException("Server responded with invalid long value: " + e.getLocalizedMessage(), e);
        }
    }

    public long getResult() {
        return this.result;
    }
}

