/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.http.handler.AGTQRStreamer;
import com.franz.agraph.repository.AGValueFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.UnsupportedQueryResultFormatException;

public class AGTQRTSVStreamer
extends AGTQRStreamer {
    private InputStream in;

    public AGTQRTSVStreamer(AGValueFactory vf) {
        super(TupleQueryResultFormat.TSV.getDefaultMIMEType());
        this.vf = vf;
    }

    @Override
    public String getRequestMIMEType() {
        return TupleQueryResultFormat.TSV.getDefaultMIMEType();
    }

    @Override
    public void handleResponse(HttpResponse httpResponse, HttpUriRequest httpUriRequest) throws IOException, AGHttpException {
        this.method = httpResponse;
        this.in = AGResponseHandler.getInputStream(httpResponse);
    }

    @Override
    public TupleQueryResult getResult() {
        return new Result();
    }

    private class Result
    implements TupleQueryResult {
        private BindingSet next;
        private InputStreamReader r;
        private BufferedReader reader;
        private List<String> bindingNames;

        public Result() {
            this.r = new InputStreamReader(AGTQRTSVStreamer.this.in, Charset.forName("UTF-8"));
            this.reader = new BufferedReader(this.r);
        }

        public List<String> getBindingNames() {
            this.parseBindingNames();
            return this.bindingNames;
        }

        public void remove() throws QueryEvaluationException {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.parse();
            }
            return this.next != null;
        }

        public BindingSet next() throws QueryEvaluationException {
            if (this.hasNext()) {
                BindingSet curr = this.next;
                this.next = null;
                return curr;
            }
            throw new NoSuchElementException();
        }

        public void close() throws QueryEvaluationException {
            EntityUtils.consumeQuietly((HttpEntity)AGTQRTSVStreamer.this.method.getEntity());
        }

        private void parseBindingNames() {
            if (this.bindingNames == null) {
                String nextLine = this.readNextLine();
                String[] lineTokens = nextLine.split("\t", -1);
                this.bindingNames = new ArrayList<String>(lineTokens.length);
                for (String name : lineTokens) {
                    if ('?' == name.charAt(0)) {
                        this.bindingNames.add(name.substring(1));
                        continue;
                    }
                    this.bindingNames.add(name);
                }
            }
        }

        private String readNextLine() {
            try {
                return this.reader.readLine();
            }
            catch (IOException e) {
                throw new UnsupportedQueryResultFormatException((Throwable)e);
            }
        }

        public BindingSet parse() throws QueryResultParseException, TupleQueryResultHandlerException {
            this.parseBindingNames();
            String nextLine = this.readNextLine();
            if (nextLine == null) {
                return null;
            }
            String[] lineTokens = nextLine.split("\t", -1);
            ArrayList<Value> values = new ArrayList<Value>();
            for (String valueString : lineTokens) {
                BNode v = null;
                if (valueString.startsWith("_:")) {
                    v = AGTQRTSVStreamer.this.vf.createBNode(valueString.substring(2));
                } else if (valueString.startsWith("<") && valueString.endsWith(">")) {
                    try {
                        v = AGTQRTSVStreamer.this.vf.createIRI(valueString.substring(1, valueString.length() - 1));
                    }
                    catch (IllegalArgumentException var14) {
                        v = AGTQRTSVStreamer.this.vf.createLiteral(valueString);
                    }
                } else if (valueString.startsWith("\"")) {
                    v = this.parseLiteral(valueString);
                } else if (!"".equals(valueString)) {
                    if (valueString.matches("^[+\\-]?[\\d.].*")) {
                        IRI datatype = null;
                        if (XMLDatatypeUtil.isValidInteger((String)valueString)) {
                            datatype = XMLDatatypeUtil.isValidNegativeInteger((String)valueString) ? XMLSchema.NEGATIVE_INTEGER : XMLSchema.INTEGER;
                        } else if (XMLDatatypeUtil.isValidDecimal((String)valueString)) {
                            datatype = XMLSchema.DECIMAL;
                        } else if (XMLDatatypeUtil.isValidDouble((String)valueString)) {
                            datatype = XMLSchema.DOUBLE;
                        }
                        v = datatype != null ? AGTQRTSVStreamer.this.vf.createLiteral(valueString, datatype) : AGTQRTSVStreamer.this.vf.createLiteral(valueString);
                    } else {
                        v = AGTQRTSVStreamer.this.vf.createLiteral(valueString);
                    }
                }
                values.add(AGHttpRepoClient.getApplicationValue((Value)v, AGTQRTSVStreamer.this.vf));
            }
            return new ListBindingSet(this.bindingNames, values.toArray(new Value[values.size()]));
        }

        private Literal parseLiteral(String literal) throws IllegalArgumentException {
            int endLabelIdx;
            if (literal.startsWith("\"") && (endLabelIdx = this.findEndOfLabel(literal)) != -1) {
                int startLangIdx = literal.indexOf("@", endLabelIdx);
                int startDtIdx = literal.indexOf("^^", endLabelIdx);
                if (startLangIdx != -1 && startDtIdx != -1) {
                    throw new IllegalArgumentException("Literals can not have both a language and a datatype");
                }
                String label = literal.substring(1, endLabelIdx);
                label = this.decodeString(label);
                if (startLangIdx != -1) {
                    String datatype = literal.substring(startLangIdx + 1);
                    return AGTQRTSVStreamer.this.vf.createLiteral(label, datatype);
                }
                if (startDtIdx != -1) {
                    String datatype = literal.substring(startDtIdx + 2);
                    datatype = datatype.substring(1, datatype.length() - 1);
                    IRI dtURI = AGTQRTSVStreamer.this.vf.createIRI(datatype);
                    return AGTQRTSVStreamer.this.vf.createLiteral(label, dtURI);
                }
                return AGTQRTSVStreamer.this.vf.createLiteral(label);
            }
            throw new IllegalArgumentException("Not a legal literal: " + literal);
        }

        private int findEndOfLabel(String literal) {
            return literal.lastIndexOf("\"");
        }

        private String decodeString(String s) {
            int backSlashIdx = s.indexOf(92);
            if (backSlashIdx == -1) {
                return s;
            }
            int startIdx = 0;
            int sLength = s.length();
            StringBuilder sb = new StringBuilder(sLength);
            while (backSlashIdx != -1) {
                sb.append(s.substring(startIdx, backSlashIdx));
                if (backSlashIdx + 1 >= sLength) {
                    throw new IllegalArgumentException("Unescaped backslash in: " + s);
                }
                char c = s.charAt(backSlashIdx + 1);
                if (c == 't') {
                    sb.append('\t');
                    startIdx = backSlashIdx + 2;
                } else if (c == 'r') {
                    sb.append('\r');
                    startIdx = backSlashIdx + 2;
                } else if (c == 'n') {
                    sb.append('\n');
                    startIdx = backSlashIdx + 2;
                } else if (c == '\"') {
                    sb.append('\"');
                    startIdx = backSlashIdx + 2;
                } else if (c == '>') {
                    sb.append('>');
                    startIdx = backSlashIdx + 2;
                } else if (c == '\\') {
                    sb.append('\\');
                    startIdx = backSlashIdx + 2;
                } else {
                    String xx;
                    if (c == 'u') {
                        if (backSlashIdx + 5 >= sLength) {
                            throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                        }
                        xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                        try {
                            c = (char)Integer.parseInt(xx, 16);
                            sb.append(c);
                            startIdx = backSlashIdx + 6;
                        }
                        catch (NumberFormatException var9) {
                            throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                        }
                    }
                    if (c != 'U') {
                        throw new IllegalArgumentException("Unescaped backslash in: " + s);
                    }
                    if (backSlashIdx + 9 >= sLength) {
                        throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                    }
                    xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                    try {
                        sb.appendCodePoint(Integer.parseInt(xx, 16));
                        startIdx = backSlashIdx + 10;
                    }
                    catch (NumberFormatException var8) {
                        throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                    }
                }
                backSlashIdx = s.indexOf(92, startIdx);
            }
            sb.append(s.substring(startIdx));
            return sb.toString();
        }
    }
}

