/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGReasoner;
import com.franz.agraph.jena.AGUnsupportedOperationException;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGVirtualRepository;
import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.Derivation;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ValidityReport;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.RepositoryException;

public class AGInfGraph
extends AGGraph
implements InfGraph {
    private final AGReasoner reasoner;
    private final AGGraph rawGraph;
    AGVirtualRepository infRepo;

    AGInfGraph(AGReasoner reasoner, AGGraph rawGraph) {
        super(rawGraph.getGraphMaker(), rawGraph.getGraphContext(), new Resource[0]);
        this.reasoner = reasoner;
        this.rawGraph = rawGraph;
        this.entailmentRegime = reasoner.getEntailmentRegime();
        if (rawGraph.getGraphContexts().length > 0) {
            AGAbstractRepository repo = rawGraph.getConnection().getRepository();
            String infSpec = AGVirtualRepository.reasoningSpec(AGVirtualRepository.filteredSpec(repo, rawGraph.getGraphContexts()), this.entailmentRegime);
            this.infRepo = repo.getCatalog().getServer().virtualRepository(infSpec);
            try {
                this.conn = this.infRepo.getConnection();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
            this.vf = this.conn.getValueFactory();
        } else {
            this.infRepo = null;
        }
    }

    @Override
    public void close() {
        if (this.infRepo != null) {
            try {
                this.conn.close();
                this.infRepo.close();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
        super.close();
    }

    @Override
    protected Dataset getDataset() {
        return new SimpleDataset();
    }

    public ExtendedIterator<Triple> find(Node subject, Node property, Node object, Graph param) {
        throw new AGUnsupportedOperationException();
    }

    public Graph getDeductionsGraph() {
        throw new AGUnsupportedOperationException();
    }

    public Iterator<Derivation> getDerivation(Triple triple) {
        throw new AGUnsupportedOperationException();
    }

    public Node getGlobalProperty(Node property) {
        throw new AGUnsupportedOperationException();
    }

    public AGGraph getRawGraph() {
        return this.rawGraph;
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public void prepare() {
    }

    public void rebind() {
    }

    public void rebind(Graph data) {
    }

    public void reset() {
    }

    public void setDerivationLogging(boolean logOn) {
        throw new AGUnsupportedOperationException();
    }

    public boolean testGlobalProperty(Node property) {
        throw new AGUnsupportedOperationException();
    }

    public ValidityReport validate() {
        throw new AGUnsupportedOperationException();
    }
}

