/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGExecutionAbortedException;
import com.franz.agraph.jena.AGInfGraph;
import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGNodeFactory;
import com.franz.agraph.jena.AGQuery;
import com.franz.agraph.jena.AGResultSet;
import com.franz.agraph.jena.AGUnsupportedOperationException;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGGraphQuery;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.agraph.repository.AGUpdate;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UpdateExecutionException;

public class AGQueryExecution
implements QueryExecution,
Closeable {
    private static final long TIMEOUT_UNSET = -1L;
    private final AGQuery query;
    private final AGModel model;
    protected long timeout = -1L;
    private QuerySolution binding;
    private boolean closed = false;
    private QueryResult<?> resultToClose;

    public AGQueryExecution(AGQuery query, AGModel model) {
        this.query = query;
        this.model = model;
    }

    public void abort() {
        throw new AGExecutionAbortedException();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.resultToClose != null) {
                this.resultToClose.close();
                this.resultToClose = null;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean execAsk() {
        boolean result;
        if (this.query.getLanguage() != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException(this.query.getLanguage().getName() + " language does not support ASK queries.");
        }
        AGBooleanQuery bq = this.model.getGraph().getConnection().prepareBooleanQuery(this.query.getLanguage(), this.query.getQueryString());
        bq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        bq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        bq.setCheckVariables(this.query.isCheckVariables());
        if (this.binding != null) {
            Iterator vars = this.binding.varNames();
            while (vars.hasNext()) {
                String var = (String)vars.next();
                bq.setBinding(var, this.model.getGraph().vf.asValue(this.binding.get(var).asNode()));
            }
        }
        try {
            bq.setDataset(this.model.getGraph().getDataset());
            if (this.timeout > 0L) {
                bq.setMaxExecutionTime((int)(this.timeout / 1000L));
            }
            result = bq.evaluate();
        }
        catch (QueryEvaluationException e) {
            throw new QueryException((Throwable)e);
        }
        return result;
    }

    public JsonArray execJson() {
        throw new AGUnsupportedOperationException();
    }

    public Iterator<JsonObject> execJsonItems() {
        throw new AGUnsupportedOperationException();
    }

    public Model execConstruct() {
        return this.execConstruct(null);
    }

    private GraphQueryResult getConstructResult() {
        GraphQueryResult result;
        if (this.query.getLanguage() != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException(this.query.getLanguage().getName() + " language does not support CONSTRUCT queries.");
        }
        AGGraphQuery gq = this.model.getGraph().getConnection().prepareGraphQuery(this.query.getLanguage(), this.query.getQueryString());
        gq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        gq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        gq.setCheckVariables(this.query.isCheckVariables());
        gq.setLimit(this.query.getLimit());
        gq.setOffset(this.query.getOffset());
        if (this.binding != null) {
            Iterator vars = this.binding.varNames();
            while (vars.hasNext()) {
                String var = (String)vars.next();
                gq.setBinding(var, this.model.getGraph().vf.asValue(this.binding.get(var).asNode()));
            }
        }
        try {
            gq.setDataset(this.model.getGraph().getDataset());
            if (this.timeout > 0L) {
                gq.setMaxExecutionTime((int)(this.timeout / 1000L));
            }
            result = gq.evaluate();
        }
        catch (QueryEvaluationException e) {
            throw new QueryException((Throwable)e);
        }
        return result;
    }

    public Model execConstruct(Model m) {
        GraphQueryResult result = this.getConstructResult();
        if (m == null) {
            m = ModelFactory.createDefaultModel();
        }
        try {
            m.setNsPrefixes(result.getNamespaces());
            while (result.hasNext()) {
                m.add(this.model.asStatement(AGNodeFactory.asTriple((Statement)result.next())));
            }
        }
        catch (QueryEvaluationException e) {
            throw new QueryException((Throwable)e);
        }
        return m;
    }

    public Model execDescribe() {
        return this.execDescribe(null);
    }

    public Model execDescribe(Model m) {
        return this.execConstruct(m);
    }

    public ResultSet execSelect() {
        TupleQueryResult result;
        AGTupleQuery tq = this.model.getGraph().getConnection().prepareTupleQuery(this.query.getLanguage(), this.query.getQueryString());
        tq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        tq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        tq.setCheckVariables(this.query.isCheckVariables());
        tq.setLimit(this.query.getLimit());
        tq.setOffset(this.query.getOffset());
        if (this.binding != null) {
            Iterator vars = this.binding.varNames();
            while (vars.hasNext()) {
                String var = (String)vars.next();
                tq.setBinding(var, this.model.getGraph().vf.asValue(this.binding.get(var).asNode()));
            }
        }
        try {
            tq.setDataset(this.model.getGraph().getDataset());
            if (this.timeout > 0L) {
                tq.setMaxExecutionTime((int)(this.timeout / 1000L));
            }
            result = tq.evaluate();
        }
        catch (QueryEvaluationException e) {
            throw new QueryException((Throwable)e);
        }
        this.resultToClose = result;
        return new AGResultSet(result, this.model);
    }

    public void execUpdate() {
        AGUpdate u = this.model.getGraph().getConnection().prepareUpdate(this.query.getLanguage(), this.query.getQueryString());
        u.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        u.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        u.setCheckVariables(this.query.isCheckVariables());
        u.setLimit(this.query.getLimit());
        u.setOffset(this.query.getOffset());
        if (this.binding != null) {
            Iterator vars = this.binding.varNames();
            while (vars.hasNext()) {
                String var = (String)vars.next();
                u.setBinding(var, this.model.getGraph().vf.asValue(this.binding.get(var).asNode()));
            }
        }
        try {
            u.setDataset(this.model.getGraph().getDataset());
            if (this.timeout > 0L) {
                u.setMaxExecutionTime((int)(this.timeout / 1000L));
            }
            u.execute();
        }
        catch (UpdateExecutionException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public long countSelect() {
        long count;
        AGTupleQuery tq = this.model.getGraph().getConnection().prepareTupleQuery(this.query.getLanguage(), this.query.getQueryString());
        tq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        tq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        tq.setCheckVariables(this.query.isCheckVariables());
        tq.setLimit(this.query.getLimit());
        tq.setOffset(this.query.getOffset());
        tq.setDataset(this.model.getGraph().getDataset());
        if (this.binding != null) {
            Iterator vars = this.binding.varNames();
            while (vars.hasNext()) {
                String var = (String)vars.next();
                tq.setBinding(var, this.model.getGraph().vf.asValue(this.binding.get(var).asNode()));
            }
        }
        try {
            count = tq.count();
        }
        catch (QueryEvaluationException e) {
            throw new QueryException((Throwable)e);
        }
        return count;
    }

    public long countConstruct() {
        long count;
        if (this.query.getLanguage() != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException(this.query.getLanguage().getName() + " language does not support CONSTRUCT queries.");
        }
        AGGraphQuery gq = this.model.getGraph().getConnection().prepareGraphQuery(this.query.getLanguage(), this.query.getQueryString());
        gq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        gq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        gq.setCheckVariables(this.query.isCheckVariables());
        gq.setLimit(this.query.getLimit());
        gq.setOffset(this.query.getOffset());
        gq.setDataset(this.model.getGraph().getDataset());
        if (this.binding != null) {
            Iterator vars = this.binding.varNames();
            while (vars.hasNext()) {
                String var = (String)vars.next();
                gq.setBinding(var, this.model.getGraph().vf.asValue(this.binding.get(var).asNode()));
            }
        }
        try {
            count = gq.count();
        }
        catch (QueryEvaluationException e) {
            throw new QueryException((Throwable)e);
        }
        return count;
    }

    public Context getContext() {
        throw new AGUnsupportedOperationException();
    }

    public Dataset getDataset() {
        throw new AGUnsupportedOperationException();
    }

    public void setInitialBinding(QuerySolution binding) {
        this.binding = binding;
    }

    public Iterator<Triple> execConstructTriples() {
        Iterator<Triple> iterator;
        block9: {
            GraphQueryResult result = this.getConstructResult();
            try {
                ArrayList<Triple> tripleArrayList = new ArrayList<Triple>();
                while (result.hasNext()) {
                    tripleArrayList.add(AGNodeFactory.asTriple((Statement)result.next()));
                }
                iterator = tripleArrayList.iterator();
                if (result == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (QueryEvaluationException e) {
                    throw new QueryException((Throwable)e);
                }
            }
            result.close();
        }
        return iterator;
    }

    public Iterator<Triple> execDescribeTriples() {
        return this.execConstructTriples();
    }

    public Query getQuery() {
        return QueryFactory.create((String)this.query.getQueryString());
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setTimeout(long arg0, TimeUnit arg1) {
        this.timeout = arg1.toMillis(arg0);
    }

    public void setTimeout(long arg0, long arg1) {
        this.setTimeout(arg0, TimeUnit.MILLISECONDS, arg1, TimeUnit.MILLISECONDS);
    }

    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        this.timeout = this.asMillis(timeout1, timeUnit1);
    }

    public String getQueryString() {
        return this.query.getQueryString();
    }

    private long asMillis(long duration, TimeUnit timeUnit) {
        return duration < 0L ? duration : timeUnit.toMillis(duration);
    }

    public long getTimeout1() {
        throw new AGUnsupportedOperationException();
    }

    public long getTimeout2() {
        throw new AGUnsupportedOperationException();
    }

    public Iterator<Quad> execConstructQuads() {
        Iterator<Quad> iterator;
        block9: {
            GraphQueryResult result = this.getConstructResult();
            try {
                ArrayList<Quad> quadArrayList = new ArrayList<Quad>();
                while (result.hasNext()) {
                    quadArrayList.add(AGNodeFactory.asQuad((Statement)result.next()));
                }
                iterator = quadArrayList.iterator();
                if (result == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (QueryEvaluationException e) {
                    throw new QueryException((Throwable)e);
                }
            }
            result.close();
        }
        return iterator;
    }

    public Dataset execConstructDataset() {
        Dataset result = DatasetFactory.createGeneral();
        this.execConstructDataset(result);
        return result;
    }

    public Dataset execConstructDataset(Dataset dataset) {
        DatasetGraph dsg = dataset.asDatasetGraph();
        try {
            this.execConstructQuads().forEachRemaining(arg_0 -> ((DatasetGraph)dsg).add(arg_0));
        }
        finally {
            this.close();
        }
        return dataset;
    }
}

