/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGNodeFactory;
import com.franz.agraph.jena.AGNodeIterator;
import com.franz.agraph.jena.AGTripleIteratorGQ;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGGraphQuery;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.agraph.repository.AGValueFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.AlreadyReifiedException;
import org.apache.jena.shared.CannotReifyException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;

public class AGReifier {
    private AGGraph graph;

    AGReifier(AGGraph graph) {
        this.graph = graph;
    }

    public Triple getTriple(Node n) {
        String queryString = "construct {?s ?p ?o} where { ?st rdf:subject ?s . ?st rdf:predicate ?p . ?st rdf:object ?o . }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGValueFactory vf = conn.getValueFactory();
        AGGraphQuery bq = conn.prepareGraphQuery(QueryLanguage.SPARQL, queryString);
        try {
            bq.setBinding("st", vf.asValue(n));
            bq.setDataset(this.graph.getDataset());
            GraphQueryResult result = bq.evaluate();
            if (result.hasNext()) {
                Triple t = AGNodeFactory.asTriple((Statement)result.next());
                if (result.hasNext()) {
                    return null;
                }
                return t;
            }
            return null;
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }

    public ExtendedIterator<Triple> find(Triple m) {
        return this.graph.graphBaseFind(m);
    }

    public ExtendedIterator<Triple> findExposed(Triple m) {
        if (this.matchesReification(m)) {
            if (m.getMatchPredicate() != null) {
                return this.graph.graphBaseFind(m);
            }
            String queryString = "construct {?s ?p ?o} where { {?s ?p ?o . FILTER (?p = rdf:subject || ?p = rdf:predicate || ?p = rdf:object)} UNION {?s ?p ?o . FILTER (?p = rdf:type && ?o = rdf:Statement)} }";
            AGRepositoryConnection conn = this.graph.getConnection();
            AGValueFactory vf = conn.getValueFactory();
            AGGraphQuery gq = conn.prepareGraphQuery(QueryLanguage.SPARQL, queryString);
            try {
                if (m.getMatchSubject() != null) {
                    gq.setBinding("s", vf.asValue(m.getMatchSubject()));
                }
                if (m.getMatchObject() != null) {
                    gq.setBinding("o", vf.asValue(m.getMatchObject()));
                }
                gq.setDataset(this.graph.getDataset());
                GraphQueryResult result = gq.evaluate();
                return new AGTripleIteratorGQ(this.graph, result);
            }
            catch (QueryEvaluationException e) {
                throw new RuntimeException(e);
            }
        }
        return NullIterator.instance();
    }

    public ExtendedIterator<Triple> findEither(Triple m, boolean showHidden) {
        return showHidden ? NullIterator.instance() : this.find(m);
    }

    public int size() {
        return 0;
    }

    public Graph getParentGraph() {
        return this.graph;
    }

    public Node reifyAs(Node n, Triple t) {
        Triple tn = this.getTriple(n);
        if (tn != null && !tn.equals((Object)t)) {
            throw new AlreadyReifiedException(n);
        }
        if (tn == null) {
            String queryString = "select ?v { ?st ?p ?v . FILTER (?v != ?tv) }";
            AGRepositoryConnection conn = this.graph.getConnection();
            AGTupleQuery q = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
            try {
                q.setDataset(this.graph.getDataset());
                q.setBinding("st", this.graph.vf.asValue(n));
                q.setBinding("p", this.graph.vf.asValue(RDF.Nodes.subject));
                q.setBinding("tv", this.graph.vf.asValue(t.getSubject()));
                TupleQueryResult result = q.evaluate();
                if (result.hasNext()) {
                    throw new CannotReifyException(n);
                }
                q.setBinding("p", this.graph.vf.asValue(RDF.Nodes.predicate));
                q.setBinding("tv", this.graph.vf.asValue(t.getPredicate()));
                result = q.evaluate();
                if (result.hasNext()) {
                    throw new CannotReifyException(n);
                }
                q.setBinding("p", this.graph.vf.asValue(RDF.Nodes.object));
                q.setBinding("tv", this.graph.vf.asValue(t.getObject()));
                result = q.evaluate();
                if (result.hasNext()) {
                    throw new CannotReifyException(n);
                }
            }
            catch (QueryEvaluationException e) {
                throw new RuntimeException(e);
            }
            this.graph.add(Triple.create((Node)n, (Node)RDF.Nodes.subject, (Node)t.getSubject()));
            this.graph.add(Triple.create((Node)n, (Node)RDF.Nodes.predicate, (Node)t.getPredicate()));
            this.graph.add(Triple.create((Node)n, (Node)RDF.Nodes.object, (Node)t.getObject()));
            this.graph.add(Triple.create((Node)n, (Node)RDF.Nodes.type, (Node)RDF.Nodes.Statement));
        }
        return n;
    }

    public boolean hasTriple(Node n) {
        boolean result;
        String queryString = "ask { ?st rdf:type rdf:Statement . }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGValueFactory vf = conn.getValueFactory();
        AGBooleanQuery bq = conn.prepareBooleanQuery(QueryLanguage.SPARQL, queryString);
        try {
            bq.setBinding("st", vf.asValue(n));
            bq.setDataset(this.graph.getDataset());
            result = bq.evaluate();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public boolean hasTriple(Triple t) {
        boolean result;
        String queryString = "ask { ?st rdf:subject ?s . ?st rdf:predicate ?p . ?st rdf:object ?o . }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGValueFactory vf = conn.getValueFactory();
        AGBooleanQuery bq = conn.prepareBooleanQuery(QueryLanguage.SPARQL, queryString);
        try {
            bq.setBinding("s", vf.asValue(t.getSubject()));
            bq.setBinding("p", vf.asValue(t.getPredicate()));
            bq.setBinding("o", vf.asValue(t.getObject()));
            bq.setDataset(this.graph.getDataset());
            result = bq.evaluate();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public ExtendedIterator<Node> allNodes() {
        String queryString = "select ?st where { ?st rdf:type rdf:Statement }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGTupleQuery q = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        try {
            q.setDataset(this.graph.getDataset());
            TupleQueryResult result = q.evaluate();
            return new AGNodeIterator(result);
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }

    public ExtendedIterator<Node> allNodes(Triple t) {
        String queryString = "select ?st where { ?st rdf:type rdf:Statement . ?st rdf:subject ?s . ?st rdf:predicate ?p . ?st rdf:object ?o . }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGValueFactory vf = conn.getValueFactory();
        AGTupleQuery q = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        try {
            q.setDataset(this.graph.getDataset());
            q.setBinding("s", vf.asValue(t.getSubject()));
            q.setBinding("p", vf.asValue(t.getPredicate()));
            q.setBinding("o", vf.asValue(t.getObject()));
            TupleQueryResult result = q.evaluate();
            return new AGNodeIterator(result);
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(Node n, Triple t) {
        this.graph.delete(Triple.create((Node)n, (Node)RDF.Nodes.subject, (Node)t.getSubject()));
        this.graph.delete(Triple.create((Node)n, (Node)RDF.Nodes.predicate, (Node)t.getPredicate()));
        this.graph.delete(Triple.create((Node)n, (Node)RDF.Nodes.object, (Node)t.getObject()));
        this.graph.delete(Triple.create((Node)n, (Node)RDF.Nodes.type, (Node)RDF.Nodes.Statement));
    }

    public void remove(Triple t) {
        String queryString = "select { ?st rdf:type rdf:Statement . ?st rdf:subject ?s . ?st rdf:predicate ?p . ?st rdf:object ?o . }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGValueFactory vf = conn.getValueFactory();
        AGTupleQuery q = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        try {
            q.setDataset(this.graph.getDataset());
            q.setBinding("s", vf.asValue(t.getSubject()));
            q.setBinding("p", vf.asValue(t.getPredicate()));
            q.setBinding("o", vf.asValue(t.getObject()));
            TupleQueryResult result = q.evaluate();
            while (result.hasNext()) {
                this.remove(AGNodeFactory.asNode(((BindingSet)result.next()).getValue("st")), t);
            }
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean handledAdd(Triple t) {
        return false;
    }

    public boolean handledRemove(Triple t) {
        return false;
    }

    public void close() {
    }

    private boolean matchesReification(Triple m) {
        Node predicate = m.getPredicate();
        return !predicate.isConcrete() || predicate.equals((Object)RDF.Nodes.subject) || predicate.equals((Object)RDF.Nodes.predicate) || predicate.equals((Object)RDF.Nodes.object) || predicate.equals((Object)RDF.Nodes.type) && this.matchesStatement(m.getObject());
    }

    private boolean matchesStatement(Node x) {
        return !x.isConcrete() || x.equals((Object)RDF.Nodes.Statement);
    }
}

