/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGQuerySolution;
import com.franz.agraph.jena.AGUnsupportedOperationException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.engine.binding.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;

public class AGResultSet
implements ResultSet {
    private final TupleQueryResult result;
    private final AGModel model;

    public AGResultSet(TupleQueryResult result, AGModel model) {
        this.result = result;
        this.model = model;
    }

    public Model getResourceModel() {
        return this.model;
    }

    public void close() {
        this.model.close();
    }

    public List<String> getResultVars() {
        try {
            return this.result.getBindingNames();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }

    public int getRowNumber() {
        throw new AGUnsupportedOperationException();
    }

    public boolean hasNext() {
        boolean res;
        try {
            res = this.result.hasNext();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    public AGQuerySolution next() {
        BindingSet bs;
        try {
            bs = (BindingSet)this.result.next();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
        return new AGQuerySolution(bs, this.model);
    }

    public void forEachRemaining(Consumer<? super QuerySolution> action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    public Binding nextBinding() {
        throw new AGUnsupportedOperationException();
    }

    public AGQuerySolution nextSolution() {
        return this.next();
    }

    public void remove() {
        try {
            this.result.remove();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }
}

