/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.pool;

import com.franz.agraph.pool.AGConnProp;
import java.util.Map;

public class AGConnConfig {
    public final String serverUrl;
    public final String username;
    public final String password;
    public final String catalog;
    public final String repository;
    public final AGConnProp.Session session;
    public final Integer sessionLifetime;
    public final Integer httpSocketTimeout;

    public AGConnConfig(Map<AGConnProp, String> props) {
        this.serverUrl = this.getStringRequired(props, AGConnProp.serverUrl);
        this.username = this.getStringRequired(props, AGConnProp.username);
        this.password = this.getStringRequired(props, AGConnProp.password);
        this.catalog = props.get((Object)AGConnProp.catalog);
        this.repository = this.getStringRequired(props, AGConnProp.repository);
        this.session = AGConnProp.Session.valueOf(props.getOrDefault((Object)AGConnProp.session, AGConnProp.Session.SHARED.name()).toUpperCase());
        this.sessionLifetime = this.getInt(props, AGConnProp.sessionLifetime);
        this.httpSocketTimeout = this.getInt(props, AGConnProp.httpSocketTimeout);
    }

    private Integer getInt(Map<AGConnProp, String> props, AGConnProp prop) {
        if (props.containsKey((Object)prop)) {
            return Integer.parseInt(props.get((Object)prop));
        }
        return null;
    }

    private String getStringRequired(Map<AGConnProp, String> props, AGConnProp prop) {
        if (props.containsKey((Object)prop)) {
            return props.get((Object)prop);
        }
        throw new IllegalArgumentException("Property required for AGConn: " + prop);
    }
}

