/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.pool;

import com.franz.agraph.pool.AGPoolProp;
import com.franz.agraph.repository.WarmupConfig;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class AGPoolConfig
extends GenericObjectPoolConfig {
    public static final int DEFAULT_INITIAL_SIZE = 0;
    public static final boolean DEFAULT_SHUTDOWN_HOOK = false;
    public final int initialSize;
    public final boolean shutdownHook;
    private WarmupConfig warmupConfig;

    public AGPoolConfig(Map<AGPoolProp, String> props) {
        this.initialSize = props.containsKey((Object)AGPoolProp.initialSize) ? Integer.parseInt(props.get((Object)AGPoolProp.initialSize)) : 0;
        this.shutdownHook = props.containsKey((Object)AGPoolProp.shutdownHook) ? Boolean.valueOf(props.get((Object)AGPoolProp.shutdownHook)) : false;
        if (props.containsKey((Object)AGPoolProp.maxIdle)) {
            this.setMaxIdle(Integer.parseInt(props.get((Object)AGPoolProp.maxIdle)));
        }
        if (props.containsKey((Object)AGPoolProp.minIdle)) {
            this.setMinIdle(Integer.parseInt(props.get((Object)AGPoolProp.minIdle)));
        }
        if (props.containsKey((Object)AGPoolProp.maxActive)) {
            this.setMaxTotal(Integer.parseInt(props.get((Object)AGPoolProp.maxActive)));
        }
        if (props.containsKey((Object)AGPoolProp.maxWait)) {
            this.setMaxWaitMillis(Long.parseLong(props.get((Object)AGPoolProp.maxWait)));
        }
        if (props.containsKey((Object)AGPoolProp.testOnBorrow)) {
            this.setTestOnBorrow(Boolean.valueOf(props.get((Object)AGPoolProp.testOnBorrow)));
        }
        if (props.containsKey((Object)AGPoolProp.testOnReturn)) {
            this.setTestOnReturn(Boolean.valueOf(props.get((Object)AGPoolProp.testOnReturn)));
        }
        if (props.containsKey((Object)AGPoolProp.timeBetweenEvictionRunsMillis)) {
            this.setTimeBetweenEvictionRunsMillis(Long.parseLong(props.get((Object)AGPoolProp.timeBetweenEvictionRunsMillis)));
        }
        if (props.containsKey((Object)AGPoolProp.minEvictableIdleTimeMillis)) {
            this.setMinEvictableIdleTimeMillis(Long.parseLong(props.get((Object)AGPoolProp.minEvictableIdleTimeMillis)));
        }
        if (props.containsKey((Object)AGPoolProp.testWhileIdle)) {
            this.setTestWhileIdle(Boolean.valueOf(props.get((Object)AGPoolProp.testWhileIdle)));
        }
        if (props.containsKey((Object)AGPoolProp.softMinEvictableIdleTimeMillis)) {
            this.setSoftMinEvictableIdleTimeMillis(Long.parseLong(props.get((Object)AGPoolProp.softMinEvictableIdleTimeMillis)));
        }
        if (props.containsKey((Object)AGPoolProp.numTestsPerEvictionRun)) {
            this.setNumTestsPerEvictionRun(Integer.parseInt(props.get((Object)AGPoolProp.numTestsPerEvictionRun)));
        }
        if (props.containsKey((Object)AGPoolProp.lifo)) {
            this.setLifo(Boolean.valueOf(props.get((Object)AGPoolProp.lifo)));
        }
        if (Boolean.parseBoolean(props.getOrDefault((Object)AGPoolProp.warmup, "false"))) {
            boolean includeStrings = Boolean.parseBoolean(props.getOrDefault((Object)AGPoolProp.warmupIncludeStrings, "true"));
            boolean includeTriples = Boolean.parseBoolean(props.getOrDefault((Object)AGPoolProp.warmupIncludeTriples, "true"));
            this.warmupConfig = WarmupConfig.create().includeStrings(includeStrings).includeTriples(includeTriples);
        } else {
            this.warmupConfig = null;
        }
    }

    public WarmupConfig getWarmupConfig() {
        return this.warmupConfig;
    }

    public void setWarmupConfig(WarmupConfig warmupConfig) {
        this.warmupConfig = warmupConfig;
    }
}

