/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AGFreetextIndexConfig {
    public static final String PREDICATES = "predicates";
    public static final String INDEX_LITERALS = "indexLiterals";
    public static final String INDEX_LITERAL_TYPES = "indexLiteralTypes";
    public static final String INDEX_RESOURCES = "indexResources";
    public static final String INDEX_FIELDS = "indexFields";
    public static final String MINIMUM_WORD_SIZE = "minimumWordSize";
    public static final String STOP_WORDS = "stopWords";
    public static final String WORD_FILTERS = "wordFilters";
    public static final String INNER_CHARS = "innerChars";
    public static final String BORDER_CHARS = "borderChars";
    public static final String TOKENIZER = "tokenizer";
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    private List<IRI> predicates;
    private boolean indexLiterals;
    private List<String> indexLiteralTypes;
    private String indexResources;
    private List<String> indexFields;
    private int minimumWordSize;
    private List<String> stopWords;
    private List<String> wordFilters;
    private List<String> innerChars;
    private List<String> borderChars;
    private String tokenizer;

    private AGFreetextIndexConfig() {
        this.predicates = new ArrayList<IRI>();
        this.indexLiterals = true;
        this.indexLiteralTypes = new ArrayList<String>();
        this.indexResources = "false";
        this.indexFields = new ArrayList<String>();
        this.indexFields.add("object");
        this.minimumWordSize = 3;
        this.stopWords = new ArrayList<String>();
        this.wordFilters = new ArrayList<String>();
        this.innerChars = new ArrayList<String>();
        this.borderChars = new ArrayList<String>();
        this.tokenizer = "default";
    }

    AGFreetextIndexConfig(JSONObject config) {
        this.predicates = this.initPredicates(config);
        this.indexLiterals = this.initIndexLiterals(config);
        this.indexLiteralTypes = this.getJSONArrayAsListString(config, INDEX_LITERAL_TYPES);
        this.indexResources = config.optString(INDEX_RESOURCES);
        this.indexFields = this.getJSONArrayAsListString(config, INDEX_FIELDS);
        this.minimumWordSize = config.optInt(MINIMUM_WORD_SIZE);
        this.stopWords = this.getJSONArrayAsListString(config, STOP_WORDS);
        this.wordFilters = this.getJSONArrayAsListString(config, WORD_FILTERS);
        this.innerChars = this.getJSONArrayAsListString(config, INNER_CHARS);
        this.borderChars = this.getJSONArrayAsListString(config, BORDER_CHARS);
        this.tokenizer = config.optString(TOKENIZER);
    }

    public static AGFreetextIndexConfig newInstance() {
        return new AGFreetextIndexConfig();
    }

    private boolean initIndexLiterals(JSONObject config) {
        boolean bool;
        try {
            bool = config.getBoolean(INDEX_LITERALS);
        }
        catch (JSONException e) {
            bool = true;
        }
        return bool;
    }

    private List<IRI> initPredicates(JSONObject config) {
        ArrayList<IRI> predList = new ArrayList<IRI>();
        JSONArray preds = config.optJSONArray(PREDICATES);
        if (preds != null) {
            for (int i = 0; i < preds.length(); ++i) {
                String uri_nt = preds.optString(i);
                IRI uri = NTriplesUtil.parseURI((String)uri_nt, (ValueFactory)vf);
                predList.add(uri);
            }
        }
        return predList;
    }

    public List<IRI> getPredicates() {
        return this.predicates;
    }

    public boolean getIndexLiterals() {
        return this.indexLiterals;
    }

    public void setIndexLiterals(boolean bool) {
        this.indexLiterals = bool;
    }

    public List<String> getIndexLiteralTypes() {
        return this.indexLiteralTypes;
    }

    public String getIndexResources() {
        return this.indexResources;
    }

    public void setIndexResources(String str) {
        this.indexResources = str;
    }

    public List<String> getIndexFields() {
        return this.indexFields;
    }

    public int getMinimumWordSize() {
        return this.minimumWordSize;
    }

    public void setMinimumWordSize(int size) {
        this.minimumWordSize = size;
    }

    public List<String> getStopWords() {
        return this.stopWords;
    }

    public List<String> getWordFilters() {
        return this.wordFilters;
    }

    public List<String> getInnerChars() {
        return this.innerChars;
    }

    public List<String> getBorderChars() {
        return this.borderChars;
    }

    public String getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(String tokenizerName) {
        this.tokenizer = tokenizerName;
    }

    private List<String> getJSONArrayAsListString(JSONObject config, String key) {
        ArrayList<String> list = new ArrayList<String>();
        JSONArray array = config.optJSONArray(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                list.add(array.optString(i));
            }
        }
        return list;
    }

    public String toString() {
        return "<AGFreetextIndexConfig predicates: " + this.predicates + ", indexLiterals: " + this.indexLiterals + ", indexLiteralTypes: " + this.indexLiteralTypes + ", indexResources: " + this.indexResources + ", indexFields: " + this.indexFields + ", minimumWordSize: " + this.minimumWordSize + ", stopWords: " + this.stopWords.size() + ", wordFilters: " + this.wordFilters + ", innerChars: " + this.innerChars + ", borderChars: " + this.borderChars + ", tokenizer: " + this.tokenizer + ">";
    }
}

