/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGValueFactory;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.AbstractRepository;

public class AGVirtualRepository
extends AbstractRepository
implements AGAbstractRepository {
    final AGRepository wrapped;
    private final AGServer server;
    private final String spec;
    private final AGValueFactory vf;

    public AGVirtualRepository(AGServer server, String spec, AGRepository wrapped) {
        this.server = server;
        this.spec = spec;
        this.wrapped = wrapped;
        this.vf = new AGValueFactory(wrapped);
    }

    public static String federatedSpec(String[] repoSpecs) {
        for (int i = 0; i < repoSpecs.length; ++i) {
            if (repoSpecs[i].startsWith("<")) continue;
            repoSpecs[i] = "<" + repoSpecs[i] + ">";
        }
        return String.join((CharSequence)"+", repoSpecs);
    }

    public static String reasoningSpec(String repoSpec, String reasoner) {
        return AGVirtualRepository.reasoningSpec(repoSpec, reasoner, null);
    }

    public static String reasoningSpec(String repoSpec, String reasoner, Resource inferredGraph) {
        String reasoningSpec = repoSpec + "[" + reasoner;
        if (inferredGraph != null) {
            reasoningSpec = reasoningSpec + "#<" + inferredGraph.stringValue() + ">";
        }
        return reasoningSpec + "]";
    }

    public static String filteredSpec(AGAbstractRepository repo, Resource[] contexts) {
        String[] graphs = new String[contexts.length];
        for (int i = 0; i < contexts.length; ++i) {
            graphs[i] = null == contexts[i] ? null : "<" + contexts[i].stringValue() + ">";
        }
        return AGVirtualRepository.filteredSpec(repo.getSpec(), graphs);
    }

    public static String filteredSpec(String repoSpec, String[] graphs) {
        repoSpec = (String)repoSpec + "{";
        for (String graph : graphs) {
            repoSpec = (String)repoSpec + " " + graph;
        }
        return (String)repoSpec + "}";
    }

    @Override
    public AGServer getServer() {
        return this.server;
    }

    @Override
    public AGCatalog getCatalog() {
        return null;
    }

    @Override
    public String getSpec() {
        return this.spec;
    }

    public boolean isWritable() {
        return this.wrapped != null;
    }

    @Override
    public AGValueFactory getValueFactory() {
        return this.vf;
    }

    @Override
    public AGRepositoryConnection getConnection(ScheduledExecutorService executor) throws RepositoryException {
        AGHttpRepoClient repoclient;
        AGHTTPClient client = this.server.getHTTPClient();
        try {
            repoclient = new AGHttpRepoClient(this, client, null, client.openSession(this.spec, true), executor);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
        return new AGRepositoryConnection(this, repoclient);
    }

    @Override
    public AGRepositoryConnection getConnection() throws RepositoryException {
        return this.getConnection(this.server.getExecutor());
    }

    @Override
    public void close() throws RepositoryException {
        this.shutDown();
    }

    protected void initializeInternal() throws RepositoryException {
    }

    protected void shutDownInternal() throws RepositoryException {
    }

    @Deprecated
    public File getDataDir() {
        throw new UnsupportedOperationException("getDataDir is inapplicable for AG repositories");
    }

    @Deprecated
    public void setDataDir(File dataDir) {
        throw new UnsupportedOperationException("setDataDir is inapplicable for AG repositories");
    }
}

