/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGRepositoryConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.codec.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGXAResource
implements XAResource {
    AGRepositoryConnection conn;
    Logger logger = LoggerFactory.getLogger(AGXAResource.class);

    private void tryThrowAsXAException(AGHttpException e) throws XAException, AGHttpException {
        if (e.getMessage().contains("Could not find a prepared commit with xid")) {
            throw new XAException(-4);
        }
        throw e;
    }

    public AGXAResource(AGRepositoryConnection conn) {
        this.conn = conn;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AGXAResource.start() called on " + this);
            this.logger.debug("---> XID " + xid.toString());
        }
        switch (flags) {
            case 0: {
                break;
            }
            case 0x200000: {
                throw new XAException("start doesn't handle TMJOIN yet");
            }
            case 0x8000000: {
                throw new XAException("start doesn't handle TMRESUME yet");
            }
            default: {
                throw new XAException(-5);
            }
        }
        if (this.conn.isAutoCommit()) {
            throw new XAException(-9);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AGXAResource.end() called on " + this);
        }
        switch (flags) {
            case 0x4000000: {
                this.logger.debug("AGXAResource.end() called with TMSUCCESS");
                break;
            }
            case 0x20000000: {
                this.logger.debug("AGXAResource.end() called with TMFAIL");
                break;
            }
            case 0x2000000: {
                this.logger.debug("AGXAResource.end() called with TMSUSPEND");
                throw new XAException("TMSUSPEND not handled yet");
            }
            default: {
                this.logger.debug("AGXAResource.end() called with unknown flags: " + flags);
                throw new XAException(-5);
            }
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AGXAResource.rollback() called on " + this);
            this.logger.debug("---> Supplied xid " + xid.toString());
        }
        try {
            this.conn.rollback(xid);
        }
        catch (AGHttpException e) {
            this.tryThrowAsXAException(e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AGXAResource.prepare() called on " + this);
        }
        try {
            this.conn.prepareCommit(xid);
        }
        catch (AGHttpException e) {
            this.tryThrowAsXAException(e);
        }
        return 0;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AGXAResource.commit(xid=" + xid + ", onePhase=" + onePhase + ") called on " + this);
        }
        try {
            if (onePhase) {
                this.conn.commit();
            } else {
                this.conn.commit(xid);
            }
        }
        catch (AGHttpException e) {
            this.tryThrowAsXAException(e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        throw new XAException("Don't know how to forget " + xid + " yet");
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("isSameRM comparing us (" + this + " with " + xares);
        }
        if (xares instanceof AGXAResource) {
            return this.conn.getStoreID() == ((AGXAResource)xares).conn.getStoreID();
        }
        return false;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        switch (flag) {
            case 0x1000000: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("AGXAResource.recover() called with TMSTARTRSCAN on " + this);
                }
                try {
                    Xid[] res = this.conn.getPreparedTransactions();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("--> Returning " + res.length + " XIDs");
                        for (Xid xid : res) {
                            this.logger.debug("----> " + xid);
                        }
                    }
                    return res;
                }
                catch (DecoderException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            case 0x800000: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("AGXAResource.recover() called with TMENDRSCAN");
                }
                return new Xid[0];
            }
            case 0: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("AGXAResource.recover() called with TMNOFLAGS");
                }
                return new Xid[0];
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AGXAResource.recover() called with unknown flag: " + flag);
        }
        throw new XAException(-5);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }
}

