/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository.config;

import com.franz.agraph.repository.config.AGRepositorySchema;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;

public class AGRepositoryConfig
extends AbstractRepositoryImplConfig {
    private String serverUrl;
    private String username;
    private String password;
    private String catalogId;
    private String repositoryId;

    public AGRepositoryConfig() {
        super("allegrograph:AGRepository");
    }

    public AGRepositoryConfig(String url) {
        this();
        this.setServerUrl(url);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.serverUrl == null) {
            throw new RepositoryConfigException("No serverUrl specified for AG repositoryId");
        }
        if (this.username == null) {
            throw new RepositoryConfigException("No username specified for AG repositoryId");
        }
        if (this.password == null) {
            throw new RepositoryConfigException("No password specified for AG repositoryId");
        }
        if (this.catalogId == null) {
            throw new RepositoryConfigException("No catalogId specified for AG repositoryId");
        }
        if (this.repositoryId == null) {
            throw new RepositoryConfigException("No repositoryId specified for AG repositoryId");
        }
    }

    public Resource export(Model graph) {
        Resource implNode = super.export(graph);
        if (this.serverUrl != null) {
            graph.add(implNode, AGRepositorySchema.SERVERURL, (Value)this.getValueFactory().createIRI(this.serverUrl), new Resource[0]);
        }
        if (this.username != null) {
            graph.add(implNode, AGRepositorySchema.USERNAME, (Value)this.getValueFactory().createLiteral(this.username), new Resource[0]);
        }
        if (this.password != null) {
            graph.add(implNode, AGRepositorySchema.PASSWORD, (Value)this.getValueFactory().createLiteral(this.password), new Resource[0]);
        }
        if (this.catalogId != null) {
            graph.add(implNode, AGRepositorySchema.CATALOGID, (Value)this.getValueFactory().createLiteral(this.catalogId), new Resource[0]);
        }
        if (this.repositoryId != null) {
            graph.add(implNode, AGRepositorySchema.REPOSITORYID, (Value)this.getValueFactory().createLiteral(this.repositoryId), new Resource[0]);
        }
        return implNode;
    }

    private static Value getObjectValue(Model graph, Resource subject, IRI predicate) {
        Set objects = graph.filter(subject, predicate, null, new Resource[0]).objects();
        if (objects.size() == 1) {
            return (Value)objects.iterator().next();
        }
        if (objects.isEmpty()) {
            throw new RepositoryConfigException(predicate + " not found");
        }
        throw new RepositoryConfigException("Multiple " + predicate + " properties found");
    }

    private static String getIRIStringValue(Model graph, Resource subject, IRI predicate) {
        Value value = AGRepositoryConfig.getObjectValue(graph, subject, predicate);
        if (value.isIRI()) {
            return value.stringValue();
        }
        throw new RepositoryConfigException(predicate + " is not an IRI");
    }

    private static String getLiteralStringValue(Model graph, Resource subject, IRI predicate) {
        Value value = AGRepositoryConfig.getObjectValue(graph, subject, predicate);
        if (value.isLiteral()) {
            return value.stringValue();
        }
        throw new RepositoryConfigException(predicate + " is not a literal");
    }

    public void parse(Model graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        this.setServerUrl(AGRepositoryConfig.getIRIStringValue(graph, implNode, AGRepositorySchema.SERVERURL));
        this.setUsername(AGRepositoryConfig.getLiteralStringValue(graph, implNode, AGRepositorySchema.USERNAME));
        this.setPassword(AGRepositoryConfig.getLiteralStringValue(graph, implNode, AGRepositorySchema.PASSWORD));
        this.setCatalogId(AGRepositoryConfig.getLiteralStringValue(graph, implNode, AGRepositorySchema.CATALOGID));
        this.setRepositoryId(AGRepositoryConfig.getLiteralStringValue(graph, implNode, AGRepositorySchema.REPOSITORYID));
    }

    private ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }
}

