/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository.repl;

import com.franz.agraph.repository.repl.DurabilityLevel;
import com.franz.agraph.repository.repl.DurabilityVisitor;

public class TransactionSettings {
    private Integer durability;
    private DurabilityLevel symbolicDurability;
    private Integer distributedTransactionTimeout;
    private Integer transactionLatencyCount;
    private Integer transactionLatencyTimeout;

    public TransactionSettings() {
        this.durability = null;
        this.symbolicDurability = DurabilityLevel.DEFAULT;
        this.distributedTransactionTimeout = null;
        this.transactionLatencyCount = null;
        this.transactionLatencyTimeout = null;
    }

    public TransactionSettings(TransactionSettings other) {
        this.durability = other.durability;
        this.symbolicDurability = other.symbolicDurability;
        this.distributedTransactionTimeout = other.distributedTransactionTimeout;
        this.transactionLatencyCount = other.transactionLatencyCount;
        this.transactionLatencyTimeout = other.transactionLatencyTimeout;
    }

    public <T> T visitDurability(DurabilityVisitor<T> visitor) {
        if (this.durability == null) {
            return visitor.visitDurabilityLevel(this.symbolicDurability);
        }
        return visitor.visitInteger(this.durability);
    }

    public Integer getDistributedTransactionTimeout() {
        return this.distributedTransactionTimeout;
    }

    public Integer getTransactionLatencyCount() {
        return this.transactionLatencyCount;
    }

    public Integer getTransactionLatencyTimeout() {
        return this.transactionLatencyTimeout;
    }

    public TransactionSettings withDurability(Integer durability) {
        TransactionSettings result = new TransactionSettings(this);
        result.durability = durability;
        result.symbolicDurability = DurabilityLevel.DEFAULT;
        return result;
    }

    public TransactionSettings withDurability(DurabilityLevel durability) {
        TransactionSettings result = new TransactionSettings(this);
        result.durability = null;
        result.symbolicDurability = durability == null ? DurabilityLevel.DEFAULT : durability;
        return result;
    }

    public TransactionSettings withDistributedTransactionTimeout(Integer distributedTransactionTimeout) {
        TransactionSettings result = new TransactionSettings(this);
        result.distributedTransactionTimeout = distributedTransactionTimeout;
        return result;
    }

    public TransactionSettings withTransactionLatencyCount(Integer transactionLatencyCount) {
        TransactionSettings result = new TransactionSettings(this);
        result.transactionLatencyCount = transactionLatencyCount;
        return result;
    }

    public TransactionSettings withTransactionLatencyTimeout(Integer transactionLatencyTimeout) {
        TransactionSettings result = new TransactionSettings(this);
        result.transactionLatencyTimeout = transactionLatencyTimeout;
        return result;
    }
}

