/*
 * Decompiled with CFR 0.152.
 */
package com.franz.util;

import java.util.Iterator;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;

public final class Util {
    private static final String CAT_SEPARATOR = ":";

    private Util() {
    }

    public static <T> Iterable<T> iter(final CloseableIteration<T> i) {
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public T next() {
                return i.next();
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    public static String getCatalogFromSpec(String repoAndCatalog) {
        String[] components = repoAndCatalog.split(CAT_SEPARATOR, 2);
        return components.length == 1 ? null : components[0];
    }

    public static String getRepoFromSpec(String repoAndCatalog) {
        String[] components = repoAndCatalog.split(CAT_SEPARATOR, 2);
        return components[components.length - 1];
    }

    public static int mismatch(int[] a, int[] b) {
        int n = Math.min(a.length, b.length);
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            return i;
        }
        return a.length != b.length ? n : -1;
    }

    public static int compare(int[] a, int[] b) {
        int m = Util.mismatch(a, b);
        if (m >= 0 && m < a.length && m < b.length) {
            return Integer.compare(a[m], b[m]);
        }
        return Integer.compare(a.length, b.length);
    }

    public static void verifyContextNotNull(Resource ... contexts) {
        if (contexts == null) {
            String message = "Illegal value null array for contexts argument; either the value should be cast to Resource or an empty array should be supplied";
            throw new IllegalArgumentException(message);
        }
    }

    public static class NTriples {
        private static final boolean XSD_STRING_TO_PLAIN_LITERAL = (Boolean)BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL.getDefaultValue();

        public static String toNTriplesString(Value storableValue) {
            if (storableValue instanceof Literal) {
                Literal literal = (Literal)storableValue;
                return NTriplesUtil.toNTriplesString((Literal)literal, (boolean)XSD_STRING_TO_PLAIN_LITERAL);
            }
            if (storableValue instanceof IRI) {
                IRI iri = (IRI)storableValue;
                return NTriplesUtil.toNTriplesString((IRI)iri);
            }
            if (storableValue instanceof BNode) {
                BNode node = (BNode)storableValue;
                return NTriples.toNTriplesString(node);
            }
            if (storableValue instanceof Triple) {
                Triple triple = (Triple)storableValue;
                return NTriples.toNTriplesString(triple);
            }
            throw new IllegalArgumentException("Unknown value type: " + storableValue.getClass());
        }

        private static String toNTriplesString(BNode bNode) {
            String id = bNode.getID();
            if (id == null || id.isEmpty()) {
                return "_:genid" + Integer.toHexString(bNode.hashCode());
            }
            return "_:" + id;
        }

        private static String toNTriplesString(Triple triple) {
            return "<<" + NTriples.toNTriplesString((Value)triple.getSubject()) + " " + NTriples.toNTriplesString((Value)triple.getPredicate()) + " " + NTriples.toNTriplesString(triple.getObject()) + ">>";
        }
    }
}

