/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.cr.core;

import com.freemanan.cr.core.framework.packager.PackagerHolder;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModifiedClassPathClassLoader
extends URLClassLoader {
    private final ClassLoader appClassLoader;
    private final List<String> internalPackages;

    public ModifiedClassPathClassLoader(URL[] urls, ClassLoader parent, ClassLoader appClassLoader) {
        super(urls, parent);
        this.appClassLoader = appClassLoader;
        this.internalPackages = PackagerHolder.getPackagers().stream().flatMap(packager -> Stream.of(packager.internalPackages())).collect(Collectors.toList());
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.isTestFrameworkInternalPackage(name)) {
            return Class.forName(name, false, this.appClassLoader);
        }
        return super.loadClass(name);
    }

    private boolean isTestFrameworkInternalPackage(String name) {
        for (String pkg : this.internalPackages) {
            if (!name.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

