/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.cr.core;

import com.freemanan.cr.core.ModifiedClassPathClassLoader;
import com.freemanan.cr.core.action.Add;
import com.freemanan.cr.core.action.Exclude;
import com.freemanan.cr.core.action.Override;
import com.freemanan.cr.core.anno.ClasspathReplacer;
import com.freemanan.cr.core.util.MavenUtils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModifiedClassPathClassLoaderGenerator {
    private static final Pattern INTELLIJ_CLASSPATH_JAR_PATTERN = Pattern.compile(".*classpath(\\d+)?\\.jar");
    private final List<Object> actions = new LinkedList<Object>();
    private final ClassLoader parent;
    private ClasspathReplacer classpathReplacer;

    private ModifiedClassPathClassLoaderGenerator(ClassLoader parent) {
        this.parent = parent;
    }

    public static ModifiedClassPathClassLoaderGenerator of(ClassLoader parent) {
        return new ModifiedClassPathClassLoaderGenerator(parent);
    }

    public ModifiedClassPathClassLoaderGenerator exclude(String ... patterns) {
        this.actions.add(Exclude.of(patterns));
        return this;
    }

    public ModifiedClassPathClassLoaderGenerator add(String ... coordinates) {
        this.actions.add(Add.of(coordinates));
        return this;
    }

    public ModifiedClassPathClassLoaderGenerator override(String ... coordinates) {
        this.actions.add(Override.of(coordinates));
        return this;
    }

    public ModifiedClassPathClassLoaderGenerator classpathReplacer(ClasspathReplacer classpathReplacer) {
        this.classpathReplacer = classpathReplacer;
        return this;
    }

    public ModifiedClassPathClassLoader gen() {
        URL[] urls = ModifiedClassPathClassLoaderGenerator.extractUrls(this.parent);
        List result = Arrays.stream(urls).collect(Collectors.toCollection(LinkedList::new));
        this.actions.forEach(action -> {
            if (action instanceof Exclude) {
                this.exclude(result, (Exclude)action);
            } else if (action instanceof Add) {
                this.add(result, (Add)action);
            } else if (action instanceof Override) {
                this.override(result, (Override)action);
            } else {
                throw new IllegalArgumentException("Unknown action: " + action);
            }
        });
        return new ModifiedClassPathClassLoader(result.toArray(new URL[0]), this.parent.getParent(), this.parent);
    }

    private void override(List<URL> result, Override override) {
        this.add(result, Add.of(override.coordinates().toArray(new String[0])));
    }

    private void add(List<URL> result, Add add) {
        List<String> coordinates = add.coordinates().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        result.addAll(0, this.getAdditionalUrls(coordinates));
    }

    private void exclude(List<URL> result, Exclude exclude) {
        HashMap<String, List<URL>> patternToJars = new HashMap<String, List<URL>>();
        HashMap patternToVersions = new HashMap();
        ArrayList<URL> copy = new ArrayList<URL>(result);
        for (String pattern : exclude.patterns()) {
            Supplier<Map<String, List<String>>> patternToVersionsSupplier = () -> {
                patternToVersions.putIfAbsent(pattern, ModifiedClassPathClassLoaderGenerator.findVersions(copy, pattern));
                return patternToVersions;
            };
            for (URL url : copy) {
                if (!this.needRemove(patternToVersionsSupplier, url, pattern, patternToJars)) continue;
                result.remove(url);
            }
        }
    }

    private boolean needRemove(Supplier<Map<String, List<String>>> patternToVersionsSupplier, URL url, String pattern, Map<String, List<URL>> patternToJars) {
        boolean recursiveExclude = Optional.ofNullable(this.classpathReplacer).map(ClasspathReplacer::recursiveExclude).orElse(false);
        if (pattern.matches("^[^:]+:[^:]+:[^:]+$")) {
            if (!recursiveExclude) {
                String[] gav = pattern.split(":");
                if (!ModifiedClassPathClassLoaderGenerator.isSameGroupIdWithExactMatch(url, gav[0].split("\\."))) {
                    return false;
                }
                String artifactId = gav[1];
                String version2 = gav[2];
                String jarName = String.format("%s-%s.jar", artifactId, version2);
                return Objects.equals(jarName, ModifiedClassPathClassLoaderGenerator.fileName(url));
            }
            return patternToJars.computeIfAbsent(pattern, s -> MavenUtils.resolveCoordinates(new String[]{pattern}, this.classpathReplacer)).stream().anyMatch(jarPath -> ModifiedClassPathClassLoaderGenerator.isSameJar(url, jarPath));
        }
        if (pattern.matches("^[^:]+:[^:]+(:[^:]+)?$")) {
            if (!recursiveExclude) {
                String[] gav = pattern.split(":");
                if (!ModifiedClassPathClassLoaderGenerator.isSameGroupIdWithExactMatch(url, gav[0].split("\\."))) {
                    return false;
                }
                String artifactId = gav[1];
                String fileName = ModifiedClassPathClassLoaderGenerator.fileName(url);
                if (fileName == null || !fileName.startsWith(artifactId)) {
                    return false;
                }
                String version3 = fileName.substring(artifactId.length() + 1, fileName.length() - 4);
                return version3.matches("^[^\\.-]+\\..+");
            }
            return patternToVersionsSupplier.get().getOrDefault(pattern, Collections.emptyList()).stream().anyMatch(version -> {
                String coordinate = pattern + ":" + version;
                return patternToJars.computeIfAbsent(coordinate, s -> MavenUtils.resolveCoordinates(new String[]{coordinate}, this.classpathReplacer)).stream().anyMatch(jarPath -> ModifiedClassPathClassLoaderGenerator.isSameJar(url, jarPath));
            });
        }
        if (pattern.contains("*")) {
            String regex = pattern.replace(".", "\\.").replace("*", ".*");
            return Pattern.matches(regex, ModifiedClassPathClassLoaderGenerator.fileName(url));
        }
        if (pattern.endsWith(".jar")) {
            return pattern.equals(ModifiedClassPathClassLoaderGenerator.fileName(url));
        }
        throw new IllegalArgumentException("Illegal pattern: " + pattern);
    }

    private static boolean isSameJar(URL url, URL mavenJarUrl) {
        if (url == null || mavenJarUrl == null) {
            return false;
        }
        if (Objects.equals(url, mavenJarUrl)) {
            return true;
        }
        String fileName = ModifiedClassPathClassLoaderGenerator.fileName(url);
        if (fileName == null) {
            return false;
        }
        String jarFileName = ModifiedClassPathClassLoaderGenerator.fileName(mavenJarUrl);
        if (!Objects.equals(fileName, jarFileName)) {
            return false;
        }
        String mavenJarStr = mavenJarUrl.toString();
        String temp = mavenJarStr.substring(0, mavenJarStr.lastIndexOf("/"));
        temp = temp.substring(0, temp.lastIndexOf("/"));
        String[] arr = temp.substring(0, temp.lastIndexOf("/")).split("/");
        return ModifiedClassPathClassLoaderGenerator.isSameGroupIdWithFuzzyMatch(url, arr);
    }

    private static boolean isSameGroupIdWithFuzzyMatch(URL url, String[] groupIdArr) {
        String gradlePartGroupId;
        String urlStr = url.toString();
        if (urlStr.contains(gradlePartGroupId = groupIdArr[groupIdArr.length - 2] + "." + groupIdArr[groupIdArr.length - 1])) {
            return true;
        }
        String mavenPartGroupId = groupIdArr[groupIdArr.length - 2] + "/" + groupIdArr[groupIdArr.length - 1];
        return urlStr.contains(mavenPartGroupId);
    }

    private static boolean isSameGroupIdWithExactMatch(URL url, String[] groupIdArr) {
        String gradlePartGroupId;
        String urlStr = url.toString();
        if (urlStr.contains(gradlePartGroupId = "/" + String.join((CharSequence)".", groupIdArr) + "/")) {
            return true;
        }
        String mavenPartGroupId = "/" + String.join((CharSequence)"/", groupIdArr) + "/";
        return urlStr.contains(mavenPartGroupId);
    }

    private static List<String> findVersions(List<URL> urls, String groupAndArtifact) {
        ArrayList<String> versions = new ArrayList<String>();
        for (URL url : urls) {
            String version;
            String[] ga;
            String fileName = ModifiedClassPathClassLoaderGenerator.fileName(url);
            if (fileName == null || !ModifiedClassPathClassLoaderGenerator.isSameGroupIdWithExactMatch(url, (ga = groupAndArtifact.split(":"))[0].split("\\."))) continue;
            String artifactId = ga[1];
            String regex = String.format("%s-(.*)\\.jar", artifactId);
            Matcher matcher = Pattern.compile(regex).matcher(fileName);
            if (!matcher.find() || !(version = matcher.group(1)).matches("^[^\\.-]+\\..+")) continue;
            versions.add(version);
        }
        return versions;
    }

    private static String fileName(URL url) {
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        try {
            return new File(url.toURI()).getName();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static URL[] extractUrls(ClassLoader classLoader) {
        ArrayList extractedUrls = new ArrayList();
        ModifiedClassPathClassLoaderGenerator.doExtractUrls(classLoader).forEach(url -> {
            if (ModifiedClassPathClassLoaderGenerator.isManifestOnlyJar(url)) {
                extractedUrls.addAll(ModifiedClassPathClassLoaderGenerator.extractUrlsFromManifestClassPath(url));
            } else {
                extractedUrls.add(url);
            }
        });
        return extractedUrls.toArray(new URL[0]);
    }

    private static Stream<URL> doExtractUrls(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return Stream.of(((URLClassLoader)classLoader).getURLs());
        }
        return Stream.of(ManagementFactory.getRuntimeMXBean().getClassPath().split(File.pathSeparator)).map(ModifiedClassPathClassLoaderGenerator::toURL);
    }

    private static URL toURL(String entry) {
        try {
            return new File(entry).toURI().toURL();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static boolean isManifestOnlyJar(URL url) {
        return ModifiedClassPathClassLoaderGenerator.isShortenedIntelliJJar(url);
    }

    private static boolean isShortenedIntelliJJar(URL url) {
        String urlPath = url.getPath();
        boolean isCandidate = INTELLIJ_CLASSPATH_JAR_PATTERN.matcher(urlPath).matches();
        if (isCandidate) {
            try {
                Attributes attributes = ModifiedClassPathClassLoaderGenerator.getManifestMainAttributesFromUrl(url);
                String createdBy = attributes.getValue("Created-By");
                return createdBy != null && createdBy.contains("IntelliJ");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static List<URL> extractUrlsFromManifestClassPath(URL bootJar) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String entry : ModifiedClassPathClassLoaderGenerator.getClassPath(bootJar)) {
                urls.add(new URL(entry));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return urls;
    }

    private static String[] getClassPath(URL bootJar) throws Exception {
        Attributes attributes = ModifiedClassPathClassLoaderGenerator.getManifestMainAttributesFromUrl(bootJar);
        String classpathListStr = attributes.getValue(Attributes.Name.CLASS_PATH);
        return classpathListStr.split(" ");
    }

    private static Attributes getManifestMainAttributesFromUrl(URL url) throws Exception {
        try (JarFile jarFile = new JarFile(new File(url.toURI()));){
            Attributes attributes = jarFile.getManifest().getMainAttributes();
            return attributes;
        }
    }

    private List<URL> getAdditionalUrls(List<String> coordinates) {
        if (coordinates.isEmpty()) {
            return Collections.emptyList();
        }
        return MavenUtils.resolveCoordinates(coordinates.toArray(new String[0]), this.classpathReplacer);
    }
}

