/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.cr.core.framework.junit5;

import com.freemanan.cr.core.ModifiedClassPathClassLoader;
import com.freemanan.cr.core.ModifiedClassPathClassLoaderGenerator;
import com.freemanan.cr.core.anno.Action;
import com.freemanan.cr.core.anno.ClasspathReplacer;
import com.freemanan.cr.core.framework.junit5.Reflections;
import com.freemanan.cr.core.util.ModifiedClassLoaderCache;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class ClasspathReplacerExtension
implements InvocationInterceptor {
    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isModifiedClassPathClassLoader(extensionContext)) {
            invocation.proceed();
            return;
        }
        invocation.skip();
        this.runTestWithModifiedClassPath(invocationContext, extensionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestWithModifiedClassPath(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Class testClass = extensionContext.getRequiredTestClass();
        Method testMethod = (Method)invocationContext.getExecutable();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ModifiedClassPathClassLoader customizedClassLoader = Optional.ofNullable(testMethod.getAnnotation(ClasspathReplacer.class)).map(cr -> ClasspathReplacerExtension.getModifiedClassLoader(cr, originalClassLoader)).orElseGet(() -> ClasspathReplacerExtension.getCachedClassLevelClassLoader(testClass, originalClassLoader));
        Thread.currentThread().setContextClassLoader(customizedClassLoader);
        try {
            this.runTest(testClass.getName(), testMethod.getName(), customizedClassLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static ModifiedClassPathClassLoader getCachedClassLevelClassLoader(Class<?> testClass, ClassLoader originalClassLoader) {
        return ModifiedClassLoaderCache.getOrPut(testClass, () -> {
            ClasspathReplacer cr = testClass.getAnnotation(ClasspathReplacer.class);
            return ClasspathReplacerExtension.getModifiedClassLoader(cr, originalClassLoader);
        });
    }

    private static ModifiedClassPathClassLoader getModifiedClassLoader(ClasspathReplacer cr, ClassLoader originalClassLoader) {
        assert (cr != null);
        Action[] actions = cr.value();
        ModifiedClassPathClassLoaderGenerator generator = ModifiedClassPathClassLoaderGenerator.of(originalClassLoader);
        block5: for (Action action : actions) {
            switch (action.verb()) {
                case ADD: {
                    generator.add(action.value());
                    continue block5;
                }
                case EXCLUDE: {
                    generator.exclude(action.value());
                    continue block5;
                }
                case OVERRIDE: {
                    generator.override(action.value());
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)action.verb()));
                }
            }
        }
        generator.classpathReplacer(cr);
        return generator.gen();
    }

    private void runTest(String testClassName, String testMethodName, ClassLoader custmizedClassLoader) throws Throwable {
        Class<?> testClass = custmizedClassLoader.loadClass(testClassName);
        Method testMethod = this.findMethod(testClass, testMethodName);
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod(testClass, (Method)testMethod)}).build();
        Launcher launcher = LauncherFactory.create();
        TestPlan testPlan = launcher.discover(request);
        SummaryGeneratingListener listener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
        launcher.execute(testPlan, new TestExecutionListener[0]);
        TestExecutionSummary summary = listener.getSummary();
        List failures = summary.getFailures();
        if (failures != null && !failures.isEmpty()) {
            throw ((TestExecutionSummary.Failure)failures.get(0)).getException();
        }
    }

    private Method findMethod(Class<?> testClass, String testMethodName) {
        Optional method = ReflectionUtils.findMethod(testClass, (String)testMethodName, (Class[])new Class[0]);
        if (!method.isPresent()) {
            Method[] methods;
            for (Method candidate : methods = Reflections.getUniqueDeclaredMethods(testClass)) {
                if (!candidate.getName().equals(testMethodName)) continue;
                return candidate;
            }
        }
        assert (method.isPresent());
        return (Method)method.get();
    }

    private void intercept(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) throws Throwable {
        if (this.isModifiedClassPathClassLoader(extensionContext)) {
            invocation.proceed();
            return;
        }
        invocation.skip();
    }

    private boolean isModifiedClassPathClassLoader(ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        ClassLoader classLoader = testClass.getClassLoader();
        return classLoader.getClass().getName().equals(ModifiedClassPathClassLoader.class.getName());
    }
}

