/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.cr.core.framework.packager;

import com.freemanan.cr.core.framework.packager.AssertJPackager;
import com.freemanan.cr.core.framework.packager.HamcrestPackager;
import com.freemanan.cr.core.framework.packager.Junit5Packager;
import com.freemanan.cr.core.framework.packager.MockitoPackager;
import com.freemanan.cr.core.framework.packager.Opentest4JPackager;
import com.freemanan.cr.core.framework.packager.Packager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PackagerHolder {
    private static final List<Packager> packagers = new ArrayList<Packager>();

    public static List<Packager> getPackagers() {
        return Collections.unmodifiableList(packagers);
    }

    private static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    static {
        if (PackagerHolder.isPresent("org.junit.jupiter.api.Test")) {
            packagers.add(new Junit5Packager());
        }
        if (PackagerHolder.isPresent("org.hamcrest.Matcher")) {
            packagers.add(new HamcrestPackager());
        }
        if (PackagerHolder.isPresent("org.opentest4j.AssertionFailedError")) {
            packagers.add(new Opentest4JPackager());
        }
        if (PackagerHolder.isPresent("org.assertj.core.api.Assertions")) {
            packagers.add(new AssertJPackager());
        }
        if (PackagerHolder.isPresent("org.mockito.Mockito")) {
            packagers.add(new MockitoPackager());
        }
    }
}

