/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.cr.core.util;

import com.freemanan.cr.core.anno.ClasspathReplacer;
import com.freemanan.cr.core.anno.Repository;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public final class MavenUtils {
    private static final int MAX_RESOLUTION_ATTEMPTS = 3;
    private static final RepositorySystem repositorySystem;
    private static final DefaultRepositorySystemSession session;

    private MavenUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static List<URL> resolveCoordinates(String[] coordinates, ClasspathReplacer classpathReplacer) {
        Exception latestFailure = null;
        for (int i = 0; i < 3; ++i) {
            CollectRequest collectRequest = new CollectRequest(null, MavenUtils.allRepositories(classpathReplacer));
            collectRequest.setDependencies(MavenUtils.createDependencies(coordinates));
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
            try {
                DependencyResult result = repositorySystem.resolveDependencies((RepositorySystemSession)session, dependencyRequest);
                ArrayList<URL> resolvedArtifacts = new ArrayList<URL>();
                for (ArtifactResult artifact : result.getArtifactResults()) {
                    resolvedArtifacts.add(artifact.getArtifact().getFile().toURI().toURL());
                }
                return resolvedArtifacts;
            }
            catch (Exception ex) {
                latestFailure = ex;
                continue;
            }
        }
        throw new IllegalStateException("Resolution failed after 3 attempts", latestFailure);
    }

    private static List<RemoteRepository> allRepositories(ClasspathReplacer classpathReplacer) {
        List<RemoteRepository> extra = MavenUtils.extraRepositories(classpathReplacer);
        RemoteRepository central = MavenUtils.centralRepository();
        ArrayList<RemoteRepository> result = new ArrayList<RemoteRepository>(extra);
        result.add(central);
        return result;
    }

    private static List<RemoteRepository> extraRepositories(ClasspathReplacer classpathReplacer) {
        if (classpathReplacer == null) {
            return Collections.emptyList();
        }
        ArrayList<RemoteRepository> extraRepositories = new ArrayList<RemoteRepository>(classpathReplacer.repositories().length);
        for (Repository repo : classpathReplacer.repositories()) {
            String id = repo.id() == null || repo.id().isEmpty() ? repo.value() : repo.id();
            String url = repo.value();
            RemoteRepository.Builder builder = new RemoteRepository.Builder(id, "default", url);
            String username = MavenUtils.parseIfNecessary(repo.username());
            String password = MavenUtils.parseIfNecessary(repo.password());
            if (username != null && !username.isEmpty() && password != null && !password.isEmpty()) {
                builder.setAuthentication(new AuthenticationBuilder().addUsername(username).addPassword(password).build());
            }
            RemoteRepository repository = builder.build();
            extraRepositories.add(repository);
        }
        return extraRepositories;
    }

    private static String parseIfNecessary(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (str.startsWith("${") && str.endsWith("}")) {
            String variable = str.substring(2, str.length() - 1);
            String v = Optional.ofNullable(System.getenv(variable)).orElse(System.getProperty(variable));
            return v != null ? v : str;
        }
        return str;
    }

    private static RemoteRepository centralRepository() {
        return new RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2").build();
    }

    private static List<Dependency> createDependencies(String[] coordinates) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String coordinate : coordinates) {
            dependencies.add(new Dependency((Artifact)new DefaultArtifact(coordinate), null));
        }
        return dependencies;
    }

    static {
        DefaultServiceLocator serviceLocator = MavenRepositorySystemUtils.newServiceLocator();
        serviceLocator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        serviceLocator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        repositorySystem = (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
        session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(System.getProperty("user.home") + "/.m2/repository");
        session.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepository));
    }
}

