/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import com.freemanan.starter.httpexchange.ReusableModel;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;

final class Cache {
    private static final ConcurrentMap<ReusableModel, HttpServiceProxyFactory> factoryCache = new ConcurrentHashMap<ReusableModel, HttpServiceProxyFactory>();
    private static final ConcurrentMap<ReusableModel, WebClient> webClientCache = new ConcurrentHashMap<ReusableModel, WebClient>();
    private static final Set<Class<?>> clientClasses = ConcurrentHashMap.newKeySet();

    public static HttpServiceProxyFactory getFactory(ReusableModel model, Supplier<HttpServiceProxyFactory> supplier) {
        return factoryCache.computeIfAbsent(model, it -> (HttpServiceProxyFactory)supplier.get());
    }

    public static WebClient getWebClient(ReusableModel model, Supplier<WebClient> supplier) {
        return webClientCache.computeIfAbsent(model, it -> (WebClient)supplier.get());
    }

    public static void addClientClass(Class<?> type) {
        clientClasses.add(type);
    }

    public static Set<Class<?>> getClientClasses() {
        return Set.copyOf(clientClasses);
    }

    public static void clear() {
        factoryCache.clear();
        webClientCache.clear();
        clientClasses.clear();
    }

    private Cache() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

