/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import com.freemanan.starter.httpexchange.Cache;
import com.freemanan.starter.httpexchange.HttpClientsProperties;
import com.freemanan.starter.httpexchange.ReusableModel;
import com.freemanan.starter.httpexchange.UrlPlaceholderStringValueResolver;
import com.freemanan.starter.httpexchange.Util;
import java.time.Duration;
import java.util.Optional;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.support.WebClientAdapter;
import org.springframework.web.service.invoker.HttpClientAdapter;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;

class ExchangeClientCreator {
    private final ConfigurableBeanFactory beanFactory;
    private final Environment environment;
    private final Class<?> clientType;
    private final HttpClientsProperties.Client client;
    private final ReusableModel model;

    ExchangeClientCreator(ConfigurableBeanFactory beanFactory, HttpClientsProperties properties, Class<?> clientType) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory must not be null");
        Assert.notNull((Object)properties, (String)"properties must not be null");
        Assert.notNull(clientType, (String)"clientType must not be null");
        this.beanFactory = beanFactory;
        this.environment = (Environment)beanFactory.getBean(Environment.class);
        this.clientType = clientType;
        this.client = Util.findMatchedConfig(clientType, properties).orElseGet(properties::defaultClient);
        this.model = new ReusableModel(this.client.getBaseUrl(), this.client.getResponseTimeout(), this.client.getHeaders());
    }

    public <T> T create() {
        HttpServiceProxyFactory cachedFactory = this.getOrCreateServiceProxyFactory();
        return (T)cachedFactory.createClient(this.clientType);
    }

    private HttpServiceProxyFactory getOrCreateServiceProxyFactory() {
        return Cache.getFactory(this.model, this::buildServiceProxyFactory);
    }

    private HttpServiceProxyFactory buildServiceProxyFactory() {
        HttpServiceProxyFactory.Builder builder = ((HttpServiceProxyFactory.Builder)this.beanFactory.getBeanProvider(HttpServiceProxyFactory.Builder.class).getIfUnique(HttpServiceProxyFactory::builder)).clientAdapter((HttpClientAdapter)WebClientAdapter.forClient((WebClient)this.getOrCreateWebClient()));
        this.beanFactory.getBeanProvider(HttpServiceArgumentResolver.class).orderedStream().forEach(arg_0 -> ((HttpServiceProxyFactory.Builder)builder).customArgumentResolver(arg_0));
        UrlPlaceholderStringValueResolver delegatedResolver = new UrlPlaceholderStringValueResolver(this.environment, (ObjectProvider<StringValueResolver>)this.beanFactory.getBeanProvider(StringValueResolver.class));
        builder.embeddedValueResolver((StringValueResolver)delegatedResolver);
        Optional.ofNullable(this.client.getResponseTimeout()).ifPresent(timeout -> builder.blockTimeout(Duration.ofMillis(timeout)));
        return builder.build();
    }

    private WebClient getOrCreateWebClient() {
        return Cache.getWebClient(this.model, this::buildWebClient);
    }

    private WebClient buildWebClient() {
        WebClient.Builder builder = (WebClient.Builder)this.beanFactory.getBeanProvider(WebClient.Builder.class).getIfUnique(WebClient::builder);
        if (StringUtils.hasText((String)this.client.getBaseUrl())) {
            Object baseUrl = this.client.getBaseUrl();
            if (!((String)baseUrl).contains("://")) {
                baseUrl = "http://" + (String)baseUrl;
            }
            builder.baseUrl((String)baseUrl);
        }
        if (!CollectionUtils.isEmpty(this.client.getHeaders())) {
            this.client.getHeaders().forEach(header -> builder.defaultHeader(header.getKey(), (String[])header.getValues().toArray(String[]::new)));
        }
        return builder.build();
    }
}

