/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import com.freemanan.starter.httpexchange.Cache;
import com.freemanan.starter.httpexchange.EnableExchangeClients;
import com.freemanan.starter.httpexchange.ExchangeClientCreator;
import com.freemanan.starter.httpexchange.HttpClientsProperties;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionOverrideException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.service.annotation.HttpExchange;

class ExchangeClientsRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(ExchangeClientsRegistrar.class);
    private ResourceLoader resourceLoader;
    private Environment environment;
    private HttpClientsProperties properties;

    ExchangeClientsRegistrar() {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
        this.properties = ExchangeClientsRegistrar.getProperties(environment);
        ExchangeClientsRegistrar.check(this.properties);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.registerHttpExchanges(metadata, registry);
    }

    private void registerHttpExchanges(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        Map attrs = Optional.ofNullable(metadata.getAnnotationAttributes(EnableExchangeClients.class.getName())).orElse(Map.of());
        Class[] clientClasses = attrs.getOrDefault("clients", new Class[0]);
        String[] basePackages = attrs.getOrDefault("value", new String[0]);
        if (clientClasses.length > 0) {
            this.registerClassesAsHttpExchange(registry, clientClasses);
            if (basePackages.length > 0) {
                this.registerBeansForBasePackages(registry, scanner, basePackages);
            }
            return;
        }
        if (basePackages.length == 0) {
            basePackages = new String[]{ClassUtils.getPackageName((String)metadata.getClassName())};
        }
        this.registerBeansForBasePackages(registry, scanner, basePackages);
    }

    private static void check(HttpClientsProperties properties) {
        properties.getClients().stream().map(HttpClientsProperties.Client::getName).filter(StringUtils::hasText).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((name, count) -> {
            if (count > 1L) {
                log.warn("There are {} clients with name '{}', please check your configuration", count, name);
            }
        });
        properties.getClients().stream().map(HttpClientsProperties.Client::getClientClass).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((clz, count) -> {
            if (count > 1L) {
                log.warn("There are {} clients with class '{}', please check your configuration", count, clz);
            }
        });
    }

    private static HttpClientsProperties getProperties(Environment environment) {
        HttpClientsProperties properties = (HttpClientsProperties)Binder.get((Environment)environment).bind("http-exchange", HttpClientsProperties.class).orElseGet(HttpClientsProperties::new);
        properties.afterPropertiesSet();
        return properties;
    }

    private void registerBeansForBasePackages(BeanDefinitionRegistry registry, ClassPathScanningCandidateComponentProvider scanner, String[] basePackages) {
        for (String pkg : basePackages) {
            Set beanDefinitions = scanner.findCandidateComponents(pkg);
            for (BeanDefinition beanDefinition : beanDefinitions) {
                if (!(beanDefinition instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition bd = (AnnotatedBeanDefinition)beanDefinition;
                this.registerHttpExchange(registry, bd.getMetadata().getClassName());
            }
        }
    }

    private void registerHttpExchange(BeanDefinitionRegistry registry, String className) {
        Class<?> clz;
        try {
            clz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (!clz.isInterface()) {
            throw new IllegalArgumentException(className + " is not an interface");
        }
        if (ExchangeClientsRegistrar.isPureInterface(clz)) {
            return;
        }
        assert (registry instanceof ConfigurableBeanFactory);
        ExchangeClientCreator creator = new ExchangeClientCreator((ConfigurableBeanFactory)registry, this.properties, clz);
        AbstractBeanDefinition abd = BeanDefinitionBuilder.genericBeanDefinition(clz, creator::create).getBeanDefinition();
        abd.setPrimary(true);
        abd.setAutowireMode(2);
        abd.setLazyInit(true);
        try {
            registry.registerBeanDefinition(className, (BeanDefinition)abd);
            Cache.addClientClass(clz);
        }
        catch (BeanDefinitionOverrideException ignore) {
            log.warn("Your @HttpExchanges client '{}' is included in base packages, you can remove it from 'clients' property.", (Object)className);
        }
    }

    private static boolean isPureInterface(Class<?> clz) {
        Method[] methods;
        HttpExchange httpExchange = (HttpExchange)AnnotationUtils.findAnnotation(clz, HttpExchange.class);
        if (httpExchange != null) {
            return false;
        }
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(clz)) {
            if (AnnotationUtils.findAnnotation((Method)method, HttpExchange.class) == null) continue;
            return false;
        }
        return true;
    }

    private ClassPathScanningCandidateComponentProvider getScanner() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((metadataReader, metadataReaderFactory) -> ExchangeClientsRegistrar.isHttpExchange(metadataReader));
        return scanner;
    }

    private static boolean isHttpExchange(MetadataReader mr) {
        return mr.getClassMetadata().isInterface();
    }

    private void registerClassesAsHttpExchange(BeanDefinitionRegistry registry, Class<?>[] classes) {
        for (Class<?> clz : classes) {
            this.registerHttpExchange(registry, clz.getName());
        }
    }
}

