/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import com.freemanan.starter.httpexchange.BeanToQueryArgumentResolver;
import com.freemanan.starter.httpexchange.Cache;
import com.freemanan.starter.httpexchange.HttpClientsProperties;
import com.freemanan.starter.httpexchange.Util;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={HttpClientsProperties.class})
class HttpClientsConfiguration
implements DisposableBean,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(HttpClientsConfiguration.class);
    private final HttpClientsProperties properties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="http-exchange", name={"bean-to-query"}, matchIfMissing=true)
    public BeanToQueryArgumentResolver beanToQueryArgumentResolver() {
        return new BeanToQueryArgumentResolver();
    }

    public void afterSingletonsInstantiated() {
        Set<Class<?>> classes = Cache.getClientClasses();
        this.properties.getClients().stream().filter(it -> Util.findMatchedClientClass(it, classes).isEmpty()).forEach(it -> log.warn("The configuration item '{}' is not taking effect, no matched http client found, please check your configuration.", (Object)it.getName()));
    }

    public void destroy() {
        Cache.clear();
    }

    public HttpClientsConfiguration(HttpClientsProperties properties) {
        this.properties = properties;
    }
}

