/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="http-exchange")
public class HttpClientsProperties
implements InitializingBean {
    public static final String PREFIX = "http-exchange";
    private String baseUrl;
    private Long responseTimeout;
    private List<Header> headers = new ArrayList<Header>();
    private List<Client> clients = new ArrayList<Client>();
    private boolean beanToQuery = true;

    public void afterPropertiesSet() {
        for (Client client : this.clients) {
            if (client.getBaseUrl() == null) {
                client.setBaseUrl(this.baseUrl);
            }
            if (client.getResponseTimeout() == null) {
                client.setResponseTimeout(this.responseTimeout);
            }
            LinkedHashMap total = this.headers.stream().collect(Collectors.toMap(Header::getKey, Header::getValues, (oldV, newV) -> newV, LinkedHashMap::new));
            for (Header header : client.getHeaders()) {
                total.put(header.getKey(), header.getValues());
            }
            List<Header> mergedHeaders = total.entrySet().stream().map(e -> new Header((String)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
            client.setHeaders(mergedHeaders);
        }
    }

    Client defaultClient() {
        return new Client("__default__", null, this.baseUrl, this.responseTimeout, this.headers);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Long getResponseTimeout() {
        return this.responseTimeout;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public List<Client> getClients() {
        return this.clients;
    }

    public boolean isBeanToQuery() {
        return this.beanToQuery;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setResponseTimeout(Long responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public void setClients(List<Client> clients) {
        this.clients = clients;
    }

    public void setBeanToQuery(boolean beanToQuery) {
        this.beanToQuery = beanToQuery;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientsProperties)) {
            return false;
        }
        HttpClientsProperties other = (HttpClientsProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBeanToQuery() != other.isBeanToQuery()) {
            return false;
        }
        Long this$responseTimeout = this.getResponseTimeout();
        Long other$responseTimeout = other.getResponseTimeout();
        if (this$responseTimeout == null ? other$responseTimeout != null : !((Object)this$responseTimeout).equals(other$responseTimeout)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        List<Header> this$headers = this.getHeaders();
        List<Header> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        List<Client> this$clients = this.getClients();
        List<Client> other$clients = other.getClients();
        return !(this$clients == null ? other$clients != null : !((Object)this$clients).equals(other$clients));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientsProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBeanToQuery() ? 79 : 97);
        Long $responseTimeout = this.getResponseTimeout();
        result = result * 59 + ($responseTimeout == null ? 43 : ((Object)$responseTimeout).hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        List<Header> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        List<Client> $clients = this.getClients();
        result = result * 59 + ($clients == null ? 43 : ((Object)$clients).hashCode());
        return result;
    }

    public String toString() {
        return "HttpClientsProperties(baseUrl=" + this.getBaseUrl() + ", responseTimeout=" + this.getResponseTimeout() + ", headers=" + this.getHeaders() + ", clients=" + this.getClients() + ", beanToQuery=" + this.isBeanToQuery() + ")";
    }

    public static class Client {
        private String name;
        private Class<?> clientClass;
        private String baseUrl;
        private Long responseTimeout;
        private List<Header> headers = new ArrayList<Header>();

        public String getName() {
            return this.name;
        }

        public Class<?> getClientClass() {
            return this.clientClass;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public Long getResponseTimeout() {
            return this.responseTimeout;
        }

        public List<Header> getHeaders() {
            return this.headers;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setClientClass(Class<?> clientClass) {
            this.clientClass = clientClass;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public void setResponseTimeout(Long responseTimeout) {
            this.responseTimeout = responseTimeout;
        }

        public void setHeaders(List<Header> headers) {
            this.headers = headers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Client)) {
                return false;
            }
            Client other = (Client)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$responseTimeout = this.getResponseTimeout();
            Long other$responseTimeout = other.getResponseTimeout();
            if (this$responseTimeout == null ? other$responseTimeout != null : !((Object)this$responseTimeout).equals(other$responseTimeout)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Class<?> this$clientClass = this.getClientClass();
            Class<?> other$clientClass = other.getClientClass();
            if (this$clientClass == null ? other$clientClass != null : !this$clientClass.equals(other$clientClass)) {
                return false;
            }
            String this$baseUrl = this.getBaseUrl();
            String other$baseUrl = other.getBaseUrl();
            if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
                return false;
            }
            List<Header> this$headers = this.getHeaders();
            List<Header> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Client;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $responseTimeout = this.getResponseTimeout();
            result = result * 59 + ($responseTimeout == null ? 43 : ((Object)$responseTimeout).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Class<?> $clientClass = this.getClientClass();
            result = result * 59 + ($clientClass == null ? 43 : $clientClass.hashCode());
            String $baseUrl = this.getBaseUrl();
            result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
            List<Header> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            return result;
        }

        public String toString() {
            return "HttpClientsProperties.Client(name=" + this.getName() + ", clientClass=" + this.getClientClass() + ", baseUrl=" + this.getBaseUrl() + ", responseTimeout=" + this.getResponseTimeout() + ", headers=" + this.getHeaders() + ")";
        }

        public Client() {
        }

        public Client(String name, Class<?> clientClass, String baseUrl, Long responseTimeout, List<Header> headers) {
            this.name = name;
            this.clientClass = clientClass;
            this.baseUrl = baseUrl;
            this.responseTimeout = responseTimeout;
            this.headers = headers;
        }
    }

    public static class Header {
        private String key;
        private List<String> values = new ArrayList<String>();

        public String getKey() {
            return this.key;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Header)) {
                return false;
            }
            Header other = (Header)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            List<String> this$values = this.getValues();
            List<String> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Header;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            List<String> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        public String toString() {
            return "HttpClientsProperties.Header(key=" + this.getKey() + ", values=" + this.getValues() + ")";
        }

        public Header() {
        }

        public Header(String key, List<String> values) {
            this.key = key;
            this.values = values;
        }
    }
}

