/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.env.Environment;
import org.springframework.util.StringValueResolver;

class UrlPlaceholderStringValueResolver
implements StringValueResolver {
    private static final Logger log = LoggerFactory.getLogger(UrlPlaceholderStringValueResolver.class);
    private final Environment environment;
    private final ObjectProvider<StringValueResolver> delegateProvider;

    UrlPlaceholderStringValueResolver(Environment environment, ObjectProvider<StringValueResolver> delegateProvider) {
        this.environment = environment;
        this.delegateProvider = delegateProvider;
    }

    public String resolveStringValue(String strVal) {
        String resolved = null;
        try {
            resolved = this.environment.resolvePlaceholders(strVal);
        }
        catch (Exception e) {
            log.warn("Failed to resolve placeholders in '{}'", (Object)strVal, (Object)e);
        }
        resolved = resolved != null ? resolved : strVal;
        StringValueResolver delegate = (StringValueResolver)this.delegateProvider.getIfAvailable();
        if (delegate != null) {
            return delegate.resolveStringValue(resolved);
        }
        return resolved;
    }
}

