/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import com.freemanan.starter.httpexchange.HttpClientsProperties;
import java.util.Optional;
import java.util.Set;
import org.springframework.util.StringUtils;

final class Util {
    public static Optional<HttpClientsProperties.Client> findMatchedConfig(Class<?> clz, HttpClientsProperties properties) {
        Optional<HttpClientsProperties.Client> found = properties.getClients().stream().filter(it -> it.getClientClass() == clz).findFirst();
        if (found.isPresent()) {
            return found;
        }
        return properties.getClients().stream().filter(it -> Util.match(clz, it)).findFirst();
    }

    public static Optional<Class<?>> findMatchedClientClass(HttpClientsProperties.Client client, Set<Class<?>> classes) {
        return classes.stream().filter(clz -> Util.match(clz, client)).findFirst();
    }

    static boolean match(Class<?> clz, HttpClientsProperties.Client client) {
        if (clz == client.getClientClass()) {
            return true;
        }
        if (!StringUtils.hasText((String)client.getName())) {
            return false;
        }
        String name = client.getName().replaceAll("-", "");
        return name.equalsIgnoreCase(clz.getSimpleName()) || name.equalsIgnoreCase(clz.getName()) || name.equalsIgnoreCase(clz.getCanonicalName());
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

