/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;

public class BeanToQueryArgumentResolver
implements HttpServiceArgumentResolver,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(BeanToQueryArgumentResolver.class);
    public static final int ORDER = 0;
    private static final String WEB_BIND_ANNOTATION_PACKAGE = RequestParam.class.getPackageName();

    public boolean resolve(Object argument, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        if (argument == null || BeanToQueryArgumentResolver.hasWebBindPackageAnnotation(parameter) || argument instanceof URI || argument instanceof HttpMethod || BeanUtils.isSimpleValueType(argument.getClass())) {
            return false;
        }
        if (argument instanceof Map) {
            return false;
        }
        Map<String, Object> nameToValue = BeanToQueryArgumentResolver.getPropertyValueMap(argument);
        if (CollectionUtils.isEmpty(nameToValue)) {
            log.warn("class '{}' has no property, will not try to convert it to request parameters", (Object)argument.getClass().getSimpleName());
            return false;
        }
        nameToValue.forEach((k, v) -> {
            Collection coll;
            if (v == null) {
                return;
            }
            Class<?> clz = v.getClass();
            if (BeanUtils.isSimpleValueType(clz)) {
                requestValues.addRequestParameter(k, new String[]{v.toString()});
            } else if (clz.isArray() && BeanUtils.isSimpleValueType(clz.getComponentType())) {
                String arrValue = Arrays.stream((Object[])v).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(","));
                requestValues.addRequestParameter(k, new String[]{arrValue});
            } else if (v instanceof Collection && (coll = (Collection)v).stream().filter(Objects::nonNull).allMatch(it -> BeanUtils.isSimpleValueType(it.getClass()))) {
                String listValue = coll.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(","));
                requestValues.addRequestParameter(k, new String[]{listValue});
            }
        });
        return true;
    }

    public int getOrder() {
        return 0;
    }

    protected static Map<String, Object> getPropertyValueMap(Object source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try {
            PropertyDescriptor[] pds;
            BeanWrapperImpl src = new BeanWrapperImpl(source);
            for (PropertyDescriptor pd : pds = src.getPropertyDescriptors()) {
                String name = pd.getName();
                Object srcValue = src.getPropertyValue(name);
                if ("class".equals(name)) continue;
                result.put(name, srcValue);
            }
        }
        catch (Exception e) {
            log.warn("Failed to convert object[{}] to request parameters", source.getClass(), (Object)e);
        }
        return result;
    }

    protected static boolean hasWebBindPackageAnnotation(MethodParameter parameter) {
        for (Annotation annotation : parameter.getParameterAnnotations()) {
            if (!annotation.annotationType().getPackageName().startsWith(WEB_BIND_ANNOTATION_PACKAGE)) continue;
            return true;
        }
        return false;
    }
}

