/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import com.freemanan.starter.httpexchange.Cache;
import com.freemanan.starter.httpexchange.HttpClientsProperties;
import com.freemanan.starter.httpexchange.UrlPlaceholderStringValueResolver;
import com.freemanan.starter.httpexchange.Util;
import com.freemanan.starter.httpexchange.shaded.ShadedHttpServiceProxyFactory;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.support.WebClientAdapter;
import org.springframework.web.service.invoker.HttpClientAdapter;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;

class ExchangeClientCreator {
    private static final Logger log = LoggerFactory.getLogger(ExchangeClientCreator.class);
    private final ConfigurableBeanFactory beanFactory;
    private final Environment environment;
    private final Class<?> clientType;
    private final HttpClientsProperties.Channel channelConfig;
    private final boolean usingClientSideAnnotation;

    ExchangeClientCreator(ConfigurableBeanFactory beanFactory, HttpClientsProperties properties, Class<?> clientType, boolean usingClientSideAnnotation) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory must not be null");
        Assert.notNull((Object)properties, (String)"properties must not be null");
        Assert.notNull(clientType, (String)"clientType must not be null");
        this.beanFactory = beanFactory;
        this.environment = (Environment)beanFactory.getBean(Environment.class);
        this.clientType = clientType;
        this.channelConfig = Util.findMatchedConfig(clientType, properties).orElseGet(properties::defaultClient);
        this.usingClientSideAnnotation = usingClientSideAnnotation;
    }

    public <T> T create() {
        if (this.usingClientSideAnnotation) {
            HttpServiceProxyFactory cachedFactory = this.buildServiceProxyFactory();
            Object result = cachedFactory.createClient(this.clientType);
            Cache.addClientClass(this.clientType);
            return (T)result;
        }
        ShadedHttpServiceProxyFactory cachedFactory = this.buildShadedServiceProxyFactory();
        Object result = cachedFactory.createClient(this.clientType);
        Cache.addClientClass(this.clientType);
        return (T)result;
    }

    private HttpServiceProxyFactory buildServiceProxyFactory() {
        HttpServiceProxyFactory.Builder builder = this.proxyFactoryBuilder();
        return builder.build();
    }

    private ShadedHttpServiceProxyFactory buildShadedServiceProxyFactory() {
        ShadedHttpServiceProxyFactory.Builder builder = ShadedHttpServiceProxyFactory.builder(this.proxyFactoryBuilder());
        return builder.build();
    }

    private HttpServiceProxyFactory.Builder proxyFactoryBuilder() {
        HttpServiceProxyFactory.Builder builder = ((HttpServiceProxyFactory.Builder)this.beanFactory.getBeanProvider(HttpServiceProxyFactory.Builder.class).getIfUnique(HttpServiceProxyFactory::builder)).clientAdapter((HttpClientAdapter)WebClientAdapter.forClient((WebClient)this.buildWebClient()));
        this.beanFactory.getBeanProvider(HttpServiceArgumentResolver.class).orderedStream().forEach(arg_0 -> ((HttpServiceProxyFactory.Builder)builder).customArgumentResolver(arg_0));
        UrlPlaceholderStringValueResolver delegatedResolver = new UrlPlaceholderStringValueResolver(this.environment, (ObjectProvider<StringValueResolver>)this.beanFactory.getBeanProvider(StringValueResolver.class));
        builder.embeddedValueResolver((StringValueResolver)delegatedResolver);
        Optional.ofNullable(this.channelConfig.getResponseTimeout()).map(Duration::ofMillis).ifPresent(arg_0 -> ((HttpServiceProxyFactory.Builder)builder).blockTimeout(arg_0));
        return builder;
    }

    private WebClient buildWebClient() {
        WebClient.Builder builder = (WebClient.Builder)this.beanFactory.getBeanProvider(WebClient.Builder.class).getIfUnique(WebClient::builder);
        if (StringUtils.hasText((String)this.channelConfig.getBaseUrl())) {
            Object baseUrl = this.channelConfig.getBaseUrl();
            if (!((String)baseUrl).contains("://")) {
                baseUrl = "http://" + (String)baseUrl;
            }
            builder.baseUrl((String)baseUrl);
        } else {
            log.warn("No base-url configuration found for client: {}", (Object)this.clientType.getName());
        }
        if (!CollectionUtils.isEmpty(this.channelConfig.getHeaders())) {
            this.channelConfig.getHeaders().forEach(header -> builder.defaultHeader(header.getKey(), (String[])header.getValues().toArray(String[]::new)));
        }
        return builder.build();
    }
}

