/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import com.freemanan.starter.httpexchange.EnableExchangeClients;
import com.freemanan.starter.httpexchange.HttpClientBeanRegistrar;
import com.freemanan.starter.httpexchange.HttpClientsProperties;
import com.freemanan.starter.httpexchange.Util;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class ExchangeClientsRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private Environment environment;
    private HttpClientsProperties properties;
    private HttpClientBeanRegistrar registrar;

    ExchangeClientsRegistrar() {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        boolean enabled = (Boolean)this.environment.getProperty("http-exchange.enabled", Boolean.class, (Object)true);
        if (!enabled) {
            return;
        }
        this.init(registry);
        Map<String, Object> attrs = Optional.ofNullable(metadata.getAnnotationAttributes(EnableExchangeClients.class.getName())).orElse(Map.of());
        Class[] clientClasses = attrs.getOrDefault("clients", new Class[0]);
        String[] basePackages = this.getBasePackages(attrs);
        if (clientClasses.length > 0) {
            this.registerClassesAsHttpExchange(registry, clientClasses);
            if (basePackages.length > 0) {
                this.registrar.register(basePackages);
            }
            return;
        }
        if (basePackages.length == 0) {
            basePackages = new String[]{ClassUtils.getPackageName((String)metadata.getClassName())};
        }
        this.registrar.register(basePackages);
    }

    private String[] getBasePackages(Map<String, Object> attrs) {
        Object[] basePackages = (String[])attrs.getOrDefault("value", new String[0]);
        return !ObjectUtils.isEmpty((Object[])basePackages) ? basePackages : this.properties.getBasePackages().toArray(new String[0]);
    }

    private void init(BeanDefinitionRegistry registry) {
        this.properties = this.properties == null ? Util.getProperties(this.environment) : this.properties;
        this.registrar = this.registrar == null ? new HttpClientBeanRegistrar(this.properties, registry) : this.registrar;
    }

    private void registerClassesAsHttpExchange(BeanDefinitionRegistry registry, Class<?>[] classes) {
        for (Class<?> clz : classes) {
            this.registrar.registerHttpClientBean(registry, clz.getName());
        }
    }
}

