/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import com.freemanan.starter.httpexchange.HttpClientBeanRegistrar;
import com.freemanan.starter.httpexchange.HttpClientsProperties;
import com.freemanan.starter.httpexchange.Util;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

class HttpClientBeanDefinitionRegistry
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private Environment environment;
    private HttpClientsProperties properties;
    private HttpClientBeanRegistrar registrar;

    HttpClientBeanDefinitionRegistry() {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (HttpClientBeanRegistrar.hasRegistered(registry)) {
            return;
        }
        Object[] packages = HttpClientBeanDefinitionRegistry.getBasePackages(this.environment);
        if (ObjectUtils.isEmpty((Object[])packages)) {
            return;
        }
        this.init(registry);
        this.registrar.register((String[])packages);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private void init(BeanDefinitionRegistry registry) {
        this.properties = this.properties == null ? Util.getProperties(this.environment) : this.properties;
        this.registrar = this.registrar == null ? new HttpClientBeanRegistrar(this.properties, registry) : this.registrar;
    }

    private static String[] getBasePackages(Environment environment) {
        return (String[])Binder.get((Environment)environment).bind("http-exchange.base-packages", String[].class).orElse((Object)new String[0]);
    }
}

