/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import com.freemanan.starter.httpexchange.ExchangeClientCreator;
import com.freemanan.starter.httpexchange.HttpClientsProperties;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionOverrideException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.service.annotation.HttpExchange;

class HttpClientBeanRegistrar {
    private static final Logger log = LoggerFactory.getLogger(HttpClientBeanRegistrar.class);
    private static final Set<BeanDefinitionRegistry> registries = ConcurrentHashMap.newKeySet();
    private final ClassPathScanningCandidateComponentProvider scanner = HttpClientBeanRegistrar.getScanner();
    private final HttpClientsProperties properties;
    private final BeanDefinitionRegistry registry;

    public HttpClientBeanRegistrar(HttpClientsProperties properties, BeanDefinitionRegistry registry) {
        this.properties = properties;
        this.registry = registry;
        registries.add(registry);
    }

    public static boolean hasRegistered(BeanDefinitionRegistry registry) {
        return registries.contains(registry);
    }

    public void register(String ... basePackages) {
        List<String> packages = !ObjectUtils.isEmpty((Object[])basePackages) ? Arrays.asList(basePackages) : this.properties.getBasePackages();
        this.registerBeans4BasePackages(packages);
    }

    public void registerHttpClientBean(BeanDefinitionRegistry registry, String className) {
        Class<?> clz;
        try {
            clz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        if (!clz.isInterface()) {
            throw new IllegalArgumentException(className + " is not an interface");
        }
        boolean hasClientSideAnnotation = HttpClientBeanRegistrar.hasClientSideAnnotation(clz);
        if (!hasClientSideAnnotation && !HttpClientBeanRegistrar.hasServerSideAnnotation(clz)) {
            return;
        }
        Assert.isInstanceOf(ConfigurableBeanFactory.class, (Object)registry);
        ExchangeClientCreator creator = new ExchangeClientCreator((ConfigurableBeanFactory)registry, this.properties, clz, hasClientSideAnnotation);
        AbstractBeanDefinition abd = BeanDefinitionBuilder.genericBeanDefinition(clz, creator::create).getBeanDefinition();
        abd.setPrimary(true);
        abd.setAutowireMode(2);
        abd.setLazyInit(true);
        try {
            registry.registerBeanDefinition(className, (BeanDefinition)abd);
        }
        catch (BeanDefinitionOverrideException ignore) {
            log.warn("Your @HttpExchanges client '{}' is included in base packages, you can remove it from 'clients' property.", (Object)className);
        }
    }

    private static ClassPathScanningCandidateComponentProvider getScanner() {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition abd) {
                return true;
            }
        };
        provider.addIncludeFilter((mr, mrf) -> HttpClientBeanRegistrar.isHttpClientInterface(mr));
        return provider;
    }

    private static boolean isHttpClientInterface(MetadataReader mr) {
        ClassMetadata cm = mr.getClassMetadata();
        AnnotationMetadata am = mr.getAnnotationMetadata();
        return cm.isInterface() && cm.isIndependent() && !cm.isAnnotation() && (am.hasAnnotatedMethods(HttpExchange.class.getName()) || am.hasAnnotatedMethods(RequestMapping.class.getName()));
    }

    private static boolean hasServerSideAnnotation(Class<?> clz) {
        Method[] methods;
        if (AnnotationUtils.findAnnotation(clz, RequestMapping.class) != null) {
            return true;
        }
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(clz)) {
            if (AnnotationUtils.findAnnotation((Method)method, RequestMapping.class) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasClientSideAnnotation(Class<?> clz) {
        Method[] methods;
        if (AnnotationUtils.findAnnotation(clz, HttpExchange.class) != null) {
            return true;
        }
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(clz)) {
            if (AnnotationUtils.findAnnotation((Method)method, HttpExchange.class) == null) continue;
            return true;
        }
        return false;
    }

    private void registerBeans4BasePackages(List<String> basePackages) {
        for (String pkg : basePackages) {
            Set beanDefinitions = this.scanner.findCandidateComponents(pkg);
            for (BeanDefinition bd : beanDefinitions) {
                if (bd.getBeanClassName() == null) continue;
                this.registerHttpClientBean(this.registry, bd.getBeanClassName());
            }
        }
    }
}

