/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import com.freemanan.starter.httpexchange.BeanToQueryArgumentResolver;
import com.freemanan.starter.httpexchange.Cache;
import com.freemanan.starter.httpexchange.HttpClientBeanDefinitionRegistry;
import com.freemanan.starter.httpexchange.HttpClientsProperties;
import com.freemanan.starter.httpexchange.Util;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration
@ConditionalOnClass(value={WebClient.class})
@ConditionalOnProperty(prefix="http-exchange", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={HttpClientsProperties.class})
public class HttpClientsAutoConfiguration
implements SmartInitializingSingleton,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(HttpClientsAutoConfiguration.class);
    private final HttpClientsProperties properties;

    public HttpClientsAutoConfiguration(HttpClientsProperties properties) {
        this.properties = properties;
    }

    @Bean
    public static HttpClientBeanDefinitionRegistry httpClientBeanDefinitionRegistry() {
        return new HttpClientBeanDefinitionRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="http-exchange", name={"bean-to-query"}, havingValue="true")
    public BeanToQueryArgumentResolver beanToQueryArgumentResolver() {
        return new BeanToQueryArgumentResolver();
    }

    public void afterSingletonsInstantiated() {
        this.warningUnusedConfiguration();
    }

    public void destroy() {
        Cache.clear();
    }

    private void warningUnusedConfiguration() {
        Set<Class<?>> classes = Cache.getClientClasses();
        List<HttpClientsProperties.Channel> channels = this.properties.getChannels();
        for (int i = 0; i < channels.size(); ++i) {
            HttpClientsProperties.Channel channel = channels.get(i);
            HttpClientsAutoConfiguration.checkClassesConfiguration(classes, i, channel);
            HttpClientsAutoConfiguration.checkClientsConfiguration(classes, i, channel);
        }
    }

    private static void checkClassesConfiguration(Set<Class<?>> classes, int i, HttpClientsProperties.Channel channel) {
        int s = channel.getClasses().size();
        for (int j = 0; j < s; ++j) {
            Class<?> clazz = channel.getClasses().get(j);
            if (classes.contains(clazz)) continue;
            log.warn("The configuration item '{}.channels[{}].classes[{}]={}' doesn't take effect, please remove it!", new Object[]{"http-exchange", i, j, clazz.getCanonicalName()});
        }
    }

    private static void checkClientsConfiguration(Set<Class<?>> classes, int i, HttpClientsProperties.Channel channel) {
        int size = channel.getClients().size();
        for (int j = 0; j < size; ++j) {
            String name = channel.getClients().get(j);
            if (Util.nameMatch(name, classes)) continue;
            log.warn("The configuration item '{}.channels[{}].clients[{}]={}' doesn't take effect, please remove it!", new Object[]{"http-exchange", i, j, name});
        }
    }
}

