/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="http-exchange")
public class HttpClientsProperties
implements InitializingBean {
    public static final String PREFIX = "http-exchange";
    private boolean enabled = true;
    private List<String> basePackages = new ArrayList<String>();
    private String baseUrl;
    private Long responseTimeout = 5000L;
    private List<Header> headers = new ArrayList<Header>();
    private List<Channel> channels = new ArrayList<Channel>();
    private boolean beanToQuery = false;

    public void afterPropertiesSet() {
        this.merge();
    }

    public void merge() {
        for (Channel chan : this.channels) {
            if (chan.getBaseUrl() == null) {
                chan.setBaseUrl(this.baseUrl);
            }
            if (chan.getResponseTimeout() == null) {
                chan.setResponseTimeout(this.responseTimeout);
            }
            LinkedHashMap total = this.headers.stream().collect(Collectors.toMap(Header::getKey, Header::getValues, (oldV, newV) -> oldV, LinkedHashMap::new));
            for (Header header : chan.getHeaders()) {
                total.put(header.getKey(), header.getValues());
            }
            List<Header> mergedHeaders = total.entrySet().stream().map(e -> new Header((String)e.getKey(), (List)e.getValue())).toList();
            chan.setHeaders(mergedHeaders);
        }
    }

    Channel defaultClient() {
        return new Channel(this.baseUrl, this.responseTimeout, this.headers, List.of(), List.of());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getBasePackages() {
        return this.basePackages;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Long getResponseTimeout() {
        return this.responseTimeout;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public boolean isBeanToQuery() {
        return this.beanToQuery;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBasePackages(List<String> basePackages) {
        this.basePackages = basePackages;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setResponseTimeout(Long responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    public void setBeanToQuery(boolean beanToQuery) {
        this.beanToQuery = beanToQuery;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientsProperties)) {
            return false;
        }
        HttpClientsProperties other = (HttpClientsProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isBeanToQuery() != other.isBeanToQuery()) {
            return false;
        }
        Long this$responseTimeout = this.getResponseTimeout();
        Long other$responseTimeout = other.getResponseTimeout();
        if (this$responseTimeout == null ? other$responseTimeout != null : !((Object)this$responseTimeout).equals(other$responseTimeout)) {
            return false;
        }
        List<String> this$basePackages = this.getBasePackages();
        List<String> other$basePackages = other.getBasePackages();
        if (this$basePackages == null ? other$basePackages != null : !((Object)this$basePackages).equals(other$basePackages)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        List<Header> this$headers = this.getHeaders();
        List<Header> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        List<Channel> this$channels = this.getChannels();
        List<Channel> other$channels = other.getChannels();
        return !(this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientsProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isBeanToQuery() ? 79 : 97);
        Long $responseTimeout = this.getResponseTimeout();
        result = result * 59 + ($responseTimeout == null ? 43 : ((Object)$responseTimeout).hashCode());
        List<String> $basePackages = this.getBasePackages();
        result = result * 59 + ($basePackages == null ? 43 : ((Object)$basePackages).hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        List<Header> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        List<Channel> $channels = this.getChannels();
        result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
        return result;
    }

    public String toString() {
        return "HttpClientsProperties(enabled=" + this.isEnabled() + ", basePackages=" + this.getBasePackages() + ", baseUrl=" + this.getBaseUrl() + ", responseTimeout=" + this.getResponseTimeout() + ", headers=" + this.getHeaders() + ", channels=" + this.getChannels() + ", beanToQuery=" + this.isBeanToQuery() + ")";
    }

    public static class Channel {
        private String baseUrl;
        private Long responseTimeout;
        private List<Header> headers = new ArrayList<Header>();
        private List<String> clients = new ArrayList<String>();
        private List<Class<?>> classes = new ArrayList();

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public Long getResponseTimeout() {
            return this.responseTimeout;
        }

        public List<Header> getHeaders() {
            return this.headers;
        }

        public List<String> getClients() {
            return this.clients;
        }

        public List<Class<?>> getClasses() {
            return this.classes;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public void setResponseTimeout(Long responseTimeout) {
            this.responseTimeout = responseTimeout;
        }

        public void setHeaders(List<Header> headers) {
            this.headers = headers;
        }

        public void setClients(List<String> clients) {
            this.clients = clients;
        }

        public void setClasses(List<Class<?>> classes) {
            this.classes = classes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Channel)) {
                return false;
            }
            Channel other = (Channel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$responseTimeout = this.getResponseTimeout();
            Long other$responseTimeout = other.getResponseTimeout();
            if (this$responseTimeout == null ? other$responseTimeout != null : !((Object)this$responseTimeout).equals(other$responseTimeout)) {
                return false;
            }
            String this$baseUrl = this.getBaseUrl();
            String other$baseUrl = other.getBaseUrl();
            if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
                return false;
            }
            List<Header> this$headers = this.getHeaders();
            List<Header> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            List<String> this$clients = this.getClients();
            List<String> other$clients = other.getClients();
            if (this$clients == null ? other$clients != null : !((Object)this$clients).equals(other$clients)) {
                return false;
            }
            List<Class<?>> this$classes = this.getClasses();
            List<Class<?>> other$classes = other.getClasses();
            return !(this$classes == null ? other$classes != null : !((Object)this$classes).equals(other$classes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Channel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $responseTimeout = this.getResponseTimeout();
            result = result * 59 + ($responseTimeout == null ? 43 : ((Object)$responseTimeout).hashCode());
            String $baseUrl = this.getBaseUrl();
            result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
            List<Header> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            List<String> $clients = this.getClients();
            result = result * 59 + ($clients == null ? 43 : ((Object)$clients).hashCode());
            List<Class<?>> $classes = this.getClasses();
            result = result * 59 + ($classes == null ? 43 : ((Object)$classes).hashCode());
            return result;
        }

        public String toString() {
            return "HttpClientsProperties.Channel(baseUrl=" + this.getBaseUrl() + ", responseTimeout=" + this.getResponseTimeout() + ", headers=" + this.getHeaders() + ", clients=" + this.getClients() + ", classes=" + this.getClasses() + ")";
        }

        public Channel() {
        }

        public Channel(String baseUrl, Long responseTimeout, List<Header> headers, List<String> clients, List<Class<?>> classes) {
            this.baseUrl = baseUrl;
            this.responseTimeout = responseTimeout;
            this.headers = headers;
            this.clients = clients;
            this.classes = classes;
        }
    }

    public static class Header {
        private String key;
        private List<String> values = new ArrayList<String>();

        public String getKey() {
            return this.key;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Header)) {
                return false;
            }
            Header other = (Header)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            List<String> this$values = this.getValues();
            List<String> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Header;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            List<String> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        public String toString() {
            return "HttpClientsProperties.Header(key=" + this.getKey() + ", values=" + this.getValues() + ")";
        }

        public Header() {
        }

        public Header(String key, List<String> values) {
            this.key = key;
            this.values = values;
        }
    }
}

