/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.env.Environment;
import org.springframework.util.StringValueResolver;

class UrlPlaceholderStringValueResolver
implements StringValueResolver {
    private static final Logger log = LoggerFactory.getLogger(UrlPlaceholderStringValueResolver.class);
    private final Environment environment;
    @Nullable
    private final StringValueResolver delegate;

    UrlPlaceholderStringValueResolver(Environment environment, ObjectProvider<StringValueResolver> delegateProvider) {
        this.environment = environment;
        this.delegate = (StringValueResolver)delegateProvider.getIfUnique();
    }

    public String resolveStringValue(String strVal) {
        String resolved;
        try {
            resolved = this.environment.resolvePlaceholders(strVal);
        }
        catch (Exception e) {
            log.warn("Failed to resolve placeholders in '{}'", (Object)strVal, (Object)e);
            resolved = strVal;
        }
        if (this.delegate != null) {
            return this.delegate.resolveStringValue(resolved);
        }
        return resolved;
    }
}

