/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange;

import com.freemanan.starter.httpexchange.HttpClientsProperties;
import java.util.Optional;
import java.util.Set;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.util.AntPathMatcher;

final class Util {
    private static final AntPathMatcher matcher = new AntPathMatcher(".");

    public static Optional<HttpClientsProperties.Channel> findMatchedConfig(Class<?> clz, HttpClientsProperties properties) {
        Optional<HttpClientsProperties.Channel> found = properties.getChannels().stream().filter(it -> it.getClasses().stream().anyMatch(ch -> ch == clz)).findFirst();
        if (found.isPresent()) {
            return found;
        }
        return properties.getChannels().stream().filter(it -> Util.match(clz, it)).findFirst();
    }

    public static boolean nameMatch(String name, Set<Class<?>> classes) {
        return classes.stream().anyMatch(clz -> Util.match(name, clz));
    }

    private static boolean match(Class<?> clz, HttpClientsProperties.Channel client) {
        if (client.getClasses().stream().anyMatch(ch -> ch == clz)) {
            return true;
        }
        return client.getClients().stream().anyMatch(name -> Util.match(name, clz));
    }

    private static boolean match(String name, Class<?> clz) {
        String nameToUse = name.replace("-", "");
        return nameToUse.equalsIgnoreCase(clz.getSimpleName()) || nameToUse.equalsIgnoreCase(clz.getName()) || nameToUse.equalsIgnoreCase(clz.getCanonicalName()) || matcher.match(name, clz.getCanonicalName()) || matcher.match(name, clz.getSimpleName());
    }

    public static HttpClientsProperties getProperties(Environment environment) {
        HttpClientsProperties properties = (HttpClientsProperties)Binder.get((Environment)environment).bind("http-exchange", HttpClientsProperties.class).orElseGet(HttpClientsProperties::new);
        properties.merge();
        return properties;
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

