/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange.shaded;

import jakarta.annotation.Nullable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.service.invoker.HttpClientAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ShadedHttpServiceMethod {
    private final Method method;
    private final MethodParameter[] parameters;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    private final HttpRequestValuesInitializer requestValuesInitializer;
    private final ResponseFunction responseFunction;

    ShadedHttpServiceMethod(Method method, Class<?> containingClass, List<HttpServiceArgumentResolver> argumentResolvers, HttpClientAdapter client, @Nullable StringValueResolver embeddedValueResolver, ReactiveAdapterRegistry reactiveRegistry, Duration blockTimeout) {
        this.method = method;
        this.parameters = ShadedHttpServiceMethod.initMethodParameters(method);
        this.argumentResolvers = argumentResolvers;
        this.requestValuesInitializer = HttpRequestValuesInitializer.create(method, containingClass, embeddedValueResolver);
        this.responseFunction = ResponseFunction.create(client, method, reactiveRegistry, blockTimeout);
    }

    private static MethodParameter[] initMethodParameters(Method method) {
        int count = method.getParameterCount();
        if (count == 0) {
            return new MethodParameter[0];
        }
        if (KotlinDetector.isSuspendingFunction((Method)method)) {
            --count;
        }
        DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
        MethodParameter[] parameters = new MethodParameter[count];
        for (int i = 0; i < count; ++i) {
            parameters[i] = new SynthesizingMethodParameter(method, i);
            parameters[i].initParameterNameDiscovery((ParameterNameDiscoverer)nameDiscoverer);
        }
        return parameters;
    }

    public Method getMethod() {
        return this.method;
    }

    @Nullable
    public Object invoke(Object[] arguments) {
        HttpRequestValues.Builder requestValues = this.requestValuesInitializer.initializeRequestValuesBuilder();
        this.applyArguments(requestValues, arguments);
        return this.responseFunction.execute(requestValues.build());
    }

    private void applyArguments(HttpRequestValues.Builder requestValues, Object[] arguments) {
        Assert.isTrue((arguments.length == this.parameters.length ? 1 : 0) != 0, (String)"Method argument mismatch");
        int i = 0;
        while (i < arguments.length) {
            Object value = arguments[i];
            boolean resolved = false;
            for (HttpServiceArgumentResolver resolver : this.argumentResolvers) {
                if (!resolver.resolve(value, this.parameters[i], requestValues)) continue;
                resolved = true;
                break;
            }
            int index = i++;
            Assert.state((boolean)resolved, () -> ShadedHttpServiceMethod.formatArgumentError(this.parameters[index], "No suitable resolver"));
        }
    }

    private static String formatArgumentError(MethodParameter param, String message) {
        return "Could not resolve parameter [" + param.getParameterIndex() + "] in " + param.getExecutable().toGenericString() + (String)(StringUtils.hasText((String)message) ? ": " + message : "");
    }

    private record HttpRequestValuesInitializer(@Nullable HttpMethod httpMethod, @Nullable String url, @Nullable MediaType contentType, @Nullable List<MediaType> acceptMediaTypes) {
        public HttpRequestValues.Builder initializeRequestValuesBuilder() {
            HttpRequestValues.Builder requestValues = HttpRequestValues.builder();
            if (this.httpMethod != null) {
                requestValues.setHttpMethod(this.httpMethod);
            }
            if (this.url != null) {
                requestValues.setUriTemplate(this.url);
            }
            if (this.contentType != null) {
                requestValues.setContentType(this.contentType);
            }
            if (this.acceptMediaTypes != null) {
                requestValues.setAccept(this.acceptMediaTypes);
            }
            return requestValues;
        }

        public static HttpRequestValuesInitializer create(Method method, Class<?> containingClass, @Nullable StringValueResolver embeddedValueResolver) {
            RequestMapping annot1 = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(containingClass, RequestMapping.class);
            RequestMapping annot2 = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
            Assert.notNull((Object)annot2, (String)"Expected HttpRequest annotation");
            HttpMethod httpMethod = HttpRequestValuesInitializer.initHttpMethod(annot1, annot2);
            String url = HttpRequestValuesInitializer.initUrl(annot1, annot2, embeddedValueResolver);
            MediaType contentType = HttpRequestValuesInitializer.initContentType(annot1, annot2);
            List<MediaType> acceptableMediaTypes = HttpRequestValuesInitializer.initAccept(annot1, annot2);
            return new HttpRequestValuesInitializer(httpMethod, url, contentType, acceptableMediaTypes);
        }

        @Nullable
        private static HttpMethod initHttpMethod(@Nullable RequestMapping typeAnnot, RequestMapping annot) {
            String value2;
            String value1 = (typeAnnot != null ? typeAnnot.method().length : 0) > 0 ? HttpRequestValuesInitializer.asHttpMethod(typeAnnot.method()[0]).name() : null;
            String string = value2 = annot.method().length > 0 ? HttpRequestValuesInitializer.asHttpMethod(annot.method()[0]).name() : null;
            if (StringUtils.hasText(value2)) {
                return HttpMethod.valueOf((String)value2);
            }
            if (StringUtils.hasText((String)value1)) {
                return HttpMethod.valueOf((String)value1);
            }
            return null;
        }

        private static HttpMethod asHttpMethod(RequestMethod method) {
            return switch (method) {
                default -> throw new IncompatibleClassChangeError();
                case RequestMethod.GET -> HttpMethod.GET;
                case RequestMethod.HEAD -> HttpMethod.HEAD;
                case RequestMethod.POST -> HttpMethod.POST;
                case RequestMethod.PUT -> HttpMethod.PUT;
                case RequestMethod.PATCH -> HttpMethod.PATCH;
                case RequestMethod.DELETE -> HttpMethod.DELETE;
                case RequestMethod.OPTIONS -> HttpMethod.OPTIONS;
                case RequestMethod.TRACE -> HttpMethod.TRACE;
            };
        }

        @Nullable
        private static String initUrl(@Nullable RequestMapping typeAnnot, RequestMapping annot, @Nullable StringValueResolver embeddedValueResolver) {
            String url2;
            String url1 = (typeAnnot != null ? typeAnnot.value().length : 0) > 0 ? typeAnnot.value()[0] : null;
            String string = url2 = annot.value().length > 0 ? annot.value()[0] : null;
            if (embeddedValueResolver != null) {
                url1 = url1 != null ? embeddedValueResolver.resolveStringValue(url1) : null;
                url2 = url2 != null ? embeddedValueResolver.resolveStringValue(url2) : null;
            }
            boolean hasUrl1 = StringUtils.hasText((String)url1);
            boolean hasUrl2 = StringUtils.hasText((String)url2);
            if (hasUrl1 && hasUrl2) {
                return url1 + (!url1.endsWith("/") && !url2.startsWith("/") ? "/" : "") + url2;
            }
            if (!hasUrl1 && !hasUrl2) {
                return null;
            }
            return hasUrl2 ? url2 : url1;
        }

        @Nullable
        private static MediaType initContentType(@Nullable RequestMapping typeAnnot, RequestMapping annot) {
            String value2;
            String value1 = (typeAnnot != null ? typeAnnot.consumes().length : 0) > 0 ? typeAnnot.consumes()[0] : null;
            String string = value2 = annot.consumes().length > 0 ? annot.consumes()[0] : null;
            if (StringUtils.hasText((String)value2)) {
                return MediaType.parseMediaType((String)value2);
            }
            if (StringUtils.hasText((String)value1)) {
                return MediaType.parseMediaType((String)value1);
            }
            return null;
        }

        @Nullable
        private static List<MediaType> initAccept(@Nullable RequestMapping typeAnnot, RequestMapping annot) {
            Object[] value1 = typeAnnot != null ? typeAnnot.produces() : null;
            Object[] value2 = annot.produces();
            if (!ObjectUtils.isEmpty((Object[])value2)) {
                return MediaType.parseMediaTypes(Arrays.asList(value2));
            }
            if (!ObjectUtils.isEmpty((Object[])value1)) {
                return MediaType.parseMediaTypes(Arrays.asList(value1));
            }
            return null;
        }
    }

    private record ResponseFunction(Function<HttpRequestValues, Publisher<?>> responseFunction, @Nullable ReactiveAdapter returnTypeAdapter, boolean blockForOptional, Duration blockTimeout) {
        @Nullable
        public Object execute(HttpRequestValues requestValues) {
            Publisher<?> responsePublisher = this.responseFunction.apply(requestValues);
            if (this.returnTypeAdapter != null) {
                return this.returnTypeAdapter.fromPublisher(responsePublisher);
            }
            return this.blockForOptional ? ((Mono)responsePublisher).blockOptional(this.blockTimeout) : ((Mono)responsePublisher).block(this.blockTimeout);
        }

        /*
         * Unable to fully structure code
         */
        public static ResponseFunction create(HttpClientAdapter client, Method method, ReactiveAdapterRegistry reactiveRegistry, Duration blockTimeout) {
            returnParam = new MethodParameter(method, -1);
            returnType = returnParam.getParameterType();
            isSuspending = KotlinDetector.isSuspendingFunction((Method)method);
            if (isSuspending) {
                returnType = Mono.class;
            }
            actualParam = (reactiveAdapter = reactiveRegistry.getAdapter(returnType)) != null ? returnParam.nested() : returnParam.nestedIfOptional();
            v0 = actualType = isSuspending != false ? actualParam.getParameterType() : actualParam.getNestedParameterType();
            if (actualType.equals(Void.TYPE)) ** GOTO lbl13
            if (actualType.equals(Void.class)) {
lbl13:
                // 2 sources

                responseFunction = (Function<HttpRequestValues, Publisher<?>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, requestToVoid(org.springframework.web.service.invoker.HttpRequestValues ), (Lorg/springframework/web/service/invoker/HttpRequestValues;)Lorg/reactivestreams/Publisher;)((HttpClientAdapter)client);
            } else if (reactiveAdapter != null && reactiveAdapter.isNoValue()) {
                responseFunction = (Function<HttpRequestValues, Publisher>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, requestToVoid(org.springframework.web.service.invoker.HttpRequestValues ), (Lorg/springframework/web/service/invoker/HttpRequestValues;)Lorg/reactivestreams/Publisher;)((HttpClientAdapter)client);
            } else if (actualType.equals(HttpHeaders.class)) {
                responseFunction = (Function<HttpRequestValues, Publisher>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, requestToHeaders(org.springframework.web.service.invoker.HttpRequestValues ), (Lorg/springframework/web/service/invoker/HttpRequestValues;)Lorg/reactivestreams/Publisher;)((HttpClientAdapter)client);
            } else if (actualType.equals(ResponseEntity.class)) {
                bodyParam = isSuspending != false ? actualParam : actualParam.nested();
                bodyType = bodyParam.getNestedParameterType();
                if (bodyType.equals(Void.class)) {
                    responseFunction = (Function<HttpRequestValues, Publisher>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, requestToBodilessEntity(org.springframework.web.service.invoker.HttpRequestValues ), (Lorg/springframework/web/service/invoker/HttpRequestValues;)Lorg/reactivestreams/Publisher;)((HttpClientAdapter)client);
                } else {
                    bodyAdapter = reactiveRegistry.getAdapter(bodyType);
                    responseFunction = ResponseFunction.initResponseEntityFunction(client, bodyParam, bodyAdapter, isSuspending);
                }
            } else {
                responseFunction = ResponseFunction.initBodyFunction(client, actualParam, reactiveAdapter, isSuspending);
            }
            blockForOptional = returnType.equals(Optional.class);
            return new ResponseFunction(responseFunction, reactiveAdapter, blockForOptional, blockTimeout);
        }

        private static Function<HttpRequestValues, Publisher<?>> initResponseEntityFunction(HttpClientAdapter client, MethodParameter methodParam, @Nullable ReactiveAdapter reactiveAdapter, boolean isSuspending) {
            if (reactiveAdapter == null) {
                return request -> client.requestToEntity(request, ParameterizedTypeReference.forType((Type)methodParam.getNestedGenericParameterType()));
            }
            Assert.isTrue((boolean)reactiveAdapter.isMultiValue(), (String)"ResponseEntity body must be a concrete value or a multi-value Publisher");
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType((Type)(isSuspending ? methodParam.nested().getGenericParameterType() : methodParam.nested().getNestedGenericParameterType()));
            if (reactiveAdapter.getReactiveType().equals(Flux.class)) {
                return request -> client.requestToEntityFlux(request, bodyType);
            }
            return request -> client.requestToEntityFlux(request, bodyType).map(entity -> {
                Object body = reactiveAdapter.fromPublisher((Publisher)entity.getBody());
                return new ResponseEntity(body, (MultiValueMap)entity.getHeaders(), entity.getStatusCode());
            });
        }

        private static Function<HttpRequestValues, Publisher<?>> initBodyFunction(HttpClientAdapter client, MethodParameter methodParam, @Nullable ReactiveAdapter reactiveAdapter, boolean isSuspending) {
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType((Type)(isSuspending ? methodParam.getGenericParameterType() : methodParam.getNestedGenericParameterType()));
            return reactiveAdapter != null && reactiveAdapter.isMultiValue() ? request -> client.requestToBodyFlux(request, bodyType) : request -> client.requestToBody(request, bodyType);
        }
    }
}

