/*
 * Decompiled with CFR 0.152.
 */
package com.freemanan.starter.httpexchange.shaded;

import com.freemanan.starter.httpexchange.shaded.ShadedHttpServiceMethod;
import jakarta.annotation.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.service.invoker.CookieValueArgumentResolver;
import org.springframework.web.service.invoker.HttpClientAdapter;
import org.springframework.web.service.invoker.HttpMethodArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;
import org.springframework.web.service.invoker.PathVariableArgumentResolver;
import org.springframework.web.service.invoker.RequestAttributeArgumentResolver;
import org.springframework.web.service.invoker.RequestBodyArgumentResolver;
import org.springframework.web.service.invoker.RequestHeaderArgumentResolver;
import org.springframework.web.service.invoker.RequestParamArgumentResolver;
import org.springframework.web.service.invoker.RequestPartArgumentResolver;
import org.springframework.web.service.invoker.UrlArgumentResolver;

public final class ShadedHttpServiceProxyFactory {
    private final HttpClientAdapter clientAdapter;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    @Nullable
    private final StringValueResolver embeddedValueResolver;
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;
    private final Duration blockTimeout;

    private ShadedHttpServiceProxyFactory(HttpClientAdapter clientAdapter, List<HttpServiceArgumentResolver> argumentResolvers, @Nullable StringValueResolver embeddedValueResolver, ReactiveAdapterRegistry reactiveAdapterRegistry, Duration blockTimeout) {
        this.clientAdapter = clientAdapter;
        this.argumentResolvers = argumentResolvers;
        this.embeddedValueResolver = embeddedValueResolver;
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
        this.blockTimeout = blockTimeout;
    }

    public <S> S createClient(Class<S> serviceType) {
        List<ShadedHttpServiceMethod> shadedHttpServiceMethods = MethodIntrospector.selectMethods(serviceType, this::isExchangeMethod).stream().map(method -> this.createHttpServiceMethod(serviceType, (Method)method)).toList();
        return (S)ProxyFactory.getProxy(serviceType, (Interceptor)new HttpServiceMethodInterceptor(shadedHttpServiceMethods));
    }

    private boolean isExchangeMethod(Method method) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, RequestMapping.class);
    }

    private <S> ShadedHttpServiceMethod createHttpServiceMethod(Class<S> serviceType, Method method) {
        Assert.notNull(this.argumentResolvers, (String)"No argument resolvers: afterPropertiesSet was not called");
        return new ShadedHttpServiceMethod(method, serviceType, this.argumentResolvers, this.clientAdapter, this.embeddedValueResolver, this.reactiveAdapterRegistry, this.blockTimeout);
    }

    public static Builder builder(HttpClientAdapter clientAdapter) {
        return new Builder().clientAdapter(clientAdapter);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HttpServiceProxyFactory.Builder builder) {
        return new Builder(builder);
    }

    private static final class HttpServiceMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, ShadedHttpServiceMethod> httpServiceMethods;

        private HttpServiceMethodInterceptor(List<ShadedHttpServiceMethod> methods) {
            this.httpServiceMethods = methods.stream().collect(Collectors.toMap(ShadedHttpServiceMethod::getMethod, Function.identity()));
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            ShadedHttpServiceMethod shadedHttpServiceMethod = this.httpServiceMethods.get(method);
            if (shadedHttpServiceMethod != null) {
                return shadedHttpServiceMethod.invoke(invocation.getArguments());
            }
            if (method.isDefault() && invocation instanceof ReflectiveMethodInvocation) {
                ReflectiveMethodInvocation reflectiveMethodInvocation = (ReflectiveMethodInvocation)invocation;
                Object proxy = reflectiveMethodInvocation.getProxy();
                return InvocationHandler.invokeDefault(proxy, method, invocation.getArguments());
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }
    }

    public static final class Builder {
        @Nullable
        private HttpClientAdapter clientAdapter;
        private final List<HttpServiceArgumentResolver> customArgumentResolvers = new ArrayList<HttpServiceArgumentResolver>();
        @Nullable
        private ConversionService conversionService;
        @Nullable
        private StringValueResolver embeddedValueResolver;
        private ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
        @Nullable
        private Duration blockTimeout;

        private Builder() {
        }

        private Builder(HttpServiceProxyFactory.Builder builder) {
            this.clientAdapter = (HttpClientAdapter)Builder.getFieldValue(builder, "clientAdapter");
            this.customArgumentResolvers.addAll((Collection)Builder.getFieldValue(builder, "customArgumentResolvers"));
            this.conversionService = (ConversionService)Builder.getFieldValue(builder, "conversionService");
            this.embeddedValueResolver = (StringValueResolver)Builder.getFieldValue(builder, "embeddedValueResolver");
            this.reactiveAdapterRegistry = (ReactiveAdapterRegistry)Builder.getFieldValue(builder, "reactiveAdapterRegistry");
            this.blockTimeout = (Duration)Builder.getFieldValue(builder, "blockTimeout");
        }

        private static <V> V getFieldValue(Object object, String fieldName) {
            Field field = ReflectionUtils.findField(object.getClass(), (String)fieldName);
            Assert.notNull((Object)field, (String)("Field '" + fieldName + "' not found"));
            ReflectionUtils.makeAccessible((Field)field);
            return (V)ReflectionUtils.getField((Field)field, (Object)object);
        }

        public Builder clientAdapter(HttpClientAdapter clientAdapter) {
            this.clientAdapter = clientAdapter;
            return this;
        }

        public Builder customArgumentResolver(HttpServiceArgumentResolver resolver) {
            this.customArgumentResolvers.add(resolver);
            return this;
        }

        public Builder conversionService(ConversionService conversionService) {
            this.conversionService = conversionService;
            return this;
        }

        public Builder embeddedValueResolver(StringValueResolver embeddedValueResolver) {
            this.embeddedValueResolver = embeddedValueResolver;
            return this;
        }

        public Builder reactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
            this.reactiveAdapterRegistry = registry;
            return this;
        }

        public Builder blockTimeout(Duration blockTimeout) {
            this.blockTimeout = blockTimeout;
            return this;
        }

        public ShadedHttpServiceProxyFactory build() {
            Assert.notNull((Object)this.clientAdapter, (String)"HttpClientAdapter is required");
            return new ShadedHttpServiceProxyFactory(this.clientAdapter, this.initArgumentResolvers(), this.embeddedValueResolver, this.reactiveAdapterRegistry, this.blockTimeout != null ? this.blockTimeout : Duration.ofSeconds(5L));
        }

        private List<HttpServiceArgumentResolver> initArgumentResolvers() {
            ArrayList<HttpServiceArgumentResolver> resolvers = new ArrayList<HttpServiceArgumentResolver>(this.customArgumentResolvers);
            ConversionService service = this.conversionService != null ? this.conversionService : new DefaultFormattingConversionService();
            resolvers.add((HttpServiceArgumentResolver)new RequestHeaderArgumentResolver(service));
            resolvers.add((HttpServiceArgumentResolver)new RequestBodyArgumentResolver(this.reactiveAdapterRegistry));
            resolvers.add((HttpServiceArgumentResolver)new PathVariableArgumentResolver(service));
            resolvers.add((HttpServiceArgumentResolver)new RequestParamArgumentResolver(service));
            resolvers.add((HttpServiceArgumentResolver)new RequestPartArgumentResolver(this.reactiveAdapterRegistry));
            resolvers.add((HttpServiceArgumentResolver)new CookieValueArgumentResolver(service));
            resolvers.add((HttpServiceArgumentResolver)new RequestAttributeArgumentResolver());
            resolvers.add((HttpServiceArgumentResolver)new UrlArgumentResolver());
            resolvers.add((HttpServiceArgumentResolver)new HttpMethodArgumentResolver());
            return resolvers;
        }
    }
}

