/*
 * Decompiled with CFR 0.152.
 */
package com.freewayso.image.combiner;

import com.freewayso.image.combiner.element.CombineElement;
import com.freewayso.image.combiner.element.ImageElement;
import com.freewayso.image.combiner.element.RectangleElement;
import com.freewayso.image.combiner.element.TextElement;
import com.freewayso.image.combiner.enums.OutputFormat;
import com.freewayso.image.combiner.enums.ZoomMode;
import com.freewayso.image.combiner.painter.IPainter;
import com.freewayso.image.combiner.painter.PainterFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class ImageCombiner {
    private List<CombineElement> combineElements = new ArrayList<CombineElement>();
    private BufferedImage combinedImage;
    private int canvasWidth;
    private int canvasHeight;
    private OutputFormat outputFormat;
    private Integer roundCorner;
    private Float quality = Float.valueOf(1.0f);

    public ImageCombiner(int canvasWidth, int canvasHeight, OutputFormat outputFormat) {
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.outputFormat = outputFormat;
    }

    public ImageCombiner(int canvasWidth, int canvasHeight, Color bgColor, OutputFormat outputFormat) {
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.outputFormat = outputFormat;
        RectangleElement bgElement = new RectangleElement(0, 0, canvasWidth, canvasHeight);
        bgElement.setColor(bgColor);
        this.combineElements.add(bgElement);
    }

    public ImageCombiner(String bgImageUrl, OutputFormat outputFormat) throws Exception {
        this(ImageIO.read(new URL(bgImageUrl)), outputFormat);
    }

    public ImageCombiner(BufferedImage bgImage, OutputFormat outputFormat) {
        ImageElement bgImageElement = new ImageElement(bgImage, 0, 0);
        this.combineElements.add(bgImageElement);
        this.canvasWidth = bgImage.getWidth();
        this.canvasHeight = bgImage.getHeight();
        this.outputFormat = outputFormat;
    }

    public ImageCombiner(String bgImageUrl, int width, int height, ZoomMode zoomMode, OutputFormat outputFormat) throws Exception {
        this(ImageIO.read(new URL(bgImageUrl)), width, height, zoomMode, outputFormat);
    }

    public ImageCombiner(BufferedImage bgImage, int width, int height, ZoomMode zoomMode, OutputFormat outputFormat) {
        ImageElement bgImageElement = new ImageElement(bgImage, 0, 0, width, height, zoomMode);
        int canvasWidth = 0;
        int canvasHeight = 0;
        switch (zoomMode) {
            case Origin: {
                canvasWidth = bgImage.getWidth();
                canvasHeight = bgImage.getHeight();
                break;
            }
            case Width: {
                canvasWidth = width;
                canvasHeight = bgImage.getHeight() * canvasWidth / bgImage.getWidth();
                break;
            }
            case Height: {
                canvasHeight = height;
                canvasWidth = bgImage.getWidth() * canvasHeight / bgImage.getHeight();
                break;
            }
            case WidthHeight: {
                canvasHeight = height;
                canvasWidth = width;
            }
        }
        this.combineElements.add(bgImageElement);
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.outputFormat = outputFormat;
    }

    public BufferedImage combine() throws Exception {
        this.combinedImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D g = this.combinedImage.createGraphics();
        if (this.outputFormat == OutputFormat.PNG) {
            this.combinedImage = g.getDeviceConfiguration().createCompatibleImage(this.canvasWidth, this.canvasHeight, 3);
            g = this.combinedImage.createGraphics();
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        for (CombineElement element : this.combineElements) {
            IPainter painter = PainterFactory.createInstance(element);
            if (element.isRepeat()) {
                painter.drawRepeat(g, element, this.canvasWidth, this.canvasHeight);
                continue;
            }
            painter.draw(g, element, this.canvasWidth);
        }
        g.dispose();
        if (this.roundCorner != null) {
            this.combinedImage = this.makeRoundCorner(this.combinedImage, this.canvasWidth, this.canvasHeight, this.roundCorner);
        }
        return this.combinedImage;
    }

    public void setBackgroundBlur(int blur) {
        ImageElement bgElement = (ImageElement)this.combineElements.get(0);
        bgElement.setBlur(blur);
    }

    public void setCanvasRoundCorner(Integer roundCorner) throws Exception {
        if (this.outputFormat != OutputFormat.PNG) {
            throw new Exception("\u6574\u56fe\u5706\u89d2\uff0c\u8f93\u51fa\u683c\u5f0f\u5fc5\u987b\u8bbe\u7f6e\u4e3aPNG");
        }
        this.roundCorner = roundCorner;
    }

    public Float getQuality() {
        return this.quality;
    }

    public void setQuality(Float quality) {
        this.quality = quality;
    }

    public int getCanvasWidth() {
        return this.canvasWidth;
    }

    public int getCanvasHeight() {
        return this.canvasHeight;
    }

    public BufferedImage getCombinedImage() {
        return this.combinedImage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getCombinedImageStream() throws Exception {
        if (this.combinedImage == null) throw new Exception("\u5c1a\u672a\u6267\u884c\u56fe\u7247\u5408\u6210\uff0c\u65e0\u6cd5\u8f93\u51fa\u6587\u4ef6\u6d41");
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)this.combinedImage, this.outputFormat.getName(), os);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            throw new Exception("\u6267\u884c\u56fe\u7247\u5408\u6210\u5931\u8d25\uff0c\u65e0\u6cd5\u8f93\u51fa\u6587\u4ef6\u6d41");
        }
    }

    public void save(String filePath) throws Exception {
        ImageWriteParam param;
        ImageWriter writer;
        if (this.combinedImage != null) {
            writer = ImageIO.getImageWritersBySuffix(this.outputFormat.getName()).next();
            param = writer.getDefaultWriteParam();
            if (param.canWriteCompressed()) {
                param.setCompressionMode(2);
                param.setCompressionQuality(this.quality.floatValue());
            }
        } else {
            throw new Exception("\u5c1a\u672a\u6267\u884c\u56fe\u7247\u5408\u6210\uff0c\u65e0\u6cd5\u4fdd\u5b58\u6587\u4ef6");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        writer.setOutput(new MemoryCacheImageOutputStream(os));
        writer.write(null, new IIOImage(this.combinedImage, null, null), param);
        writer.dispose();
        FileOutputStream file = new FileOutputStream(filePath);
        file.write(os.toByteArray());
        file.close();
        os.close();
    }

    public void addElement(CombineElement element) {
        this.combineElements.add(element);
    }

    public ImageElement addImageElement(String imgUrl, int x, int y) throws Exception {
        ImageElement imageElement = new ImageElement(imgUrl, x, y);
        this.combineElements.add(imageElement);
        return imageElement;
    }

    public ImageElement addImageElement(BufferedImage image, int x, int y) {
        ImageElement imageElement = new ImageElement(image, x, y);
        this.combineElements.add(imageElement);
        return imageElement;
    }

    public ImageElement addImageElement(String imgUrl, int x, int y, int width, int height, ZoomMode zoomMode) {
        ImageElement imageElement = new ImageElement(imgUrl, x, y, width, height, zoomMode);
        this.combineElements.add(imageElement);
        return imageElement;
    }

    public ImageElement addImageElement(BufferedImage image, int x, int y, int width, int height, ZoomMode zoomMode) {
        ImageElement imageElement = new ImageElement(image, x, y, width, height, zoomMode);
        this.combineElements.add(imageElement);
        return imageElement;
    }

    public TextElement addTextElement(String text, Font font, int x, int y) {
        TextElement textElement = new TextElement(text, font, x, y);
        this.combineElements.add(textElement);
        return textElement;
    }

    public TextElement addTextElement(String text, int fontSize, int x, int y) {
        TextElement textElement = new TextElement(text, fontSize, x, y);
        this.combineElements.add(textElement);
        return textElement;
    }

    public TextElement addTextElement(String text, int fontStyle, int fontSize, int x, int y) {
        TextElement textElement = new TextElement(text, fontStyle, fontSize, x, y);
        this.combineElements.add(textElement);
        return textElement;
    }

    public TextElement addTextElement(String text, String fontNameOrPath, int fontSize, int x, int y) {
        TextElement textElement = new TextElement(text, fontNameOrPath, fontSize, x, y);
        this.combineElements.add(textElement);
        return textElement;
    }

    public TextElement addTextElement(String text, String fontNameOrPath, int fontStyle, int fontSize, int x, int y) {
        TextElement textElement = new TextElement(text, fontNameOrPath, fontStyle, fontSize, x, y);
        this.combineElements.add(textElement);
        return textElement;
    }

    public RectangleElement addRectangleElement(int x, int y, int width, int height) {
        RectangleElement rectangleElement = new RectangleElement(x, y, width, height);
        this.combineElements.add(rectangleElement);
        return rectangleElement;
    }

    private BufferedImage makeRoundCorner(BufferedImage srcImage, int width, int height, int radius) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillRoundRect(0, 0, width, height, radius, radius);
        g.setComposite(AlphaComposite.SrcIn);
        g.drawImage(srcImage, 0, 0, width, height, null);
        g.dispose();
        return image;
    }
}

