/*
 * Decompiled with CFR 0.152.
 */
package com.force.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.force.api.ApiVersion;
import com.force.api.SessionRefreshListener;
import java.net.URI;
import java.net.URLDecoder;

public class ApiConfig {
    ApiVersion apiVersion = ApiVersion.DEFAULT_VERSION;
    String apiVersionString;
    String username;
    String password;
    String loginEndpoint = "https://login.salesforce.com";
    String clientId;
    String clientSecret;
    String redirectURI;
    SessionRefreshListener sessionRefreshListener;
    ObjectMapper objectMapper = new ObjectMapper();
    int requestTimeout = 0;

    public ApiConfig() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public ApiConfig clone() {
        return new ApiConfig().setApiVersion(this.apiVersion).setUsername(this.username).setPassword(this.password).setLoginEndpoint(this.loginEndpoint).setClientId(this.clientId).setClientSecret(this.clientSecret).setRedirectURI(this.redirectURI).setObjectMapper(this.objectMapper).setRequestTimeout(this.requestTimeout);
    }

    public ApiConfig setForceURL(String url) {
        try {
            URI uri = new URI(url);
            this.loginEndpoint = "https://" + uri.getHost() + (uri.getPort() > 0 ? ":" + uri.getPort() : "");
            if (uri.getQuery() != null) {
                String[] params;
                for (String param : params = uri.getQuery().split("&")) {
                    String[] kv = param.split("=");
                    if (kv[0].equals("user")) {
                        this.username = URLDecoder.decode(kv[1], "UTF-8");
                        continue;
                    }
                    if (kv[0].equals("password")) {
                        this.password = URLDecoder.decode(kv[1], "UTF-8");
                        continue;
                    }
                    if (kv[0].equals("oauth_key")) {
                        this.clientId = URLDecoder.decode(kv[1], "UTF-8");
                        continue;
                    }
                    if (!kv[0].equals("oauth_secret")) continue;
                    this.clientSecret = URLDecoder.decode(kv[1], "UTF-8");
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't parse URL: " + url, e);
        }
        return this;
    }

    public ApiConfig setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        return this;
    }

    public ApiConfig setApiVersion(ApiVersion value) {
        this.apiVersion = value;
        return this;
    }

    public ApiConfig setApiVersionString(String value) {
        this.apiVersionString = value;
        return this;
    }

    public ApiConfig setUsername(String value) {
        this.username = value;
        return this;
    }

    public ApiConfig setPassword(String value) {
        this.password = value;
        return this;
    }

    public ApiConfig setLoginEndpoint(String value) {
        this.loginEndpoint = value;
        return this;
    }

    public ApiConfig setClientId(String value) {
        this.clientId = value;
        return this;
    }

    public ApiConfig setClientSecret(String value) {
        this.clientSecret = value;
        return this;
    }

    public ApiConfig setSessionRefreshListener(SessionRefreshListener value) {
        this.sessionRefreshListener = value;
        return this;
    }

    public ApiConfig setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public ApiConfig setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLoginEndpoint() {
        return this.loginEndpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public SessionRefreshListener getSessionRefreshListener() {
        return this.sessionRefreshListener;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public String getApiVersionString() {
        return this.apiVersionString != null ? this.apiVersionString : this.apiVersion.toString();
    }
}

