/*
 * Decompiled with CFR 0.152.
 */
package com.force.api;

public class ExtendedApiVersion
implements Comparable<ExtendedApiVersion> {
    private String label;
    private String url;
    float version;

    public ExtendedApiVersion() {
    }

    public ExtendedApiVersion(float version) {
        this.version = version;
    }

    public ExtendedApiVersion(Season s, int y) {
        this.version = 3 * (y - 2004) + s.ordinal() - 1;
        if (this.version < 20.0f) {
            throw new IllegalArgumentException("Only Winter 2011 (v20.0) and later versions are supported");
        }
    }

    public ExtendedApiVersion(String version) {
        this.version = Float.parseFloat(version.substring(1));
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public float getVersion() {
        return this.version;
    }

    public String getVersionString() {
        return "v" + this.version;
    }

    public void setVersion(float version) {
        this.version = version;
    }

    public boolean equals(Object other) {
        return other instanceof ExtendedApiVersion && ((ExtendedApiVersion)other).version == this.version;
    }

    public String toString() {
        return this.getVersionString();
    }

    @Override
    public int compareTo(ExtendedApiVersion o) {
        return Float.compare(this.version, o.version);
    }

    public static enum Season {
        WINTER,
        SPRING,
        SUMMER;

    }
}

