/*
 * Decompiled with CFR 0.152.
 */
package com.force.api;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.force.api.ResourceException;
import com.force.api.http.HttpResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ResourceRepresentation {
    public final ObjectMapper jsonMapper;
    HttpResponse response;

    public ResourceRepresentation(HttpResponse value) {
        this.jsonMapper = new ObjectMapper();
        this.response = value;
    }

    public ResourceRepresentation(HttpResponse value, ObjectMapper objectMapper) {
        this.jsonMapper = objectMapper;
        this.response = value;
    }

    public <T> T as(Class<T> clazz) {
        try {
            return (T)this.jsonMapper.readValue(this.response.getStream(), clazz);
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public Map<?, ?> asMap() {
        try {
            return (Map)this.jsonMapper.readValue(this.response.getStream(), Map.class);
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public List<?> asList() {
        try {
            return (List)this.jsonMapper.readValue(this.response.getStream(), List.class);
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public int getResponseCode() {
        return this.response.getResponseCode();
    }
}

