/*
 * Decompiled with CFR 0.152.
 */
package com.force.api;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.force.api.ApiConfig;
import com.force.api.ApiException;
import com.force.api.ApiSession;
import com.force.api.ApiTokenException;
import com.force.api.Auth;
import com.force.api.CreateOrUpdateResult;
import com.force.api.CreateResponse;
import com.force.api.DescribeGlobal;
import com.force.api.DescribeSObject;
import com.force.api.DescribeSObjectBasic;
import com.force.api.DiscoverSObject;
import com.force.api.ExtendedApiVersion;
import com.force.api.Identity;
import com.force.api.QueryResult;
import com.force.api.ResourceException;
import com.force.api.ResourceRepresentation;
import com.force.api.SObjectException;
import com.force.api.SupportedVersions;
import com.force.api.http.Http;
import com.force.api.http.HttpRequest;
import com.force.api.http.HttpResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceApi {
    private final ObjectMapper jsonMapper;
    private static final Logger logger = LoggerFactory.getLogger(ForceApi.class);
    private static final String SF_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    final ApiConfig config;
    ApiSession session;
    private boolean autoRenew = false;
    boolean useRootPath = false;

    public ForceApi(ApiConfig config, ApiSession session) {
        this.config = config;
        this.jsonMapper = config.getObjectMapper();
        this.session = session;
        if (session.getRefreshToken() != null) {
            this.autoRenew = true;
        }
    }

    public ForceApi(ApiSession session) {
        this(new ApiConfig(), session);
    }

    public ForceApi(ApiConfig apiConfig) {
        this.config = apiConfig;
        this.jsonMapper = this.config.getObjectMapper();
        this.session = Auth.authenticate(apiConfig);
        this.autoRenew = true;
    }

    public ApiSession getSession() {
        return this.session;
    }

    public ForceApi rootPath() {
        ForceApi clone = new ForceApi(this.config, this.session);
        clone.useRootPath = true;
        return clone;
    }

    public String curlHelper() {
        return "curl -s -H 'Authorization: Bearer " + this.session.getAccessToken() + "' " + this.uriBase() + " | jq .";
    }

    public ResourceRepresentation get(String path) {
        return new ResourceRepresentation(this.apiRequest(new HttpRequest().url(this.uriBaseOrRoot() + path).method("GET").header("Accept", "application/json")), this.jsonMapper);
    }

    public ResourceRepresentation delete(String path) {
        return new ResourceRepresentation(this.apiRequest(new HttpRequest().url(this.uriBaseOrRoot() + path).method("DELETE").header("Accept", "application/json")), this.jsonMapper);
    }

    public ResourceRepresentation post(String path, Object input) {
        return this.request("POST", path, input);
    }

    public ResourceRepresentation put(String path, Object input) {
        return this.request("PUT", path, input);
    }

    public ResourceRepresentation patch(String path, Object input) {
        char sep = path.contains("?") ? (char)'&' : '?';
        return this.request("POST", path + sep + "_HttpMethod=PATCH", input);
    }

    public ResourceRepresentation request(String method, String path, Object input) {
        try {
            return new ResourceRepresentation(this.apiRequest(new HttpRequest().url(this.uriBaseOrRoot() + path).method(method).header("Accept", "application/json").header("Content-Type", "application/json").content(this.jsonMapper.writeValueAsBytes(input))), this.jsonMapper);
        }
        catch (JsonGenerationException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public Identity getIdentity() {
        try {
            Map resp = (Map)this.jsonMapper.readValue(this.apiRequest(new HttpRequest().url(this.uriBase()).method("GET").header("Accept", "application/json")).getStream(), Map.class);
            return (Identity)this.jsonMapper.readValue(this.apiRequest(new HttpRequest().url((String)resp.get("identity")).method("GET").header("Accept", "application/json")).getStream(), Identity.class);
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceRepresentation getSObject(String type, String id) throws ResourceException {
        return new ResourceRepresentation(this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + type + "/" + id).method("GET").header("Accept", "application/json")), this.jsonMapper);
    }

    public String createSObject(String type, Object sObject) {
        try {
            CreateResponse result = (CreateResponse)this.jsonMapper.readValue(this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + type).method("POST").header("Accept", "application/json").header("Content-Type", "application/json").expectsCode(201).content(this.jsonMapper.writeValueAsBytes(sObject))).getStream(), CreateResponse.class);
            if (result.isSuccess()) {
                return result.getId();
            }
            throw new SObjectException(result.getErrors());
        }
        catch (JsonGenerationException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public void updateSObject(String type, String id, Object sObject) {
        try {
            this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + type + "/" + id + "?_HttpMethod=PATCH").method("POST").header("Accept", "application/json").header("Content-Type", "application/json").expectsCode(204).content(this.jsonMapper.writeValueAsBytes(sObject)));
        }
        catch (JsonGenerationException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public void deleteSObject(String type, String id) {
        this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + type + "/" + id).method("DELETE"));
    }

    public CreateOrUpdateResult createOrUpdateSObject(String type, String externalIdField, String externalIdValue, Object sObject) {
        try {
            HttpResponse res = this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + type + "/" + externalIdField + "/" + URLEncoder.encode(externalIdValue, "UTF-8") + "?_HttpMethod=PATCH").method("POST").header("Accept", "application/json").header("Content-Type", "application/json").content(this.jsonMapper.writeValueAsBytes(sObject)));
            ExtendedApiVersion extendedApiVersion = new ExtendedApiVersion(this.config.getApiVersionString());
            if (extendedApiVersion.getVersion() >= 46.0f) {
                Map respData = (Map)this.jsonMapper.readValue(res.getStream(), Map.class);
                if (respData.get("created").toString().equals("true")) {
                    return CreateOrUpdateResult.CREATED;
                }
                return CreateOrUpdateResult.UPDATED;
            }
            if (res.getResponseCode() == 201) {
                return CreateOrUpdateResult.CREATED;
            }
            if (res.getResponseCode() == 204) {
                return CreateOrUpdateResult.UPDATED;
            }
            logger.debug("Code: {}", (Object)res.getResponseCode());
            logger.debug("Message: {}", (Object)res.getString());
            throw new RuntimeException();
        }
        catch (JsonGenerationException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public <T> QueryResult<T> query(String query, Class<T> clazz) {
        try {
            return this.queryAny(this.uriBase() + "/query/?q=" + URLEncoder.encode(query, "UTF-8"), clazz);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
    }

    public QueryResult<Map> query(String query) {
        return this.query(query, Map.class);
    }

    public <T> QueryResult<T> queryMore(String nextRecordsUrl, Class<T> clazz) {
        return this.queryAny(this.session.getApiEndpoint() + nextRecordsUrl, clazz);
    }

    public QueryResult<Map> queryMore(String nextRecordsUrl) {
        return this.queryMore(nextRecordsUrl, Map.class);
    }

    public <T> QueryResult<T> queryAll(String query, Class<T> clazz) {
        try {
            return this.queryAny(this.uriBase() + "/queryAll/?q=" + URLEncoder.encode(query, "UTF-8"), clazz);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
    }

    private <T> QueryResult<T> queryAny(String queryUrl, Class<T> clazz) {
        try {
            HttpResponse res = this.apiRequest(new HttpRequest().url(queryUrl).method("GET").header("Accept", "application/json").expectsCode(200));
            QueryResult result = new QueryResult();
            JsonNode root = this.jsonMapper.readTree(res.getStream());
            result.setDone(root.get("done").booleanValue());
            result.setTotalSize(root.get("totalSize").intValue());
            if (root.get("nextRecordsUrl") != null) {
                result.setNextRecordsUrl(root.get("nextRecordsUrl").textValue());
            }
            ArrayList<Object> records = new ArrayList<Object>();
            for (JsonNode elem : root.get("records")) {
                records.add(this.jsonMapper.readValue(this.normalizeCompositeResponse(elem).traverse(), clazz));
            }
            result.setRecords(records);
            return result;
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public DescribeGlobal describeGlobal() {
        try {
            return (DescribeGlobal)this.jsonMapper.readValue(this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/").method("GET").header("Accept", "application/json")).getStream(), DescribeGlobal.class);
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public SupportedVersions getSupportedVersions() {
        try {
            return (SupportedVersions)this.jsonMapper.readValue(this.apiRequest(new HttpRequest().url(this.session.getApiEndpoint() + "/services/data").method("GET").header("Accept", "application/json")).getStream(), SupportedVersions.class);
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public <T> DiscoverSObject<T> discoverSObject(String sobject, Class<T> clazz) {
        try {
            HttpResponse res = this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + sobject).method("GET").header("Accept", "application/json").expectsCode(200));
            JsonNode root = this.jsonMapper.readTree(res.getStream());
            DescribeSObjectBasic describeSObjectBasic = (DescribeSObjectBasic)this.jsonMapper.readValue(root.get("objectDescribe").traverse(), DescribeSObjectBasic.class);
            ArrayList<Object> recentItems = new ArrayList<Object>();
            for (JsonNode item : root.get("recentItems")) {
                recentItems.add(this.jsonMapper.readValue(item.traverse(), clazz));
            }
            return new DiscoverSObject(describeSObjectBasic, recentItems);
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public DescribeSObject describeSObject(String sobject) {
        try {
            return (DescribeSObject)this.jsonMapper.readValue(this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + sobject + "/describe").method("GET").header("Accept", "application/json")).getStream(), DescribeSObject.class);
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public DescribeSObject describeSObjectIfModified(String sobject, Date since) {
        if (since == null) {
            return this.describeSObject(sobject);
        }
        try {
            HttpResponse response = this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + sobject + "/describe").method("GET").header("Accept", "application/json").header("If-Modified-Since", new SimpleDateFormat(SF_DATE_FORMAT).format(since)));
            if (response.getResponseCode() == 304) {
                return null;
            }
            return (DescribeSObject)this.jsonMapper.readValue(response.getStream(), DescribeSObject.class);
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    private final String uriBase() {
        return this.session.getApiEndpoint() + "/services/data/" + this.config.getApiVersionString();
    }

    private final String uriBaseOrRoot() {
        if (this.useRootPath) {
            return this.session.getApiEndpoint();
        }
        return this.session.getApiEndpoint() + "/services/data/" + this.config.getApiVersionString();
    }

    private final HttpResponse apiRequest(HttpRequest req) {
        req.setAuthorization("Bearer " + this.session.getAccessToken());
        req.setRequestTimeout(this.config.getRequestTimeout());
        HttpResponse res = Http.send(req);
        if (res.getResponseCode() == 401 && this.autoRenew) {
            logger.debug("Session expired. Refreshing session...");
            this.session = this.session.getRefreshToken() != null ? Auth.refreshOauthTokenFlow(this.config, this.session.getRefreshToken()) : Auth.authenticate(this.config);
            if (this.config.getSessionRefreshListener() != null) {
                this.config.getSessionRefreshListener().sessionRefreshed(this.session);
            }
            req.setAuthorization("Bearer " + this.session.getAccessToken());
            res = Http.send(req);
        }
        if (res.getResponseCode() > 299 && res.getResponseCode() != 304) {
            if (res.getResponseCode() == 401) {
                throw new ApiTokenException(res.getString());
            }
            throw new ApiException(res.getResponseCode(), res.getString());
        }
        if (req.getExpectedCode() != -1 && res.getResponseCode() != req.getExpectedCode()) {
            throw new RuntimeException("Unexpected response from Force API. Got response code " + res.getResponseCode() + ". Was expecting " + req.getExpectedCode());
        }
        return res;
    }

    private final JsonNode normalizeCompositeResponse(JsonNode node) {
        Iterator elements = node.fields();
        ObjectNode newNode = JsonNodeFactory.instance.objectNode();
        while (elements.hasNext()) {
            Map.Entry currNode = (Map.Entry)elements.next();
            newNode.set((String)currNode.getKey(), ((JsonNode)currNode.getValue()).isObject() && ((JsonNode)currNode.getValue()).get("records") != null ? ((JsonNode)currNode.getValue()).get("records") : (JsonNode)currNode.getValue());
        }
        return newNode;
    }
}

