/*
 * Decompiled with CFR 0.152.
 */
package com.force.api.http;

import com.force.api.http.HttpRequest;
import com.force.api.http.HttpResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http {
    static final Logger logger = LoggerFactory.getLogger(Http.class);

    static final byte[] readResponse(InputStream stream) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(stream);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[10000];
        int read = 0;
        while ((read = bin.read(buf)) != -1) {
            bout.write(buf, 0, read);
        }
        return bout.toByteArray();
    }

    public static final HttpResponse send(HttpRequest req) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(req.getUrl()).openConnection();
            if (req.getRequestTimeout() > 0) {
                conn.setConnectTimeout(req.getRequestTimeout());
                conn.setReadTimeout(req.getRequestTimeout());
            }
            conn.setInstanceFollowRedirects(true);
            conn.setRequestMethod(req.getMethod());
            for (HttpRequest.Header h : req.getHeaders()) {
                conn.addRequestProperty(h.getKey(), h.getValue());
            }
            if (req.getAuthorization() != null) {
                conn.addRequestProperty("Authorization", req.getAuthorization());
            }
            if (req.getContentBytes() != null) {
                conn.setDoOutput(true);
                BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
                out.write(req.getContentBytes());
                out.flush();
            } else if (req.getContentStream() != null) {
                int n;
                conn.setDoOutput(true);
                byte[] buf = new byte[2000];
                BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
                while ((n = req.getContentStream().read(buf)) >= 0) {
                    out.write(buf, 0, n);
                }
                out.flush();
            }
            int code = conn.getResponseCode();
            if (200 <= code && code < 300) {
                switch (req.getResponseFormat()) {
                    case BYTE: {
                        return new HttpResponse().setByte(Http.readResponse(conn.getInputStream())).setResponseCode(code);
                    }
                    case STRING: {
                        return new HttpResponse().setString(new String(Http.readResponse(conn.getInputStream()), "UTF-8")).setResponseCode(code);
                    }
                }
                return new HttpResponse().setStream(conn.getInputStream()).setResponseCode(code);
            }
            if (code == 304) {
                return new HttpResponse().setResponseCode(code);
            }
            logger.info("Bad response code: {} on request: {} {}", new Object[]{code, req.getMethod(), req.getUrl()});
            HttpResponse response = new HttpResponse().setResponseCode(code);
            if (conn.getErrorStream() != null) {
                response.setString(new String(Http.readResponse(conn.getErrorStream()), "UTF-8"));
            } else {
                response.setString(conn.getResponseMessage());
            }
            return response;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

