/*
 * Decompiled with CFR 0.152.
 */
package com.force.api.http;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class HttpRequest {
    ResponseFormat responseFormat = ResponseFormat.STREAM;
    byte[] contentBytes;
    InputStream contentStream;
    List<Header> headers = new ArrayList<Header>();
    String method;
    String url;
    int expectedCode = -1;
    StringBuilder postParams = new StringBuilder();
    private String authorization;
    private int requestTimeout = 0;

    public static HttpRequest formPost() {
        return new HttpRequest().method("POST").header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public String getMethod() {
        return this.method;
    }

    public byte[] getContentBytes() {
        if (this.postParams.length() > 0) {
            try {
                return this.postParams.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.contentBytes;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpRequest expectsCode(int value) {
        this.expectedCode = value;
        return this;
    }

    public int getExpectedCode() {
        return this.expectedCode;
    }

    public HttpRequest header(String key, String value) {
        this.headers.add(new Header(key, value));
        return this;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public HttpRequest responseFormat(ResponseFormat value) {
        this.responseFormat = value;
        return this;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int value) {
        this.requestTimeout = value;
    }

    public HttpRequest url(String value) {
        this.url = value;
        return this;
    }

    public HttpRequest method(String value) {
        this.method = value;
        return this;
    }

    public HttpRequest content(byte[] value) {
        if (this.postParams.length() > 0) {
            throw new IllegalStateException("Cannot add request content as byte[] after post parameters have been set with param() or preEncodedParam()");
        }
        this.contentBytes = value;
        return this;
    }

    public HttpRequest param(String key, String value) {
        if (this.contentBytes != null) {
            throw new IllegalStateException("Cannot add params to HttpRequest after content(byte[]) has been called with non-null value");
        }
        try {
            if (this.postParams.length() > 0) {
                this.postParams.append("&" + key + "=" + URLEncoder.encode(value, "UTF-8"));
            } else {
                this.postParams.append(key + "=" + URLEncoder.encode(value, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public HttpRequest preEncodedParam(String key, String value) {
        if (this.contentBytes != null) {
            throw new IllegalStateException("Cannot add params to HttpRequest after content(byte[]) has been called with non-null value");
        }
        if (this.postParams.length() > 0) {
            this.postParams.append("&" + key + "=" + value);
        } else {
            this.postParams.append(key + "=" + value);
        }
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.method + " " + this.url + "\n");
        for (Header h : this.headers) {
            b.append(h.key + ": " + h.value + "\n");
        }
        if (this.authorization != null) {
            b.append("Authorization: " + this.authorization);
        }
        if (this.getContentBytes() != null) {
            try {
                b.append("\n" + new String(this.getContentBytes(), "UTF-8") + "\n");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else if (this.contentStream != null) {
            b.append("\n[streamed content. Cannot print]\n");
        }
        return b.toString();
    }

    public void setAuthorization(String value) {
        this.authorization = value;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public static enum ResponseFormat {
        STREAM,
        BYTE,
        STRING;

    }

    public class Header {
        String key;
        String value;

        public Header() {
        }

        public Header(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

