/*
 * Decompiled with CFR 0.152.
 */
package com.ftpix.webwatcher;

import com.ftpix.webwatcher.interfaces.WebSite;
import com.ftpix.webwatcher.interfaces.WebSiteErrorListener;
import com.ftpix.webwatcher.interfaces.WebSiteListener;
import com.ftpix.webwatcher.model.DefaultWebSite;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class WebWatcher<T extends WebSite> {
    private boolean checkLoopRunning = true;
    private List<T> sites;
    private WebSiteListener<T> listener;
    private WebSiteErrorListener<T> errorListener;
    private boolean triggerEventIfNoPreviousHash = false;
    private boolean textOnly = false;
    private boolean bodyOnly;

    private WebWatcher(T ... sites) {
        this.sites = Stream.of(sites).collect(Collectors.toList());
    }

    public static WebWatcher<DefaultWebSite> watch(String ... urls) {
        WebSite[] sites = (DefaultWebSite[])Stream.of(urls).filter(Objects::nonNull).filter(url -> url.trim().length() > 0).map(DefaultWebSite::new).toArray(DefaultWebSite[]::new);
        return new WebWatcher(sites);
    }

    public static <U extends WebSite> WebWatcher<U> watch(U ... sites) {
        return new WebWatcher(sites);
    }

    public WebWatcher<T> triggerEventOnFirstCheck(boolean triggerEvent) {
        this.triggerEventIfNoPreviousHash = triggerEvent;
        return this;
    }

    public WebWatcher<T> onChange(WebSiteListener<T> listener) {
        this.listener = listener;
        return this;
    }

    public WebWatcher<T> onError(WebSiteErrorListener<T> errorListener) {
        this.errorListener = errorListener;
        return this;
    }

    public WebWatcher<T> textOnly(boolean textOnly) {
        this.textOnly = textOnly;
        return this;
    }

    public WebWatcher<T> bodyOnly(boolean bodyOnly) {
        this.bodyOnly = bodyOnly;
        return this;
    }

    public void check() {
        this.sites.forEach(this::checkSingleSite);
    }

    private void checkSingleSite(T site) {
        block10: {
            try {
                Document parse = Jsoup.parse((URL)new URL(site.getUrl()), (int)10000);
                String hash = "";
                ArrayList<String> content = new ArrayList();
                if (site.getCssSelector() != null && site.getCssSelector().trim().length() > 0) {
                    Elements select = parse.select(site.getCssSelector());
                    hash = this.hashElements(select.stream());
                    content = select.stream().map(e -> this.textOnly ? e.text() : e.toString()).collect(Collectors.toList());
                } else if (this.bodyOnly) {
                    Element body = parse.body();
                    String bodyContent = this.textOnly ? body.text() : body.toString();
                    hash = this.hash(bodyContent);
                    content = Collections.singletonList(bodyContent);
                } else {
                    String bodyContent = this.textOnly ? parse.text() : parse.toString();
                    hash = this.hash(bodyContent);
                    content = Collections.singletonList(bodyContent);
                }
                site.setLastCheck(LocalDateTime.now());
                if ((site.getLastContentHash() == null || site.getLastContentHash().trim().length() == 0) && this.triggerEventIfNoPreviousHash) {
                    site.setLastContentHash(hash);
                    this.listener.onContentChange(site, content, parse.toString());
                } else if (site.getLastContentHash() != null && !site.getLastContentHash().equalsIgnoreCase(hash)) {
                    site.setLastContentHash(hash);
                    this.listener.onContentChange(site, content, parse.toString());
                } else {
                    site.setLastContentHash(hash);
                }
            }
            catch (Exception e2) {
                if (this.errorListener == null) break block10;
                this.errorListener.onError(site, e2);
            }
        }
    }

    private String hashElements(Stream<Element> elements) {
        String content = elements.map(e -> this.textOnly ? e.text() : e.toString()).collect(Collectors.joining(""));
        return this.hash(content);
    }

    private String hash(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes());
            byte[] digest = md.digest();
            BigInteger no = new BigInteger(1, digest);
            String hashtext = no.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isCheckLoopRunning() {
        return this.checkLoopRunning;
    }

    public void setCheckLoopRunning(boolean checkLoopRunning) {
        this.checkLoopRunning = checkLoopRunning;
    }

    public void checkPeriodically(int intervalInSeconds) {
        this.checkLoopRunning = true;
        while (this.checkLoopRunning) {
            this.check();
            try {
                Thread.sleep(intervalInSeconds * 1000);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

