/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite;

import com.fuzzylite.Engine;
import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.imex.FldExporter;
import com.fuzzylite.rule.RuleBlock;
import com.fuzzylite.variable.InputVariable;
import com.fuzzylite.variable.OutputVariable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Benchmark {
    private String name;
    private Engine engine;
    private List<double[]> expected;
    private List<double[]> obtained;
    private List<Double> times;
    private double tolerance;

    public Benchmark() {
        this("");
    }

    public Benchmark(String name) {
        this(name, null);
    }

    public Benchmark(String name, Engine engine) {
        this(name, engine, FuzzyLite.getMachEps());
    }

    public Benchmark(String name, Engine engine, double tolerance) {
        this.name = name;
        this.engine = engine;
        this.expected = new ArrayList<double[]>();
        this.obtained = new ArrayList<double[]>();
        this.times = new ArrayList<Double>();
        this.tolerance = tolerance;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public List<double[]> getExpected() {
        return this.expected;
    }

    public void setExpected(List<double[]> expected) {
        this.expected = expected;
    }

    public List<double[]> getObtained() {
        return this.obtained;
    }

    public void setObtained(List<double[]> obtained) {
        this.obtained = obtained;
    }

    public List<Double> getTimes() {
        return this.times;
    }

    public void setTimes(List<Double> times) {
        this.times = times;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public void prepare(int values, FldExporter.ScopeOfValues scope) {
        if (this.engine == null) {
            throw new RuntimeException("[benchmark error] engine not set before preparing for values and scope");
        }
        int resolution = scope == FldExporter.ScopeOfValues.AllVariables ? -1 + (int)Math.max(1.0, Math.pow(values, 1.0 / (double)this.engine.numberOfInputVariables())) : values - 1;
        int[] sampleValues = new int[this.engine.numberOfInputVariables()];
        int[] minSampleValues = new int[this.engine.numberOfInputVariables()];
        int[] maxSampleValues = new int[this.engine.numberOfInputVariables()];
        for (int i = 0; i < this.engine.numberOfInputVariables(); ++i) {
            sampleValues[i] = 0;
            minSampleValues[i] = 0;
            maxSampleValues[i] = resolution;
        }
        this.expected = new ArrayList<double[]>();
        do {
            double[] expectedValues = new double[this.engine.numberOfInputVariables()];
            for (int i = 0; i < this.engine.numberOfInputVariables(); ++i) {
                InputVariable inputVariable = this.engine.getInputVariable(i);
                expectedValues[i] = inputVariable.getMinimum() + (double)sampleValues[i] * inputVariable.range() / (double)Math.max(1, resolution);
            }
            this.expected.add(expectedValues);
        } while (Op.increment(sampleValues, minSampleValues, maxSampleValues));
    }

    public void prepare(Reader reader) throws IOException {
        this.prepare(reader, -1L);
    }

    public void prepare(Reader reader, long numberOfLines) throws IOException {
        this.expected = new ArrayList<double[]>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            int lineNumber = 0;
            while ((long)lineNumber != numberOfLines && (line = bufferedReader.readLine()) != null) {
                double[] expectedValues;
                block9: {
                    ++lineNumber;
                    if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                    if (lineNumber == 1) {
                        try {
                            expectedValues = Op.toDoubles(line);
                            break block9;
                        }
                        catch (Exception ex) {
                            continue;
                        }
                    }
                    expectedValues = Op.toDoubles(line);
                }
                this.expected.add(expectedValues);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            bufferedReader.close();
        }
    }

    public double runOnce() {
        return this.run(1)[0];
    }

    public double[] run(int times) {
        if (this.engine == null) {
            throw new RuntimeException("[benchmark error] engine not set for benchmark");
        }
        double[] runtimes = new double[times];
        int offset = this.engine.getInputVariables().size();
        for (int t = 0; t < times; ++t) {
            this.obtained = new ArrayList<double[]>(this.expected.size());
            for (int i = 0; i < this.expected.size(); ++i) {
                this.obtained.add(new double[this.engine.numberOfInputVariables() + this.engine.numberOfOutputVariables()]);
            }
            this.engine.restart();
            long start = System.nanoTime();
            for (int evaluation = 0; evaluation < this.expected.size(); ++evaluation) {
                int i;
                double[] expectedValues = this.expected.get(evaluation);
                double[] obtainedValues = this.obtained.get(evaluation);
                if (expectedValues.length < this.engine.getInputVariables().size()) {
                    throw new RuntimeException(MessageFormat.format("[benchmark error] the number of input values given <{0}> at line <{1}> must be at least the same number of input variables <{2}> in the engine", expectedValues.length, evaluation + 1, this.engine.numberOfInputVariables()));
                }
                for (i = 0; i < this.engine.getInputVariables().size(); ++i) {
                    this.engine.getInputVariables().get(i).setValue(expectedValues[i]);
                    obtainedValues[i] = expectedValues[i];
                }
                this.engine.process();
                for (i = 0; i < this.engine.getOutputVariables().size(); ++i) {
                    obtainedValues[i + offset] = this.engine.getOutputVariables().get(i).getValue();
                }
            }
            long end = System.nanoTime();
            runtimes[t] = end - start;
        }
        for (double x : runtimes) {
            this.times.add(x);
        }
        return runtimes;
    }

    public void reset() {
        this.obtained.clear();
        this.times.clear();
    }

    public boolean canComputeErrors() {
        return this.engine != null && !this.expected.isEmpty() && !this.obtained.isEmpty() && this.expected.size() == this.obtained.size() && this.expected.get(0).length == this.obtained.get(0).length && this.expected.get(0).length == this.engine.variables().size();
    }

    public double meanSquaredError() {
        return this.meanSquaredError(null);
    }

    public double meanSquaredError(OutputVariable outputVariable) {
        if (!this.canComputeErrors()) {
            return Double.NaN;
        }
        double mse = 0.0;
        int errors = 0;
        int offset = this.engine.numberOfInputVariables();
        for (int i = 0; i < this.expected.size(); ++i) {
            double[] e = this.expected.get(i);
            double[] o = this.obtained.get(i);
            for (int y = 0; y < this.engine.numberOfOutputVariables(); ++y) {
                double difference;
                if (outputVariable != null && outputVariable != this.engine.getOutputVariable(y) || !Op.isFinite(difference = e[offset + y] - o[offset + y]) || Op.isEq(difference, 0.0, this.tolerance)) continue;
                mse += difference * difference;
                ++errors;
            }
        }
        if (errors > 0) {
            mse /= (double)errors;
        }
        return mse;
    }

    public int allErrors() {
        return this.allErrors(null);
    }

    public int allErrors(OutputVariable outputVariable) {
        return this.numberOfErrors(ErrorType.All, outputVariable);
    }

    public int nonFiniteErrors() {
        return this.nonFiniteErrors(null);
    }

    public int nonFiniteErrors(OutputVariable outputVariable) {
        return this.numberOfErrors(ErrorType.NonFinite, outputVariable);
    }

    public int accuracyErrors() {
        return this.accuracyErrors(null);
    }

    public int accuracyErrors(OutputVariable outputVariable) {
        return this.numberOfErrors(ErrorType.Accuracy, outputVariable);
    }

    public int numberOfErrors(ErrorType errorType) {
        return this.numberOfErrors(errorType, null);
    }

    public int numberOfErrors(ErrorType errorType, OutputVariable outputVariable) {
        if (!this.canComputeErrors()) {
            return -1;
        }
        int errors = 0;
        int offset = this.engine.numberOfInputVariables();
        for (int i = 0; i < this.expected.size(); ++i) {
            double[] e = this.expected.get(i);
            double[] o = this.obtained.get(i);
            for (int y = 0; y < this.engine.numberOfOutputVariables(); ++y) {
                if (outputVariable != null && outputVariable != this.engine.getOutputVariable(y) || Op.isEq(e[offset + y], o[offset + y], this.tolerance)) continue;
                double difference = e[offset + y] - o[offset + y];
                if (errorType == ErrorType.Accuracy && Op.isFinite(difference)) {
                    ++errors;
                    continue;
                }
                if (errorType == ErrorType.NonFinite && !Op.isFinite(difference)) {
                    ++errors;
                    continue;
                }
                if (errorType != ErrorType.All) continue;
                ++errors;
            }
        }
        return errors;
    }

    public double factorOf(TimeUnit unit) {
        if (unit == TimeUnit.NanoSeconds) {
            return 1.0;
        }
        if (unit == TimeUnit.MicroSeconds) {
            return 0.001;
        }
        if (unit == TimeUnit.MilliSeconds) {
            return 1.0E-6;
        }
        if (unit == TimeUnit.Seconds) {
            return 1.0E-9;
        }
        if (unit == TimeUnit.Minutes) {
            return 1.6666666666666667E-11;
        }
        if (unit == TimeUnit.Hours) {
            return 2.777777777777778E-13;
        }
        return Double.NaN;
    }

    public double convert(double time, TimeUnit from, TimeUnit to) {
        return time * this.factorOf(to) / this.factorOf(from);
    }

    public Set<String> header(int runs, boolean includeErrors) {
        Benchmark result = new Benchmark();
        Engine dummy = new Engine();
        dummy.addOutputVariable(new OutputVariable());
        result.setEngine(dummy);
        Object[] dummyTimes = new Double[runs];
        Arrays.fill(dummyTimes, (Object)Double.NaN);
        result.setTimes(Arrays.asList(dummyTimes));
        if (includeErrors) {
            double[] dummyArray = new double[1];
            ArrayList<double[]> dummyList = new ArrayList<double[]>();
            dummyList.add(dummyArray);
            result.setExpected(dummyList);
            result.setObtained(dummyList);
        }
        return result.results().keySet();
    }

    public Map<String, String> results() {
        return this.results(TimeUnit.NanoSeconds);
    }

    public Map<String, String> results(TimeUnit timeUnit) {
        return this.results(timeUnit, true);
    }

    public Map<String, String> results(TimeUnit timeUnit, boolean includeTimes) {
        return this.results(null, timeUnit, includeTimes);
    }

    public Map<String, String> results(OutputVariable outputVariable) {
        return this.results(outputVariable, TimeUnit.NanoSeconds);
    }

    public Map<String, String> results(OutputVariable outputVariable, TimeUnit timeUnit) {
        return this.results(outputVariable, timeUnit, true);
    }

    public Map<String, String> results(OutputVariable outputVariable, TimeUnit timeUnit, boolean includeTimes) {
        if (this.engine == null) {
            throw new RuntimeException("[benchmark error] engine not set for benchmark");
        }
        double[] runtimes = new double[this.times.size()];
        for (int i = 0; i < this.times.size(); ++i) {
            runtimes[i] = this.times.get(i);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("library", "jfuzzylite 6.0");
        result.put("name", this.name);
        result.put("inputs", String.valueOf(this.engine.numberOfInputVariables()));
        result.put("outputs", String.valueOf(this.engine.numberOfOutputVariables()));
        result.put("ruleBlocks", String.valueOf(this.engine.numberOfRuleBlocks()));
        int rules = 0;
        for (RuleBlock ruleBlock : this.engine.getRuleBlocks()) {
            rules += ruleBlock.numberOfRules();
        }
        result.put("rules", String.valueOf(rules));
        result.put("runs", String.valueOf(this.times.size()));
        result.put("evaluations", String.valueOf(this.expected.size()));
        if (this.canComputeErrors()) {
            LinkedList<String> names = new LinkedList<String>();
            double meanRange = 0.0;
            double rmse = Math.sqrt(this.meanSquaredError());
            double nrmse = 0.0;
            double weights = 0.0;
            for (OutputVariable y : this.engine.getOutputVariables()) {
                if (outputVariable != null && outputVariable != y) continue;
                names.add(y.getName());
                meanRange += y.range();
                nrmse += Math.sqrt(this.meanSquaredError(y)) * 1.0 / y.range();
                weights += 1.0 / y.range();
            }
            nrmse /= weights;
            result.put("outputVariable", Op.join(names, ","));
            result.put("range", Op.str(meanRange /= (double)names.size()));
            result.put("tolerance", String.format("%6.3e", this.getTolerance()));
            result.put("errors", String.valueOf(this.allErrors(outputVariable)));
            result.put("nfErrors", String.valueOf(this.nonFiniteErrors(outputVariable)));
            result.put("accErrors", String.valueOf(this.accuracyErrors(outputVariable)));
            result.put("rmse", String.format("%6.6e", rmse));
            result.put("nrmse", String.format("%6.6e", nrmse));
        }
        result.put("units", timeUnit.name().toLowerCase());
        result.put("sum(t)", String.valueOf(this.convert(Op.sum(runtimes), TimeUnit.NanoSeconds, timeUnit)));
        result.put("mean(t)", String.valueOf(this.convert(Op.mean(runtimes), TimeUnit.NanoSeconds, timeUnit)));
        result.put("sd(t)", String.valueOf(this.convert(Op.standardDeviation(runtimes), TimeUnit.NanoSeconds, timeUnit)));
        if (includeTimes) {
            for (int i = 0; i < runtimes.length; ++i) {
                result.put("t" + (i + 1), String.valueOf(this.convert(runtimes[i], TimeUnit.NanoSeconds, timeUnit)));
            }
        }
        return result;
    }

    public String format(Map<String, String> results) {
        return this.format(results, TableShape.Horizontal);
    }

    public String format(Map<String, String> results, TableShape shape) {
        return this.format(results, shape, TableContents.HeaderAndBody);
    }

    public String format(Map<String, String> results, TableShape shape, TableContents contents) {
        return this.format(results, shape, contents, "\t");
    }

    public String format(Map<String, String> results, TableShape shape, TableContents contents, String delimiter) {
        StringWriter writer = new StringWriter();
        if (shape == TableShape.Vertical) {
            Iterator<Map.Entry<String, String>> it = results.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> pair = it.next();
                if (contents == TableContents.Header || contents == TableContents.HeaderAndBody) {
                    writer.append(pair.getKey());
                }
                if (contents == TableContents.HeaderAndBody) {
                    writer.append(delimiter);
                }
                if (contents == TableContents.Body || contents == TableContents.HeaderAndBody) {
                    writer.append(pair.getValue());
                }
                if (!it.hasNext()) continue;
                writer.append("\n");
            }
        } else if (shape == TableShape.Horizontal) {
            StringWriter header = new StringWriter();
            StringWriter body = new StringWriter();
            Iterator<Map.Entry<String, String>> it = results.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> pair = it.next();
                if (contents == TableContents.Header || contents == TableContents.HeaderAndBody) {
                    header.append(pair.getKey());
                    if (it.hasNext()) {
                        header.append(delimiter);
                    }
                }
                if (contents != TableContents.Body && contents != TableContents.HeaderAndBody) continue;
                body.append(pair.getValue());
                if (!it.hasNext()) continue;
                body.append(delimiter);
            }
            if (contents == TableContents.Header || contents == TableContents.HeaderAndBody) {
                writer.append(header.toString());
            }
            if (contents == TableContents.HeaderAndBody) {
                writer.append("\n");
            }
            if (contents == TableContents.Body || contents == TableContents.HeaderAndBody) {
                writer.append(body.toString());
            }
        }
        return writer.toString();
    }

    public static enum ErrorType {
        NonFinite,
        Accuracy,
        All;

    }

    public static enum TableContents {
        Header,
        Body,
        HeaderAndBody;

    }

    public static enum TableShape {
        Horizontal,
        Vertical;

    }

    public static enum TimeUnit {
        NanoSeconds,
        MicroSeconds,
        MilliSeconds,
        Seconds,
        Minutes,
        Hours;

    }
}

