/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite;

import com.fuzzylite.Benchmark;
import com.fuzzylite.Engine;
import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.activation.General;
import com.fuzzylite.defuzzifier.Centroid;
import com.fuzzylite.defuzzifier.WeightedAverage;
import com.fuzzylite.imex.CppExporter;
import com.fuzzylite.imex.Exporter;
import com.fuzzylite.imex.FclExporter;
import com.fuzzylite.imex.FclImporter;
import com.fuzzylite.imex.FisExporter;
import com.fuzzylite.imex.FisImporter;
import com.fuzzylite.imex.FldExporter;
import com.fuzzylite.imex.FllExporter;
import com.fuzzylite.imex.FllImporter;
import com.fuzzylite.imex.Importer;
import com.fuzzylite.imex.JavaExporter;
import com.fuzzylite.imex.RScriptExporter;
import com.fuzzylite.norm.s.AlgebraicSum;
import com.fuzzylite.norm.s.Maximum;
import com.fuzzylite.norm.t.AlgebraicProduct;
import com.fuzzylite.norm.t.Minimum;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import com.fuzzylite.term.Constant;
import com.fuzzylite.term.Function;
import com.fuzzylite.term.Trapezoid;
import com.fuzzylite.term.Triangle;
import com.fuzzylite.variable.InputVariable;
import com.fuzzylite.variable.OutputVariable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;

public class Console {
    public static final String KW_INPUT_FILE = "-i";
    public static final String KW_INPUT_FORMAT = "-if";
    public static final String KW_OUTPUT_FILE = "-o";
    public static final String KW_OUTPUT_FORMAT = "-of";
    public static final String KW_EXAMPLE = "-example";
    public static final String KW_DECIMALS = "-decimals";
    public static final String KW_DATA_INPUT_FILE = "-d";
    public static final String KW_DATA_VALUES = "-values";
    public static final String KW_DATA_VALUES_SCOPE = "-scope";
    public static final String KW_DATA_EXPORT_HEADER = "-dheader";
    public static final String KW_DATA_EXPORT_INPUTS = "-dinputs";

    public String usage() {
        ArrayList<Option> options = new ArrayList<Option>();
        options.add(new Option(KW_INPUT_FILE, "inputfile", "file to import your engine from"));
        options.add(new Option(KW_INPUT_FORMAT, "format", "format of the file to import (fll | fis | fcl)"));
        options.add(new Option(KW_OUTPUT_FILE, "outputfile", "file to export your engine to"));
        options.add(new Option(KW_OUTPUT_FORMAT, "format", "format of the file to export (fll | fld | cpp | java | fis | fcl)"));
        options.add(new Option(KW_EXAMPLE, "example", "if not inputfile, built-in example to use as engine: (m)amdani or (t)akagi-sugeno"));
        options.add(new Option(KW_DECIMALS, "number", "number of decimals to utilize"));
        options.add(new Option(KW_DATA_INPUT_FILE, "datafile", "if exporting to fld, file of input values to evaluate your engine on"));
        options.add(new Option(KW_DATA_VALUES, "number", "if exporting to fld without datafile, number of results to export within scope (default: EachVariable)"));
        options.add(new Option(KW_DATA_VALUES_SCOPE, "scope", "if exporting to fld without datafile, scope of -values: [EachVariable|AllVariables]"));
        options.add(new Option(KW_DATA_EXPORT_HEADER, "boolean", "if true and exporting to fld, include headers"));
        options.add(new Option(KW_DATA_EXPORT_INPUTS, "boolean", "if true and exporting to fld, include input values"));
        StringBuilder result = new StringBuilder();
        result.append("=========================================\n");
        result.append("jfuzzylite: a fuzzy logic control library\n");
        result.append(String.format("version: %s\n", "6.0"));
        result.append(String.format("author: %s\n", "Juan Rada-Vilela, Ph.D."));
        result.append(String.format("license: %s\n", "FuzzyLite License"));
        result.append("=========================================\n");
        result.append("usage: java -jar jfuzzylite.jar inputfile outputfile\n");
        result.append("   or: java -jar jfuzzylite.jar benchmark engine.fll input.fld runs [output.tsv]\n");
        result.append("   or: java -jar jfuzzylite.jar benchmark fllFiles.txt fldFiles.txt runs [output.tsv]\n");
        result.append("   or: java -jar jfuzzylite.jar ");
        for (Option option : options) {
            result.append(String.format("[%s %s] ", option.key, option.value));
        }
        result.append("\n\nwhere:\n");
        for (Option option : options) {
            result.append(option.key);
            int keyPad = 12 - option.key.length();
            if (keyPad > 0) {
                result.append(String.format("%" + keyPad + "s", " "));
            }
            result.append(option.value);
            int valuePad = 13 - option.value.length();
            if (valuePad > 0) {
                result.append(String.format("%" + valuePad + "s", " "));
            }
            result.append(option.description).append("\n");
        }
        result.append("\n");
        result.append("Visit http://www.fuzzylite.com/ for more information.\n\n");
        result.append("Copyright (C) 2010-2017 FuzzyLite Limited.\n");
        result.append("All rights reserved.");
        return result.toString();
    }

    protected Map<String, String> parse(String[] args) {
        if (args.length % 2 != 0) {
            throw new RuntimeException("[option error] incomplete number of parameters [key value]");
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < args.length - 1; i += 2) {
            String key = args[i];
            String value = args[i + 1];
            options.put(key, value);
        }
        if (options.size() == 1) {
            Map.Entry keyValue = options.entrySet().iterator().next();
            if (((String)keyValue.getKey()).charAt(0) != '-') {
                options.put(KW_INPUT_FILE, (String)keyValue.getKey());
                options.put(KW_OUTPUT_FILE, (String)keyValue.getValue());
            }
        } else {
            HashSet<String> validOptions = new HashSet<String>();
            validOptions.add(KW_INPUT_FILE);
            validOptions.add(KW_INPUT_FORMAT);
            validOptions.add(KW_OUTPUT_FILE);
            validOptions.add(KW_OUTPUT_FORMAT);
            validOptions.add(KW_EXAMPLE);
            validOptions.add(KW_DATA_INPUT_FILE);
            validOptions.add(KW_DATA_VALUES);
            validOptions.add(KW_DATA_VALUES_SCOPE);
            validOptions.add(KW_DECIMALS);
            for (String option : options.keySet()) {
                if (validOptions.contains(option)) continue;
                throw new RuntimeException(String.format("[option error] option <%s> not recognized", option));
            }
        }
        return options;
    }

    protected void process(Map<String, String> options) throws Exception {
        Writer writer;
        String outputFormat;
        boolean isExample;
        String decimals = options.get(KW_DECIMALS);
        if (decimals != null) {
            FuzzyLite.setDecimals(Integer.parseInt(decimals));
        }
        String inputFormat = "";
        StringBuilder textEngine = new StringBuilder();
        String example = options.get(KW_EXAMPLE);
        boolean bl = isExample = example != null && !example.isEmpty();
        if (isExample) {
            Engine engine;
            if ("m".equals(example) || "mamdani".equals(example)) {
                engine = Console.mamdani();
            } else if ("t".equals(example) || "ts".equals(example) || "takagi-sugeno".equals(example)) {
                engine = Console.takagiSugeno();
            } else {
                throw new RuntimeException(String.format("[option error] example <%s> not available", example));
            }
            inputFormat = "fll";
            textEngine.append(new FllExporter().toString(engine));
        } else {
            String inputFilename = options.get(KW_INPUT_FILE);
            if (inputFilename == null) {
                throw new RuntimeException("[option error] no input file specified");
            }
            File inputFile = new File(inputFilename);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), FuzzyLite.UTF_8));
            try {
                String line = reader.readLine();
                while (line != null) {
                    textEngine.append(line).append("\n");
                    line = reader.readLine();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                reader.close();
            }
            inputFormat = options.get(KW_INPUT_FORMAT);
            if (inputFormat == null || inputFormat.isEmpty()) {
                int extensionIndex = inputFilename.lastIndexOf(46);
                if (extensionIndex >= 0) {
                    inputFormat = inputFilename.substring(extensionIndex + 1);
                } else {
                    throw new RuntimeException("[format error] unspecified format of input file");
                }
            }
        }
        String outputFilename = options.get(KW_OUTPUT_FILE);
        if (outputFilename == null) {
            outputFilename = "";
        }
        if ((outputFormat = options.get(KW_OUTPUT_FORMAT)) == null || outputFormat.isEmpty()) {
            int extensionIndex = outputFilename.lastIndexOf(46);
            if (extensionIndex >= 0) {
                outputFormat = outputFilename.substring(extensionIndex + 1);
            } else {
                throw new RuntimeException("[format error] unspecified format of output file");
            }
        }
        if (outputFilename.isEmpty()) {
            writer = System.console().writer();
        } else {
            File outputFile = new File(outputFilename);
            if (!outputFile.createNewFile()) {
                FuzzyLite.logger().log(Level.FINE, "Replacing file {0}", outputFilename);
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), FuzzyLite.UTF_8));
        }
        try {
            this.process(textEngine.toString(), writer, inputFormat, outputFormat, options);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            ((Writer)writer).close();
        }
    }

    protected void process(String input, Writer writer, String inputFormat, String outputFormat, Map<String, String> options) throws Exception {
        Importer importer = null;
        if ("fll".equals(inputFormat)) {
            importer = new FllImporter();
        } else if ("fcl".equals(inputFormat)) {
            importer = new FclImporter();
        } else if ("fis".equals(inputFormat)) {
            importer = new FisImporter();
        } else {
            throw new RuntimeException(String.format("[import error] format <%s> not supported", inputFormat));
        }
        Engine engine = ((Importer)importer).fromString(input);
        if ("fld".equals(outputFormat)) {
            FldExporter fldExporter = new FldExporter();
            fldExporter.setSeparator(" ");
            boolean exportHeaders = true;
            boolean exportInputValues = true;
            if (options.containsKey(KW_DATA_EXPORT_HEADER)) {
                exportHeaders = "true".equals(options.get(KW_DATA_EXPORT_HEADER));
            }
            if (options.containsKey(KW_DATA_EXPORT_INPUTS)) {
                exportInputValues = "true".equals(options.get(KW_DATA_EXPORT_INPUTS));
            }
            fldExporter.setExportHeader(exportHeaders);
            fldExporter.setExportInputValues(exportInputValues);
            String filename = options.get(KW_DATA_INPUT_FILE);
            if (filename != null) {
                File dataFile = new File(filename);
                if (!dataFile.exists()) {
                    throw new RuntimeException("[export error] file <" + filename + "> " + "does not exist");
                }
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(dataFile), FuzzyLite.UTF_8);
                try {
                    fldExporter.write(engine, writer, reader);
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    reader.close();
                }
            } else if (options.containsKey(KW_DATA_VALUES)) {
                int values = Integer.parseInt(options.get(KW_DATA_VALUES));
                FldExporter.ScopeOfValues scope = FldExporter.ScopeOfValues.EachVariable;
                if (options.containsKey(KW_DATA_VALUES_SCOPE)) {
                    scope = FldExporter.ScopeOfValues.valueOf(options.get(KW_DATA_VALUES_SCOPE));
                }
                fldExporter.write(engine, writer, values, scope);
            } else {
                boolean printToConsole;
                StringBuilder buffer = new StringBuilder();
                buffer.append("#FuzzyLite Interactive Console (press H for help)\n");
                buffer.append(fldExporter.header(engine)).append("\n");
                if (engine.getInputVariables().isEmpty()) {
                    buffer.append("[error] the engine does not have input variables.\n");
                }
                if (engine.getOutputVariables().isEmpty()) {
                    buffer.append("[error] the engine does not have output variables.\n");
                }
                writer.append(buffer.toString()).flush();
                boolean bl = printToConsole = writer != System.console().writer();
                if (printToConsole) {
                    System.console().writer().append(buffer.toString()).flush();
                }
                if (engine.getInputVariables().isEmpty() || engine.getOutputVariables().isEmpty()) {
                    return;
                }
                this.interactive(writer, engine);
            }
        } else {
            Exporter exporter = null;
            if ("fll".equals(outputFormat)) {
                exporter = new FllExporter();
            } else if ("fcl".equals(outputFormat)) {
                exporter = new FclExporter();
            } else if ("fis".equals(outputFormat)) {
                exporter = new FisExporter();
            } else if ("cpp".equals(outputFormat)) {
                exporter = new CppExporter();
            } else if ("java".equals(outputFormat)) {
                exporter = new JavaExporter();
            } else {
                throw new RuntimeException(String.format("[export error] format <%s> not supported", outputFormat));
            }
            writer.write(((Exporter)exporter).toString(engine));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void interactive(Writer writer, Engine engine) throws IOException {
        reader = new BufferedReader(new InputStreamReader(System.in, FuzzyLite.UTF_8));
        printToConsole = writer != System.console().writer();
        buffer = new StringBuilder();
        space = "\t";
        block0: while (true) {
            buffer.append("\n> ");
            writer.append(buffer.toString()).flush();
            if (printToConsole) {
                System.console().writer().append(buffer.toString()).flush();
            }
            buffer.setLength(0);
            line = reader.readLine();
            if (line == null) {
                line = "Q";
            }
            if ((tokens = line.split("\\s+")).length == 1) {
                token = tokens[0];
                if ("R".equalsIgnoreCase(token)) {
                    buffer.append("#[Restart]");
                    engine.restart();
                    continue;
                }
                if ("H".equalsIgnoreCase(token)) {
                    buffer.append(this.interactiveHelp());
                    continue;
                }
                if ("Q".equalsIgnoreCase(token)) {
                    buffer.append("#[Quit]\n");
                    writer.append(buffer.toString()).flush();
                    if (!printToConsole) break;
                    System.console().writer().append(buffer.toString()).flush();
                    break;
                }
            }
            numberOfTokens = Math.max(tokens.length, engine.numberOfInputVariables());
            numberOfTokens += numberOfTokens % engine.numberOfInputVariables();
            inputValues = new double[numberOfTokens];
            for (i = 0; i < tokens.length; ++i) {
                defaultValue = engine.getInputVariable(i % engine.numberOfInputVariables()).getValue();
                inputValues[i] = Op.toDouble(tokens[i], defaultValue);
            }
            for (i = tokens.length; i < numberOfTokens; ++i) {
                inputValues[i] = defaultValue = engine.getInputVariable(i % engine.numberOfInputVariables()).getValue();
            }
            i = 0;
            while (true) {
                if (i < inputValues.length) ** break;
                continue block0;
                index = i % engine.numberOfInputVariables();
                engine.getInputVariable(index).setValue(inputValues[i]);
                buffer.append("\t").append(Op.str(inputValues[i]));
                if ((i + 1) % engine.numberOfInputVariables() == 0) {
                    engine.process();
                    buffer.append("\t").append("=").append("\t");
                    it = engine.getOutputVariables().iterator();
                    while (it.hasNext()) {
                        buffer.append(Op.str(it.next().getValue()));
                        if (!it.hasNext()) continue;
                        buffer.append("\t");
                    }
                    if (i + 1 < inputValues.length) {
                        buffer.append("\n");
                    }
                }
                ++i;
            }
            break;
        }
        reader.close();
    }

    public String interactiveHelp() {
        String result = "#Special Keys:\n#=============\n#   [Enter]\tProcess engine\n#      R\tRestart engine\n#      Q\tQuit interactive console\n#      H\tShow this help\n#=============\n";
        return result;
    }

    public static Engine mamdani() {
        Engine engine = new Engine();
        engine.setName("simple-dimmer");
        engine.setDescription("");
        InputVariable ambient = new InputVariable();
        ambient.setName("ambient");
        ambient.setDescription("");
        ambient.setEnabled(true);
        ambient.setRange(0.0, 1.0);
        ambient.setLockValueInRange(false);
        ambient.addTerm(new Triangle("DARK", 0.0, 0.25, 0.5));
        ambient.addTerm(new Triangle("MEDIUM", 0.25, 0.5, 0.75));
        ambient.addTerm(new Triangle("BRIGHT", 0.5, 0.75, 1.0));
        engine.addInputVariable(ambient);
        OutputVariable power = new OutputVariable();
        power.setName("power");
        power.setDescription("");
        power.setEnabled(true);
        power.setRange(0.0, 2.0);
        power.setLockValueInRange(false);
        power.setAggregation(new Maximum());
        power.setDefuzzifier(new Centroid(200));
        power.setDefaultValue(Double.NaN);
        power.setLockPreviousValue(false);
        power.addTerm(new Triangle("LOW", 0.0, 0.5, 1.0));
        power.addTerm(new Triangle("MEDIUM", 0.5, 1.0, 1.5));
        power.addTerm(new Triangle("HIGH", 1.0, 1.5, 2.0));
        engine.addOutputVariable(power);
        RuleBlock ruleBlock = new RuleBlock();
        ruleBlock.setName("");
        ruleBlock.setDescription("");
        ruleBlock.setEnabled(true);
        ruleBlock.setConjunction(null);
        ruleBlock.setDisjunction(null);
        ruleBlock.setImplication(new Minimum());
        ruleBlock.setActivation(new General());
        ruleBlock.addRule(Rule.parse("if ambient is DARK then power is HIGH", engine));
        ruleBlock.addRule(Rule.parse("if ambient is MEDIUM then power is MEDIUM", engine));
        ruleBlock.addRule(Rule.parse("if ambient is BRIGHT then power is LOW", engine));
        engine.addRuleBlock(ruleBlock);
        return engine;
    }

    public static Engine takagiSugeno() {
        Engine engine = new Engine();
        engine.setName("approximation");
        engine.setDescription("approximation of sin(x)/x");
        InputVariable inputX = new InputVariable();
        inputX.setName("inputX");
        inputX.setDescription("value of x");
        inputX.setEnabled(true);
        inputX.setRange(0.0, 10.0);
        inputX.setLockValueInRange(false);
        inputX.addTerm(new Triangle("NEAR_1", 0.0, 1.0, 2.0));
        inputX.addTerm(new Triangle("NEAR_2", 1.0, 2.0, 3.0));
        inputX.addTerm(new Triangle("NEAR_3", 2.0, 3.0, 4.0));
        inputX.addTerm(new Triangle("NEAR_4", 3.0, 4.0, 5.0));
        inputX.addTerm(new Triangle("NEAR_5", 4.0, 5.0, 6.0));
        inputX.addTerm(new Triangle("NEAR_6", 5.0, 6.0, 7.0));
        inputX.addTerm(new Triangle("NEAR_7", 6.0, 7.0, 8.0));
        inputX.addTerm(new Triangle("NEAR_8", 7.0, 8.0, 9.0));
        inputX.addTerm(new Triangle("NEAR_9", 8.0, 9.0, 10.0));
        engine.addInputVariable(inputX);
        OutputVariable outputFx = new OutputVariable();
        outputFx.setName("outputFx");
        outputFx.setDescription("value of the approximation of x");
        outputFx.setEnabled(true);
        outputFx.setRange(-1.0, 1.0);
        outputFx.setLockValueInRange(false);
        outputFx.setAggregation(null);
        outputFx.setDefuzzifier(new WeightedAverage("Automatic"));
        outputFx.setDefaultValue(Double.NaN);
        outputFx.setLockPreviousValue(true);
        outputFx.addTerm(new Constant("f1", 0.84));
        outputFx.addTerm(new Constant("f2", 0.45));
        outputFx.addTerm(new Constant("f3", 0.04));
        outputFx.addTerm(new Constant("f4", -0.18));
        outputFx.addTerm(new Constant("f5", -0.19));
        outputFx.addTerm(new Constant("f6", -0.04));
        outputFx.addTerm(new Constant("f7", 0.09));
        outputFx.addTerm(new Constant("f8", 0.12));
        outputFx.addTerm(new Constant("f9", 0.04));
        engine.addOutputVariable(outputFx);
        OutputVariable trueValue = new OutputVariable();
        trueValue.setName("trueValue");
        trueValue.setDescription("value of f(x)=sin(x)/x");
        trueValue.setEnabled(true);
        trueValue.setRange(-1.06, 1.0);
        trueValue.setLockValueInRange(false);
        trueValue.setAggregation(null);
        trueValue.setDefuzzifier(new WeightedAverage("Automatic"));
        trueValue.setDefaultValue(Double.NaN);
        trueValue.setLockPreviousValue(true);
        trueValue.addTerm(Function.create("fx", "sin(inputX)/inputX", engine));
        engine.addOutputVariable(trueValue);
        OutputVariable difference = new OutputVariable();
        difference.setName("difference");
        difference.setDescription("error e=f(x) - f'(x)");
        difference.setEnabled(true);
        difference.setRange(-1.0, 1.0);
        difference.setLockValueInRange(false);
        difference.setAggregation(null);
        difference.setDefuzzifier(new WeightedAverage("Automatic"));
        difference.setDefaultValue(Double.NaN);
        difference.setLockPreviousValue(false);
        difference.addTerm(Function.create("error", "outputFx-trueValue", engine));
        engine.addOutputVariable(difference);
        RuleBlock ruleBlock = new RuleBlock();
        ruleBlock.setName("");
        ruleBlock.setDescription("");
        ruleBlock.setEnabled(true);
        ruleBlock.setConjunction(null);
        ruleBlock.setDisjunction(null);
        ruleBlock.setImplication(new AlgebraicProduct());
        ruleBlock.setActivation(new General());
        ruleBlock.addRule(Rule.parse("if inputX is NEAR_1 then outputFx is f1", engine));
        ruleBlock.addRule(Rule.parse("if inputX is NEAR_2 then outputFx is f2", engine));
        ruleBlock.addRule(Rule.parse("if inputX is NEAR_3 then outputFx is f3", engine));
        ruleBlock.addRule(Rule.parse("if inputX is NEAR_4 then outputFx is f4", engine));
        ruleBlock.addRule(Rule.parse("if inputX is NEAR_5 then outputFx is f5", engine));
        ruleBlock.addRule(Rule.parse("if inputX is NEAR_6 then outputFx is f6", engine));
        ruleBlock.addRule(Rule.parse("if inputX is NEAR_7 then outputFx is f7", engine));
        ruleBlock.addRule(Rule.parse("if inputX is NEAR_8 then outputFx is f8", engine));
        ruleBlock.addRule(Rule.parse("if inputX is NEAR_9 then outputFx is f9", engine));
        ruleBlock.addRule(Rule.parse("if inputX is any then trueValue is fx and difference is error", engine));
        engine.addRuleBlock(ruleBlock);
        return engine;
    }

    public static Engine hybrid() {
        Engine engine = new Engine();
        engine.setName("tipper");
        engine.setDescription("(service and food) -> (tip)");
        InputVariable service = new InputVariable();
        service.setName("service");
        service.setDescription("quality of service");
        service.setEnabled(true);
        service.setRange(0.0, 10.0);
        service.setLockValueInRange(true);
        service.addTerm(new Trapezoid("poor", 0.0, 0.0, 2.5, 5.0));
        service.addTerm(new Triangle("good", 2.5, 5.0, 7.5));
        service.addTerm(new Trapezoid("excellent", 5.0, 7.5, 10.0, 10.0));
        engine.addInputVariable(service);
        InputVariable food = new InputVariable();
        food.setName("food");
        food.setDescription("quality of food");
        food.setEnabled(true);
        food.setRange(0.0, 10.0);
        food.setLockValueInRange(true);
        food.addTerm(new Trapezoid("rancid", 0.0, 0.0, 2.5, 7.5));
        food.addTerm(new Trapezoid("delicious", 2.5, 7.5, 10.0, 10.0));
        engine.addInputVariable(food);
        OutputVariable mTip = new OutputVariable();
        mTip.setName("mTip");
        mTip.setDescription("tip based on Mamdani inference");
        mTip.setEnabled(true);
        mTip.setRange(0.0, 30.0);
        mTip.setLockValueInRange(false);
        mTip.setAggregation(new Maximum());
        mTip.setDefuzzifier(new Centroid(100));
        mTip.setDefaultValue(Double.NaN);
        mTip.setLockPreviousValue(false);
        mTip.addTerm(new Triangle("cheap", 0.0, 5.0, 10.0));
        mTip.addTerm(new Triangle("average", 10.0, 15.0, 20.0));
        mTip.addTerm(new Triangle("generous", 20.0, 25.0, 30.0));
        engine.addOutputVariable(mTip);
        OutputVariable tsTip = new OutputVariable();
        tsTip.setName("tsTip");
        tsTip.setDescription("tip based on Takagi-Sugeno inference");
        tsTip.setEnabled(true);
        tsTip.setRange(0.0, 30.0);
        tsTip.setLockValueInRange(false);
        tsTip.setAggregation(null);
        tsTip.setDefuzzifier(new WeightedAverage("TakagiSugeno"));
        tsTip.setDefaultValue(Double.NaN);
        tsTip.setLockPreviousValue(false);
        tsTip.addTerm(new Constant("cheap", 5.0));
        tsTip.addTerm(new Constant("average", 15.0));
        tsTip.addTerm(new Constant("generous", 25.0));
        engine.addOutputVariable(tsTip);
        RuleBlock mamdani = new RuleBlock();
        mamdani.setName("mamdani");
        mamdani.setDescription("Mamdani inference");
        mamdani.setEnabled(true);
        mamdani.setConjunction(new AlgebraicProduct());
        mamdani.setDisjunction(new AlgebraicSum());
        mamdani.setImplication(new Minimum());
        mamdani.setActivation(new General());
        mamdani.addRule(Rule.parse("if service is poor or food is rancid then mTip is cheap", engine));
        mamdani.addRule(Rule.parse("if service is good then mTip is average", engine));
        mamdani.addRule(Rule.parse("if service is excellent or food is delicious then mTip is generous with 0.5", engine));
        mamdani.addRule(Rule.parse("if service is excellent and food is delicious then mTip is generous with 1.0", engine));
        engine.addRuleBlock(mamdani);
        RuleBlock takagiSugeno = new RuleBlock();
        takagiSugeno.setName("takagiSugeno");
        takagiSugeno.setDescription("Takagi-Sugeno inference");
        takagiSugeno.setEnabled(true);
        takagiSugeno.setConjunction(new AlgebraicProduct());
        takagiSugeno.setDisjunction(new AlgebraicSum());
        takagiSugeno.setImplication(null);
        takagiSugeno.setActivation(new General());
        takagiSugeno.addRule(Rule.parse("if service is poor or food is rancid then tsTip is cheap", engine));
        takagiSugeno.addRule(Rule.parse("if service is good then tsTip is average", engine));
        takagiSugeno.addRule(Rule.parse("if service is excellent or food is delicious then tsTip is generous with 0.5", engine));
        takagiSugeno.addRule(Rule.parse("if service is excellent and food is delicious then tsTip is generous with 1.0", engine));
        engine.addRuleBlock(takagiSugeno);
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAllExamples(String from, String to, String sourceBase, String targetBase) throws Exception {
        Exporter exporter;
        Importer importer;
        ArrayList<String> examples = new ArrayList<String>();
        examples.add("mamdani/AllTerms");
        examples.add("mamdani/SimpleDimmer");
        examples.add("mamdani/Laundry");
        examples.add("mamdani/ObstacleAvoidance");
        examples.add("mamdani/SimpleDimmerChained");
        examples.add("mamdani/SimpleDimmerInverse");
        examples.add("mamdani/matlab/mam21");
        examples.add("mamdani/matlab/mam22");
        examples.add("mamdani/matlab/shower");
        examples.add("mamdani/matlab/tank");
        examples.add("mamdani/matlab/tank2");
        examples.add("mamdani/matlab/tipper");
        examples.add("mamdani/matlab/tipper1");
        examples.add("mamdani/octave/investment_portfolio");
        examples.add("mamdani/octave/mamdani_tip_calculator");
        examples.add("takagi-sugeno/approximation");
        examples.add("takagi-sugeno/ObstacleAvoidance");
        examples.add("takagi-sugeno/SimpleDimmer");
        examples.add("takagi-sugeno/matlab/fpeaks");
        examples.add("takagi-sugeno/matlab/invkine1");
        examples.add("takagi-sugeno/matlab/invkine2");
        examples.add("takagi-sugeno/matlab/juggler");
        examples.add("takagi-sugeno/matlab/membrn1");
        examples.add("takagi-sugeno/matlab/membrn2");
        examples.add("takagi-sugeno/matlab/slbb");
        examples.add("takagi-sugeno/matlab/slcp");
        examples.add("takagi-sugeno/matlab/slcp1");
        examples.add("takagi-sugeno/matlab/slcpp1");
        examples.add("takagi-sugeno/matlab/sltbu_fl");
        examples.add("takagi-sugeno/matlab/sugeno1");
        examples.add("takagi-sugeno/matlab/tanksg");
        examples.add("takagi-sugeno/matlab/tippersg");
        examples.add("takagi-sugeno/octave/cubic_approximator");
        examples.add("takagi-sugeno/octave/heart_disease_risk");
        examples.add("takagi-sugeno/octave/linear_tip_calculator");
        examples.add("takagi-sugeno/octave/sugeno_tip_calculator");
        examples.add("tsukamoto/tsukamoto");
        examples.add("hybrid/tipper");
        examples.add("hybrid/ObstacleAvoidance");
        if ("fll".equals(from)) {
            importer = new FllImporter();
        } else if ("fis".equals(from)) {
            importer = new FisImporter();
        } else if ("fcl".equals(from)) {
            importer = new FclImporter();
        } else {
            throw new RuntimeException("[examples error] unrecognized format <" + from + "> to import");
        }
        if ("fll".equals(to)) {
            exporter = new FllExporter();
        } else if ("fld".equals(to)) {
            exporter = new FldExporter(" ");
        } else if ("fcl".equals(to)) {
            exporter = new FclExporter();
        } else if ("fis".equals(to)) {
            exporter = new FisExporter();
        } else if ("cpp".equals(to)) {
            exporter = new CppExporter();
        } else if ("java".equals(to)) {
            exporter = new JavaExporter();
        } else if ("R".equals(to)) {
            exporter = new RScriptExporter();
        } else {
            throw new RuntimeException("[examples error] unrecognized format <" + from + "> to export");
        }
        ArrayList<Op.Pair<Exporter, Importer>> tests = new ArrayList<Op.Pair<Exporter, Importer>>();
        tests.add(new Op.Pair<FllExporter, FllImporter>(new FllExporter(), new FllImporter()));
        tests.add(new Op.Pair<FclExporter, FclImporter>(new FclExporter(), new FclImporter()));
        tests.add(new Op.Pair<FisExporter, FisImporter>(new FisExporter(), new FisImporter()));
        FuzzyLite.logger().log(Level.INFO, "Exporting from {0} to {1}", new String[]{from, to});
        LinkedList<String> errors = new LinkedList<String>();
        for (int i = 0; i < examples.size(); ++i) {
            Engine engine;
            FuzzyLite.logger().log(Level.INFO, "Processing {0}/{1}: {2}", new Object[]{i + 1, examples.size(), examples.get(i)});
            File inputFile = new File(sourceBase, (String)examples.get(i) + "." + from);
            BufferedReader source = null;
            try {
                String line;
                source = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), FuzzyLite.UTF_8));
                StringBuilder text = new StringBuilder();
                while ((line = source.readLine()) != null) {
                    text.append(line).append("\n");
                }
                engine = importer.fromString(text.toString());
            }
            catch (Exception ex) {
                errors.add(ex.toString() + ": " + inputFile);
                FuzzyLite.logger().log(Level.SEVERE, "{0}: {1}", new String[]{ex.toString(), inputFile.toString()});
                continue;
            }
            finally {
                if (source != null) {
                    source.close();
                }
            }
            File outputFile = new File(targetBase, (String)examples.get(i) + "." + to);
            try {
                if (!outputFile.createNewFile()) {
                    FuzzyLite.logger().log(Level.FINE, "Replacing file {0}", outputFile.toString());
                }
            }
            catch (Exception ex) {
                errors.add(ex.toString() + ": " + outputFile.toString());
                FuzzyLite.logger().log(Level.SEVERE, "{0}: {1}", new String[]{ex.toString(), outputFile.toString()});
                return;
            }
            BufferedWriter target = null;
            try {
                target = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), FuzzyLite.UTF_8));
                for (Op.Pair pair : tests) {
                    String example = (String)examples.get(i);
                    if (("mamdani/Laundry".equals(example) || "mamdani/SimpleDimmerInverse".equals(example) || "mamdani/SimpleDimmerChained".equals(example) || "hybrid/tipper".equals(example) || "hybrid/ObstacleAvoidance".equals(example)) && pair.getSecond() instanceof FisImporter) continue;
                    String exported = ((Exporter)pair.getFirst()).toString(engine);
                    Engine engineFromExport = ((Importer)pair.getSecond()).fromString(exported);
                    String imported = ((Exporter)pair.getFirst()).toString(engineFromExport);
                    if (exported.equals(imported)) continue;
                    errors.add(String.format("[imex error] different results <%s,%s> at %s.%s:\n<Engine A>\n%s\n\n=================\n<Engine B>\n%s\n\n", ((Exporter)pair.getFirst()).getClass().getSimpleName(), ((Exporter)pair.getFirst()).getClass().getSimpleName(), examples.get(i), from, exported, imported));
                }
                if ("cpp".equals(to)) {
                    target.write("#include <fl/Headers.h>\n\nint main(int argc, char** argv){\n" + exporter.toString(engine) + "\n}\n");
                    continue;
                }
                if ("java".equals(to)) {
                    String className = ((String)examples.get(i)).substring(((String)examples.get(i)).lastIndexOf(47) + 1);
                    target.write("import com.fuzzylite.*;\nimport com.fuzzylite.activation.*\nimport com.fuzzylite.defuzzifier.*;\nimport com.fuzzylite.factory.*;\nimport com.fuzzylite.hedge.*;\nimport com.fuzzylite.imex.*;\nimport com.fuzzylite.norm.*;\nimport com.fuzzylite.norm.s.*;\nimport com.fuzzylite.norm.t.*;\nimport com.fuzzylite.rule.*;\nimport com.fuzzylite.term.*;\nimport com.fuzzylite.variable.*;\n\npublic class " + Op.validName(className) + "{\n" + "public static void main(String[] args){\n" + exporter.toString(engine) + "\n}\n}\n");
                    continue;
                }
                if ("R".equals(to)) {
                    RScriptExporter rScript = (RScriptExporter)exporter;
                    InputVariable inputVariable = engine.getInputVariable(0);
                    InputVariable b = engine.getInputVariable(1 % engine.numberOfInputVariables());
                    String pathToDF = ((String)examples.get(i)).substring(((String)examples.get(i)).lastIndexOf(47) + 1) + ".fld";
                    rScript.writeScriptImportingDataFrame(engine, target, inputVariable, b, pathToDF, engine.getOutputVariables());
                    continue;
                }
                target.write(exporter.toString(engine));
                continue;
            }
            catch (Exception ex) {
                errors.add(ex.toString() + ": " + outputFile.toString());
                FuzzyLite.logger().log(Level.SEVERE, "{0}: {1}", new String[]{ex.toString(), outputFile.toString()});
                continue;
            }
            finally {
                if (target != null) {
                    target.close();
                }
            }
        }
        if (!errors.isEmpty()) {
            FuzzyLite.logger().log(Level.SEVERE, "Errors were encountered while exporting:\n{0}", Op.join(errors, "\n"));
            throw new RuntimeException(Op.join(errors, "\n"));
        }
        FuzzyLite.logger().info("No errors were found exporting files");
    }

    public void benchmark(File fllFile, File fldFile, int runs, Writer writer) throws Exception {
        Engine engine = new FllImporter().fromFile(fllFile);
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fldFile), FuzzyLite.UTF_8);
        try {
            Benchmark benchmark = new Benchmark(engine.getName(), engine);
            benchmark.prepare(reader);
            if (writer != null) {
                FuzzyLite.logger().log(Level.INFO, "\tEvaluating on {0} values read from {1}", new Object[]{benchmark.getExpected().size(), fldFile.getAbsolutePath()});
            }
            for (int i = 0; i < runs; ++i) {
                benchmark.runOnce();
            }
            String results = benchmark.format(benchmark.results(), Benchmark.TableShape.Horizontal, Benchmark.TableContents.Body) + "\n";
            if (writer != null) {
                double[] times = new double[benchmark.getTimes().size()];
                for (int i = 0; i < benchmark.getTimes().size(); ++i) {
                    times[i] = benchmark.getTimes().get(i);
                }
                FuzzyLite.logger().log(Level.INFO, "\tMean(t)={0}", Op.str(Op.mean(times)));
                writer.write(results);
                writer.flush();
            } else {
                System.out.println(results);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public void benchmarks(File fllFileList, File fldFileList, int runs, Writer writer) throws Exception {
        ArrayList<String> fllFiles = new ArrayList<String>();
        ArrayList<String> fldFiles = new ArrayList<String>();
        BufferedReader fllReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fllFileList), FuzzyLite.UTF_8));
        BufferedReader fldReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fldFileList), FuzzyLite.UTF_8));
        try {
            String fldLine;
            String fllLine;
            while ((fllLine = fllReader.readLine()) != null && (fldLine = fldReader.readLine()) != null) {
                fllLine = fllLine.trim();
                fldLine = fldLine.trim();
                if (fllLine.isEmpty() || fllLine.charAt(0) == '#') continue;
                fllFiles.add(fllLine);
                fldFiles.add(fldLine);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            fllReader.close();
            fldReader.close();
        }
        if (writer != null) {
            writer.write(Op.join(new Benchmark().header(runs, true), "\t") + "\n");
            writer.flush();
        } else {
            System.out.println(Op.join(new Benchmark().header(runs, true), "\t"));
        }
        for (int i = 0; i < fllFiles.size(); ++i) {
            if (writer != null) {
                FuzzyLite.logger().log(Level.INFO, "Benchmark {0}/{1}: {2}", new Object[]{i + 1, fllFiles.size(), fllFiles.get(i)});
            }
            this.benchmark(new File((String)fllFiles.get(i)), new File((String)fldFiles.get(i)), runs, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FuzzyLite.setLogging(true);
        Console console = new Console();
        if (args.length == 0) {
            System.out.println(console.usage());
            System.exit(0);
            return;
        }
        if ("export-examples".equals(args[0])) {
            String path = ".";
            if (args.length >= 2) {
                path = args[1];
            }
            String outputPath = "/tmp/";
            if (args.length >= 3) {
                outputPath = args[2];
            }
            FuzzyLite.setDecimals(3);
            try {
                console.exportAllExamples("fll", "fll", path, outputPath);
                console.exportAllExamples("fll", "fcl", path, outputPath);
                console.exportAllExamples("fll", "fis", path, outputPath);
                console.exportAllExamples("fll", "cpp", path, outputPath);
                console.exportAllExamples("fll", "java", path, outputPath);
                console.exportAllExamples("fll", "R", path, outputPath);
                FuzzyLite.setDecimals(9);
                console.exportAllExamples("fll", "fld", path, outputPath);
                FuzzyLite.logger().log(Level.INFO, "Origin={0}", path);
                FuzzyLite.logger().log(Level.INFO, "Target={0}", outputPath);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.console().writer());
                System.exit(1);
                return;
            }
            finally {
                System.out.println("Please, make sure the output contains the following structure:\nmkdir -p " + outputPath + "mamdani/matlab; " + "mkdir -p " + outputPath + "mamdani/octave; " + "mkdir -p " + outputPath + "takagi-sugeno/matlab; " + "mkdir -p " + outputPath + "takagi-sugeno/octave; " + "mkdir -p " + outputPath + "tsukamoto; " + "mkdir -p " + outputPath + "hybrid;");
            }
            System.exit(0);
            return;
        }
        if ("benchmark".equals(args[0])) {
            if (args.length < 4) {
                System.out.println("[error] not enough arguments");
                System.exit(1);
                return;
            }
            File fllFile = new File(args[1]);
            File fldFile = new File(args[2]);
            int runs = Integer.parseInt(args[3]);
            Writer writer = null;
            if (args.length > 4) {
                try {
                    File outputFile = new File(args[4]);
                    outputFile.createNewFile();
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), FuzzyLite.UTF_8));
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.console().writer());
                    System.exit(1);
                    return;
                }
            }
            try {
                if (writer != null) {
                    writer.write(Op.join(new Benchmark().header(runs, true), "\t"));
                } else {
                    System.out.println(Op.join(new Benchmark().header(runs, true), "\t"));
                }
                console.benchmark(fllFile, fldFile, runs, writer);
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.console().writer());
                System.exit(1);
                return;
            }
            System.exit(0);
            return;
        }
        if ("benchmarks".equals(args[0])) {
            if (args.length < 4) {
                System.out.println("[error] not enough arguments");
                System.exit(1);
                return;
            }
            File fllFiles = new File(args[1]);
            File fldFiles = new File(args[2]);
            int runs = Integer.parseInt(args[3]);
            Writer writer = null;
            if (args.length > 4) {
                try {
                    File outputFile = new File(args[4]);
                    outputFile.createNewFile();
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), FuzzyLite.UTF_8));
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.console().writer());
                    System.exit(1);
                    return;
                }
            }
            try {
                console.benchmarks(fllFiles, fldFiles, runs, writer);
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.console().writer());
                System.exit(1);
                return;
            }
            System.exit(0);
            return;
        }
        try {
            Map<String, String> options = console.parse(args);
            console.process(options);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.console().writer());
            System.exit(1);
            return;
        }
        System.exit(0);
    }

    static class Option {
        public final String key;
        public final String value;
        public final String description;

        public Option(String key, String value, String description) {
            this.key = key;
            this.value = value;
            this.description = description;
        }
    }
}

