/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite;

import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.activation.Activation;
import com.fuzzylite.activation.General;
import com.fuzzylite.defuzzifier.Defuzzifier;
import com.fuzzylite.defuzzifier.IntegralDefuzzifier;
import com.fuzzylite.defuzzifier.WeightedDefuzzifier;
import com.fuzzylite.factory.FactoryManager;
import com.fuzzylite.factory.SNormFactory;
import com.fuzzylite.factory.TNormFactory;
import com.fuzzylite.imex.FllExporter;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.norm.t.AlgebraicProduct;
import com.fuzzylite.rule.Consequent;
import com.fuzzylite.rule.Proposition;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import com.fuzzylite.term.Term;
import com.fuzzylite.variable.InputVariable;
import com.fuzzylite.variable.OutputVariable;
import com.fuzzylite.variable.Variable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class Engine
implements Op.Cloneable {
    private String name;
    private String description;
    private List<InputVariable> inputVariables;
    private List<OutputVariable> outputVariables;
    private List<RuleBlock> ruleBlocks;

    public Engine() {
        this("");
    }

    public Engine(String name) {
        this.name = name;
        this.description = "";
        this.inputVariables = new ArrayList<InputVariable>();
        this.outputVariables = new ArrayList<OutputVariable>();
        this.ruleBlocks = new ArrayList<RuleBlock>();
    }

    public void configure(String conjunction, String disjunction, String implication, String aggregation, String defuzzifier, String activation) {
        TNormFactory tnormFactory = FactoryManager.instance().tnorm();
        SNormFactory snormFactory = FactoryManager.instance().snorm();
        TNorm conjunctionObject = (TNorm)tnormFactory.constructObject(conjunction);
        SNorm disjunctionObject = (SNorm)snormFactory.constructObject(disjunction);
        TNorm implicationObject = (TNorm)tnormFactory.constructObject(implication);
        SNorm aggregationObject = (SNorm)snormFactory.constructObject(aggregation);
        Defuzzifier defuzzifierObject = (Defuzzifier)FactoryManager.instance().defuzzifier().constructObject(defuzzifier);
        Activation activationObject = (Activation)FactoryManager.instance().activation().constructObject(activation);
        this.configure(conjunctionObject, disjunctionObject, implicationObject, aggregationObject, defuzzifierObject, activationObject);
    }

    public void configure(TNorm conjunction, SNorm disjunction, TNorm implication, SNorm aggregation, Defuzzifier defuzzifier, Activation activation) {
        try {
            for (RuleBlock ruleblock : this.ruleBlocks) {
                ruleblock.setConjunction(conjunction == null ? null : conjunction.clone());
                ruleblock.setDisjunction(disjunction == null ? null : disjunction.clone());
                ruleblock.setImplication(implication == null ? null : implication.clone());
                ruleblock.setActivation(activation == null ? new General() : activation.clone());
            }
            for (OutputVariable outputVariable : this.outputVariables) {
                outputVariable.setDefuzzifier(defuzzifier == null ? null : defuzzifier.clone());
                outputVariable.setAggregation(aggregation == null ? null : aggregation.clone());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isReady() {
        return this.isReady(new StringBuilder());
    }

    public boolean isReady(StringBuilder message) {
        int i;
        message.setLength(0);
        if (this.inputVariables.isEmpty()) {
            message.append("- Engine has no input variables\n");
        }
        for (i = 0; i < this.inputVariables.size(); ++i) {
            InputVariable inputVariable = this.inputVariables.get(i);
            if (inputVariable != null) continue;
            message.append(String.format("- Engine has a null input variable at index <%d>\n", i));
        }
        if (this.outputVariables.isEmpty()) {
            message.append("- Engine has no output variables\n");
        }
        for (i = 0; i < this.outputVariables.size(); ++i) {
            Defuzzifier defuzzifier;
            OutputVariable outputVariable = this.outputVariables.get(i);
            if (outputVariable == null) {
                message.append(String.format("- Engine has a null output variable at index <%d>\n", i));
                continue;
            }
            if (outputVariable.getTerms().isEmpty()) {
                message.append(String.format("- Output variable <%s> has no terms\n", outputVariable.getName()));
            }
            if ((defuzzifier = outputVariable.getDefuzzifier()) == null) {
                message.append(String.format("- Output variable <%s> has no defuzzifier\n", outputVariable.getName()));
                continue;
            }
            if (!(defuzzifier instanceof IntegralDefuzzifier) || outputVariable.fuzzyOutput().getAggregation() != null) continue;
            message.append(String.format("- Output variable <%s> has no Accumulation\n", outputVariable.getName()));
        }
        if (this.ruleBlocks.isEmpty()) {
            message.append("- Engine has no rule blocks\n");
        }
        for (i = 0; i < this.ruleBlocks.size(); ++i) {
            RuleBlock ruleBlock = this.ruleBlocks.get(i);
            if (ruleBlock == null) {
                message.append(String.format("- Engine has a null rule block at index <%d>\n", i));
                continue;
            }
            if (ruleBlock.getRules().isEmpty()) {
                message.append(String.format("- Rule block <%s> has no rules\n", ruleBlock.getName()));
            }
            int requiresConjunction = 0;
            int requiresDisjunction = 0;
            int requiresImplication = 0;
            block3: for (int r = 0; r < ruleBlock.numberOfRules(); ++r) {
                Rule rule = ruleBlock.getRule(r);
                if (rule == null) {
                    message.append(String.format("- Rule block <%s> has a null rule at index <%d>\n", ruleBlock.getName(), r));
                    continue;
                }
                int thenIndex = rule.getText().indexOf(" then ");
                int andIndex = rule.getText().indexOf(" and ");
                int orIndex = rule.getText().indexOf(" or ");
                if (andIndex != -1 && andIndex < thenIndex) {
                    ++requiresConjunction;
                }
                if (orIndex != -1 && orIndex < thenIndex) {
                    ++requiresDisjunction;
                }
                if (!rule.isLoaded()) continue;
                Consequent consequent = rule.getConsequent();
                for (Proposition proposition : consequent.getConclusions()) {
                    OutputVariable outputVariable;
                    Variable variable = proposition.getVariable();
                    if (!(variable instanceof OutputVariable) || !((outputVariable = (OutputVariable)variable).getDefuzzifier() instanceof IntegralDefuzzifier)) continue;
                    ++requiresImplication;
                    continue block3;
                }
            }
            if (requiresConjunction > 0 && ruleBlock.getConjunction() == null) {
                message.append(String.format("- Rule block <%s> has no conjunction operator\n", ruleBlock.getName()));
                message.append(String.format("- Rule block <%s> has %d rules that require conjunction operator", ruleBlock.getName(), requiresConjunction));
            }
            if (requiresDisjunction > 0 && ruleBlock.getDisjunction() == null) {
                message.append(String.format("- Rule block <%s> has no disjunction operator\n", ruleBlock.getName()));
                message.append(String.format("- Rule block <%s> has %d rules that require disjunction operator", ruleBlock.getName(), requiresDisjunction));
            }
            if (requiresImplication <= 0 || ruleBlock.getImplication() != null) continue;
            message.append(String.format("- Rule block <%s> has no implication operator\n", ruleBlock.getName()));
            message.append(String.format("- Rule block <%s> has %d rules that require implication operator", ruleBlock.getName(), requiresImplication));
        }
        return message.length() == 0;
    }

    public void restart() {
        for (InputVariable inputVariable : this.inputVariables) {
            inputVariable.setValue(Double.NaN);
        }
        for (OutputVariable outputVariable : this.outputVariables) {
            outputVariable.clear();
        }
    }

    public void process() {
        for (OutputVariable outputVariable : this.outputVariables) {
            outputVariable.fuzzyOutput().clear();
        }
        if (FuzzyLite.isDebugging()) {
            FuzzyLite.logger().log(Level.FINE, "===============");
            FuzzyLite.logger().log(Level.FINE, "CURRENT INPUTS:");
            for (InputVariable inputVariable : this.inputVariables) {
                double inputValue = inputVariable.getValue();
                if (inputVariable.isEnabled()) {
                    FuzzyLite.logger().fine(String.format("%s.input = %s\n%s.fuzzy = %s", inputVariable.getName(), Op.str(inputValue), inputVariable.getName(), inputVariable.fuzzify(inputValue)));
                    continue;
                }
                FuzzyLite.logger().fine(String.format("%s.enabled = false", inputVariable.getName()));
            }
        }
        for (RuleBlock ruleBlock : this.ruleBlocks) {
            if (!ruleBlock.isEnabled()) continue;
            if (FuzzyLite.isDebugging()) {
                FuzzyLite.logger().log(Level.FINE, "===============");
                FuzzyLite.logger().log(Level.FINE, "RULE BLOCK: {0}", ruleBlock.getName());
            }
            ruleBlock.activate();
        }
        for (OutputVariable outputVariable : this.outputVariables) {
            outputVariable.defuzzify();
        }
        if (FuzzyLite.isDebugging()) {
            FuzzyLite.logger().log(Level.FINE, "===============");
            FuzzyLite.logger().log(Level.FINE, "CURRENT OUTPUTS:");
            for (OutputVariable outputVariable : this.outputVariables) {
                if (outputVariable.isEnabled()) {
                    FuzzyLite.logger().fine(String.format("%s.default = %s", outputVariable.getName(), Op.str(outputVariable.getDefaultValue())));
                    FuzzyLite.logger().fine(String.format("%s.lockValueInRange = %s", outputVariable.getName(), String.valueOf(outputVariable.isLockValueInRange())));
                    FuzzyLite.logger().fine(String.format("%s.lockPreviousValue= %s", outputVariable.getName(), String.valueOf(outputVariable.isLockPreviousValue())));
                    double outputValue = outputVariable.getValue();
                    FuzzyLite.logger().fine(String.format("%s.output = %s", outputVariable.getName(), Op.str(outputValue)));
                    FuzzyLite.logger().fine(String.format("%s.fuzzy = %s", outputVariable.getName(), outputVariable.fuzzify(outputValue)));
                    FuzzyLite.logger().fine(outputVariable.fuzzyOutput().toString());
                    FuzzyLite.logger().fine("==========================");
                    continue;
                }
                FuzzyLite.logger().fine(String.format("%s.enabled = false", outputVariable.getName()));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return new FllExporter().toString(this);
    }

    /*
     * WARNING - void declaration
     */
    public Type type(StringBuilder reason) {
        int n;
        int n2;
        boolean bl;
        boolean bl2;
        boolean larsen;
        reason.setLength(0);
        if (this.outputVariables.isEmpty()) {
            reason.append("- Engine has no output variables");
            return Type.Unknown;
        }
        boolean mamdani = true;
        for (OutputVariable outputVariable : this.outputVariables) {
            mamdani &= outputVariable.getDefuzzifier() instanceof IntegralDefuzzifier;
        }
        boolean bl3 = larsen = mamdani && !this.ruleBlocks.isEmpty();
        if (mamdani) {
            for (RuleBlock ruleBlock : this.ruleBlocks) {
                larsen &= ruleBlock.getImplication() instanceof AlgebraicProduct;
            }
        }
        if (larsen) {
            reason.append("- Output variables have integral defuzzifiers\n").append("- Rule blocks activate using the algebraic product T-Norm");
            return Type.Larsen;
        }
        if (mamdani) {
            reason.append("-Output variables have integral defuzzifiers");
            return Type.Mamdani;
        }
        boolean bl4 = true;
        for (OutputVariable outputVariable : this.outputVariables) {
            void var7_18;
            WeightedDefuzzifier weightedDefuzzifier;
            Object var7_19 = null;
            bl2 = outputVariable.getDefuzzifier() instanceof WeightedDefuzzifier ? (bl2 &= (weightedDefuzzifier = (WeightedDefuzzifier)outputVariable.getDefuzzifier()).getType() == WeightedDefuzzifier.Type.Automatic || weightedDefuzzifier.getType() == WeightedDefuzzifier.Type.TakagiSugeno) : false;
            if (!bl2 || var7_18 == null) continue;
            Iterator<Term> it = outputVariable.getTerms().iterator();
            while (bl2 && it.hasNext()) {
                bl2 &= var7_18.inferType(it.next()) == WeightedDefuzzifier.Type.TakagiSugeno;
            }
        }
        if (bl2) {
            reason.append("- Output variables have weighted defuzzifiers\n").append("- Output variables have constant, linear or function terms");
            return Type.TakagiSugeno;
        }
        boolean bl5 = true;
        for (OutputVariable outputVariable : this.outputVariables) {
            WeightedDefuzzifier weightedDefuzzifier = null;
            bl = outputVariable.getDefuzzifier() instanceof WeightedDefuzzifier ? (bl &= (weightedDefuzzifier = (WeightedDefuzzifier)outputVariable.getDefuzzifier()).getType() == WeightedDefuzzifier.Type.Automatic || weightedDefuzzifier.getType() == WeightedDefuzzifier.Type.Tsukamoto) : false;
            if (!bl || weightedDefuzzifier == null) continue;
            Iterator<Term> it = outputVariable.getTerms().iterator();
            while (bl && it.hasNext()) {
                bl &= it.next().isMonotonic();
            }
        }
        if (bl) {
            reason.append("- Output variables have weighted defuzzifiers\n").append("- Output variables only have monotonic terms");
            return Type.Tsukamoto;
        }
        boolean bl6 = true;
        for (OutputVariable outputVariable : this.outputVariables) {
            Defuzzifier defuzzifier = outputVariable.getDefuzzifier();
            n2 &= defuzzifier != null && defuzzifier instanceof WeightedDefuzzifier ? 1 : 0;
        }
        if (n2 != 0) {
            reason.append("- Output variables have weighted defuzzifiers\n").append("- Output variables do not only have constant, linear or function terms\n").append("- Output variables do not only have monotonic terms\n");
            return Type.InverseTsukamoto;
        }
        boolean bl7 = true;
        for (OutputVariable outputVariable : this.outputVariables) {
            n &= outputVariable.getDefuzzifier() != null ? 1 : 0;
        }
        if (n != 0) {
            reason.append("- Output variables have different types of defuzzifiers");
            return Type.Hybrid;
        }
        reason.append("- One or more output variables do not have a defuzzifier");
        return Type.Unknown;
    }

    public Type type() {
        return this.type(new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Engine clone() throws CloneNotSupportedException {
        Engine result = (Engine)super.clone();
        result.inputVariables = new ArrayList<InputVariable>(this.inputVariables.size());
        for (InputVariable inputVariable : this.inputVariables) {
            result.inputVariables.add(inputVariable.clone());
        }
        result.outputVariables = new ArrayList<OutputVariable>(this.outputVariables.size());
        for (OutputVariable outputVariable : this.outputVariables) {
            result.outputVariables.add(outputVariable.clone());
        }
        for (Variable variable : this.variables()) {
            for (Term term : variable.getTerms()) {
                term.updateReference(result);
            }
        }
        result.ruleBlocks = new ArrayList<RuleBlock>(this.ruleBlocks.size());
        for (RuleBlock ruleBlock : this.ruleBlocks) {
            RuleBlock ruleBlockClone = ruleBlock.clone();
            try {
                ruleBlockClone.loadRules(result);
            }
            finally {
                result.ruleBlocks.add(ruleBlockClone);
            }
        }
        return result;
    }

    public List<Variable> variables() {
        ArrayList<Variable> result = new ArrayList<Variable>(this.inputVariables.size() + this.outputVariables.size());
        result.addAll(this.inputVariables);
        result.addAll(this.outputVariables);
        return result;
    }

    public void setInputValue(String name, double value) {
        InputVariable inputVariable = this.getInputVariable(name);
        inputVariable.setValue(value);
    }

    public InputVariable getInputVariable(String name) {
        for (InputVariable inputVariable : this.inputVariables) {
            if (!name.equals(inputVariable.getName())) continue;
            return inputVariable;
        }
        throw new RuntimeException(String.format("[engine error] no input variable by name <%s>", name));
    }

    public InputVariable getInputVariable(int index) {
        return this.inputVariables.get(index);
    }

    public void addInputVariable(InputVariable inputVariable) {
        this.inputVariables.add(inputVariable);
    }

    public boolean removeInputVariable(InputVariable inputVariable) {
        return this.inputVariables.remove(inputVariable);
    }

    public InputVariable removeInputVariable(String name) {
        Iterator<InputVariable> it = this.inputVariables.iterator();
        while (it.hasNext()) {
            InputVariable inputVariable = it.next();
            if (!inputVariable.getName().equals(name)) continue;
            it.remove();
            return inputVariable;
        }
        throw new RuntimeException(String.format("[engine error] no input variable by name <%s>", name));
    }

    public InputVariable removeInputVariable(int index) {
        return this.inputVariables.remove(index);
    }

    public boolean hasInputVariable(String name) {
        for (InputVariable inputVariable : this.inputVariables) {
            if (!inputVariable.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public int numberOfInputVariables() {
        return this.inputVariables.size();
    }

    public List<InputVariable> getInputVariables() {
        return this.inputVariables;
    }

    public void setInputVariables(List<InputVariable> inputVariables) {
        this.inputVariables = inputVariables;
    }

    public double getOutputValue(String name) {
        return this.getOutputVariable(name).getValue();
    }

    public OutputVariable getOutputVariable(String name) {
        for (OutputVariable outputVariable : this.outputVariables) {
            if (!outputVariable.getName().equals(name)) continue;
            return outputVariable;
        }
        throw new RuntimeException(String.format("[engine error] no output variable by name <%s>", name));
    }

    public OutputVariable getOutputVariable(int index) {
        return this.outputVariables.get(index);
    }

    public void addOutputVariable(OutputVariable outputVariable) {
        this.outputVariables.add(outputVariable);
    }

    public boolean removeOutputVariable(OutputVariable outputVariable) {
        return this.outputVariables.remove(outputVariable);
    }

    public OutputVariable removeOutputVariable(String name) {
        Iterator<OutputVariable> it = this.outputVariables.iterator();
        while (it.hasNext()) {
            OutputVariable outputVariable = it.next();
            if (!outputVariable.getName().equals(name)) continue;
            it.remove();
            return outputVariable;
        }
        throw new RuntimeException(String.format("[engine error] no output variable by name <%s>", name));
    }

    public OutputVariable removeOutputVariable(int index) {
        return this.outputVariables.remove(index);
    }

    public boolean hasOutputVariable(String name) {
        for (OutputVariable outputVariable : this.outputVariables) {
            if (!outputVariable.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public int numberOfOutputVariables() {
        return this.outputVariables.size();
    }

    public List<OutputVariable> getOutputVariables() {
        return this.outputVariables;
    }

    public void setOutputVariables(List<OutputVariable> outputVariables) {
        this.outputVariables = outputVariables;
    }

    public RuleBlock getRuleBlock(String name) {
        for (RuleBlock ruleBlock : this.ruleBlocks) {
            if (!ruleBlock.getName().equals(name)) continue;
            return ruleBlock;
        }
        throw new RuntimeException(String.format("[engine error] no rule block by name <%s>", name));
    }

    public RuleBlock getRuleBlock(int index) {
        return this.ruleBlocks.get(index);
    }

    public void addRuleBlock(RuleBlock ruleBlock) {
        this.ruleBlocks.add(ruleBlock);
    }

    public boolean removeRuleBlock(RuleBlock ruleBlock) {
        return this.ruleBlocks.remove(ruleBlock);
    }

    public RuleBlock removeRuleBlock(String name) {
        Iterator<RuleBlock> it = this.ruleBlocks.iterator();
        while (it.hasNext()) {
            RuleBlock ruleBlock = it.next();
            if (!ruleBlock.getName().equals(name)) continue;
            it.remove();
            return ruleBlock;
        }
        throw new RuntimeException(String.format("[engine error] no rule block by name <%s>", name));
    }

    public RuleBlock removeRuleBlock(int index) {
        return this.ruleBlocks.remove(index);
    }

    public boolean hasRuleBlock(String name) {
        for (RuleBlock ruleBlock : this.ruleBlocks) {
            if (!ruleBlock.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public int numberOfRuleBlocks() {
        return this.ruleBlocks.size();
    }

    public List<RuleBlock> getRuleBlocks() {
        return this.ruleBlocks;
    }

    public void setRuleBlocks(List<RuleBlock> ruleBlocks) {
        this.ruleBlocks = ruleBlocks;
    }

    public static enum Type {
        Mamdani,
        Larsen,
        TakagiSugeno,
        Tsukamoto,
        InverseTsukamoto,
        Hybrid,
        Unknown;

    }
}

